/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.combobox;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.util.Callback;
import jidefx.scene.control.combobox.FormattedComboBox;
import jidefx.scene.control.field.FormattedTextField;
import jidefx.scene.control.field.LocalDateField;
import jidefx.scene.control.field.popup.PopupContent;

public class LocalDateComboBox
extends FormattedComboBox<LocalDate> {
    private static final String STYLE_CLASS_DEFAULT = "local-date-combo-box";
    private StringProperty _patternProperty;

    public LocalDateComboBox() {
        this(((SimpleDateFormat)SimpleDateFormat.getDateInstance()).toPattern(), LocalDate.now());
    }

    public LocalDateComboBox(String pattern) {
        this(pattern, LocalDate.now());
    }

    public LocalDateComboBox(LocalDate value) {
        this(((SimpleDateFormat)SimpleDateFormat.getDateInstance()).toPattern(), value);
    }

    public LocalDateComboBox(String pattern, LocalDate value) {
        super(value);
        this.setPattern(pattern);
    }

    @Override
    protected void initializeStyle() {
        super.initializeStyle();
        this.getStyleClass().add((Object)STYLE_CLASS_DEFAULT);
    }

    public StringProperty patternProperty() {
        if (this._patternProperty == null) {
            this._patternProperty = new SimpleStringProperty();
        }
        return this._patternProperty;
    }

    public String getPattern() {
        return (String)this.patternProperty().get();
    }

    public void setPattern(String pattern) {
        this.patternProperty().set((Object)pattern);
    }

    @Override
    protected FormattedTextField<LocalDate> createFormattedTextField() {
        LocalDateField field = new LocalDateField(this.getPattern());
        field.patternProperty().bind((ObservableValue)this.patternProperty());
        return field;
    }

    @Override
    protected void initializeComboBox() {
        super.initializeComboBox();
        this.setPopupContentFactory(new Callback<LocalDate, PopupContent<LocalDate>>(){

            public PopupContent<LocalDate> call(LocalDate param) {
                PopupContent popupContent = (PopupContent)((LocalDateField)LocalDateComboBox.this.getEditor()).getPopupContentFactory().call((Object)param);
                popupContent.valueProperty().addListener((ChangeListener)new ChangeListener<LocalDate>(){

                    public void changed(ObservableValue<? extends LocalDate> observable, LocalDate oldValue, LocalDate newValue) {
                        LocalDateComboBox.this.hide();
                    }
                });
                return popupContent;
            }
        });
    }
}

