/*
 * Decompiled with CFR 0.152.
 */
package com.jgeppert.struts2.jquery.components;

import com.jgeppert.struts2.jquery.components.AbstractFormListElement;
import com.opensymphony.xwork2.util.ValueStack;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.views.annotations.StrutsTag;
import org.apache.struts2.views.annotations.StrutsTagAttribute;
import org.apache.struts2.views.annotations.StrutsTagSkipInheritance;

@StrutsTag(name="select", tldTagClass="com.jgeppert.struts2.jquery.views.jsp.ui.SelectTag", description="Render HTML select box providing content from remote call via AJAX", allowDynamicAttributes=true)
public class Select
extends AbstractFormListElement {
    public static final String TEMPLATE = "select";
    public static final String TEMPLATE_CLOSE = "select-close";
    public static final String COMPONENT_NAME = Select.class.getName();
    private static final transient Random RANDOM = new Random();
    public static final String JQUERYACTION = "select";
    protected String emptyOption;
    protected String headerKey;
    protected String headerValue;
    protected String list;
    protected String listKey;
    protected String listValue;
    protected String size;
    protected String multiple;
    protected String autocomplete;
    protected String loadMinimumCount;
    protected String selectBoxIcon;

    public Select(ValueStack stack, HttpServletRequest request, HttpServletResponse response) {
        super(stack, request, response);
    }

    public String getDefaultOpenTemplate() {
        return "select";
    }

    protected String getDefaultTemplate() {
        return TEMPLATE_CLOSE;
    }

    public void evaluateExtraParams() {
        super.evaluateExtraParams();
        this.addParameter("jqueryaction", "select");
        if (this.emptyOption != null) {
            this.addParameter("emptyOption", this.findValue(this.emptyOption, Boolean.class));
        }
        if (this.headerKey != null && this.headerValue != null) {
            this.addParameter("headerKey", this.findString(this.headerKey));
            this.addParameter("headerValue", this.findString(this.headerValue));
        }
        if (this.list != null) {
            this.addParameter("list", this.findString(this.list));
        }
        if (this.listKey != null) {
            this.addParameter("listKey", this.findString(this.listKey));
        }
        if (this.listValue != null) {
            this.addParameter("listValue", this.findString(this.listValue));
        }
        if (this.size != null) {
            this.addParameter("size", this.findString(this.size));
        }
        if (this.multiple != null) {
            this.addParameter("multiple", this.findValue(this.multiple, Boolean.class));
        }
        if (this.autocomplete != null) {
            this.addParameter("autocomplete", this.findValue(this.autocomplete, Boolean.class));
        }
        if (this.selectBoxIcon != null) {
            this.addParameter("selectBoxIcon", this.findValue(this.selectBoxIcon, Boolean.class));
        }
        if (this.loadMinimumCount != null) {
            this.addParameter("loadMinimumCount", this.findValue(this.loadMinimumCount, Integer.class));
        }
        if (this.id == null || this.id.length() == 0) {
            int nextInt = RANDOM.nextInt();
            nextInt = nextInt == Integer.MIN_VALUE ? Integer.MAX_VALUE : Math.abs(nextInt);
            this.id = "select_" + String.valueOf(nextInt);
            this.addParameter("id", this.id);
        }
    }

    @StrutsTagSkipInheritance
    public void setTheme(String theme) {
        super.setTheme(theme);
    }

    public String getTheme() {
        return "jquery";
    }

    @StrutsTagAttribute(description="Add an empty option after the header option", defaultValue="false", type="Boolean")
    public void setEmptyOption(String emptyOption) {
        this.emptyOption = emptyOption;
    }

    @StrutsTagAttribute(description="Key for list header option. Must not be empty", type="String", defaultValue="")
    public void setHeaderKey(String headerKey) {
        this.headerKey = headerKey;
    }

    @StrutsTagAttribute(description="Value for list header option. Must not be empty", type="String", defaultValue="")
    public void setHeaderValue(String headerValue) {
        this.headerValue = headerValue;
    }

    @StrutsTagAttribute(description="Name of the JSON list", required=false)
    public void setList(String list) {
        this.list = list;
    }

    @StrutsTagAttribute(description="Property of list objects to get field value from", required=false)
    public void setListKey(String listKey) {
        this.listKey = listKey;
    }

    @StrutsTagAttribute(description="Property of list objects to get field content from", required=false)
    public void setListValue(String listValue) {
        this.listValue = listValue;
    }

    @StrutsTagAttribute(description="HTML size attribute", type="Integer")
    public void setSize(String size) {
        this.size = size;
    }

    @StrutsTagAttribute(description=" Creates a multiple select. The tag will pre-select multiple values if the values are passed as an Array or a Collection(of appropriate types) via the value attribute. If one of the keys equals one of the values in the Collection or Array it wil be selected", type="Boolean", defaultValue="false")
    public void setMultiple(String multiple) {
        this.multiple = multiple;
    }

    @StrutsTagAttribute(description="use autocomplete for this select box", defaultValue="false", type="Boolean")
    public void setAutocomplete(String autocomplete) {
        this.autocomplete = autocomplete;
    }

    @StrutsTagAttribute(description="display the select box icon, only valid when autocomplete is true", type="Boolean", defaultValue="false")
    public void setSelectBoxIcon(String selectBoxIcon) {
        this.selectBoxIcon = selectBoxIcon;
    }

    @StrutsTagAttribute(description="Minimum number of characters that will force the content to be loaded, only valid when autocomplet is true", type="Integer", defaultValue="1")
    public void setLoadMinimumCount(String loadMinimumCount) {
        this.loadMinimumCount = loadMinimumCount;
    }
}

