/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.model;

import com.jerolba.carpet.model.BinaryLogicalType;
import com.jerolba.carpet.model.FieldType;
import java.util.Set;

public record StringType(boolean isNotNull, BinaryLogicalType logicalType) implements FieldType
{
    private static final Set<BinaryLogicalType> VALID_LOGICAL_TYPES = Set.of(BinaryLogicalType.STRING, BinaryLogicalType.ENUM, BinaryLogicalType.JSON);

    public StringType {
        if (logicalType != null && !VALID_LOGICAL_TYPES.contains((Object)logicalType)) {
            throw new IllegalArgumentException("Invalid logical type for StringType: " + String.valueOf((Object)logicalType));
        }
    }

    public StringType notNull() {
        return new StringType(true, this.logicalType);
    }

    public StringType asJson() {
        return new StringType(this.isNotNull, BinaryLogicalType.JSON);
    }

    public StringType asEnum() {
        return new StringType(this.isNotNull, BinaryLogicalType.ENUM);
    }

    public Class<String> getClassType() {
        return String.class;
    }
}

