/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl.write;

import com.jerolba.carpet.model.ToBooleanFunction;
import com.jerolba.carpet.model.ToByteFunction;
import com.jerolba.carpet.model.ToFloatFunction;
import com.jerolba.carpet.model.ToShortFunction;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaConversionException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.RecordComponent;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;

public class Reflection {
    private static final ConcurrentHashMap<CacheKey, Function<Object, Object>> ACCESSOR_CACHE = new ConcurrentHashMap();
    private static final ConcurrentHashMap<CacheKey, Object> PRIMITIVE_ACCESSOR_CACHE = new ConcurrentHashMap();

    private Reflection() {
    }

    public static Function<Object, Object> recordAccessor(Class<?> targetClass, RecordComponent recordComponent) {
        return Reflection.cachedFieldAccessor(targetClass, recordComponent.getName(), recordComponent.getType());
    }

    public static Function<Object, Object> recordAccessor(Class<?> targetClass, Field classField) {
        return Reflection.cachedFieldAccessor(targetClass, classField.getName(), classField.getType());
    }

    private static Function<Object, Object> cachedFieldAccessor(Class<?> targetClass, String name, Class<?> fieldType) {
        CacheKey cacheKey = new CacheKey(targetClass, name, fieldType);
        return ACCESSOR_CACHE.computeIfAbsent(cacheKey, k -> Reflection.fieldAccessor(targetClass, name, fieldType));
    }

    private static Function<Object, Object> fieldAccessor(Class<?> targetClass, String name, Class<?> fieldType) {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodHandle methodHandle = null;
            try {
                methodHandle = lookup.findVirtual(targetClass, name, MethodType.methodType(fieldType));
            }
            catch (IllegalAccessException e) {
                try {
                    MethodHandles.Lookup privateLookup = MethodHandles.privateLookupIn(targetClass, lookup);
                    methodHandle = privateLookup.findVirtual(targetClass, name, MethodType.methodType(fieldType));
                    lookup = privateLookup;
                }
                catch (IllegalAccessException e1) {
                    return Reflection.viaDeclaredMethod(targetClass, name, lookup);
                }
            }
            try {
                CallSite site = LambdaMetafactory.metafactory(lookup, "apply", MethodType.methodType(Function.class), MethodType.methodType(Object.class, Object.class), methodHandle, MethodType.methodType(fieldType, targetClass));
                return site.getTarget().invokeExact();
            }
            catch (Throwable e) {
                return Reflection.viaDeclaredMethod(targetClass, name, lookup);
            }
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private static Function<Object, Object> viaDeclaredMethod(Class<?> targetClass, String name, MethodHandles.Lookup lookup) throws NoSuchMethodException {
        try {
            Method m = targetClass.getDeclaredMethod(name, new Class[0]);
            m.setAccessible(true);
            MethodHandle pmh = lookup.unreflect(m);
            return obj -> {
                try {
                    return pmh.invoke(obj);
                }
                catch (Throwable t2) {
                    throw new RuntimeException(t2);
                }
            };
        }
        catch (IllegalAccessException em) {
            throw new RuntimeException(em);
        }
    }

    public static Object intFieldAccessor(Class<?> targetClass, String name) {
        CacheKey cacheKey = new CacheKey(targetClass, name, Integer.TYPE);
        return PRIMITIVE_ACCESSOR_CACHE.computeIfAbsent(cacheKey, k -> Reflection.buildIntAccessor(targetClass, name));
    }

    private static ToIntFunction<Object> buildIntAccessor(Class<?> targetClass, String name) {
        try {
            MethodHandle methodHandle = Reflection.createMethodHandle(targetClass, name, Integer.TYPE, "applyAsInt", ToIntFunction.class);
            return methodHandle.invokeExact();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static Object longFieldAccessor(Class<?> targetClass, String name) {
        CacheKey cacheKey = new CacheKey(targetClass, name, Long.TYPE);
        return PRIMITIVE_ACCESSOR_CACHE.computeIfAbsent(cacheKey, k -> Reflection.buildLongAccessor(targetClass, name));
    }

    private static ToLongFunction<Object> buildLongAccessor(Class<?> targetClass, String name) {
        try {
            MethodHandle methodHandle = Reflection.createMethodHandle(targetClass, name, Long.TYPE, "applyAsLong", ToLongFunction.class);
            return methodHandle.invokeExact();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static Object floatFieldAccessor(Class<?> targetClass, String name) {
        CacheKey cacheKey = new CacheKey(targetClass, name, Float.TYPE);
        return PRIMITIVE_ACCESSOR_CACHE.computeIfAbsent(cacheKey, k -> Reflection.buildFloatAccessor(targetClass, name));
    }

    private static ToFloatFunction<Object> buildFloatAccessor(Class<?> targetClass, String name) {
        try {
            MethodHandle methodHandle = Reflection.createMethodHandle(targetClass, name, Float.TYPE, "applyAsFloat", ToFloatFunction.class);
            return methodHandle.invokeExact();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static Object doubleFieldAccessor(Class<?> targetClass, String name) {
        CacheKey cacheKey = new CacheKey(targetClass, name, Double.TYPE);
        return PRIMITIVE_ACCESSOR_CACHE.computeIfAbsent(cacheKey, k -> Reflection.buildDoubleAccessor(targetClass, name));
    }

    private static ToDoubleFunction<Object> buildDoubleAccessor(Class<?> targetClass, String name) {
        try {
            MethodHandle methodHandle = Reflection.createMethodHandle(targetClass, name, Double.TYPE, "applyAsDouble", ToDoubleFunction.class);
            return methodHandle.invokeExact();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static Object byteFieldAccessor(Class<?> targetClass, String name) {
        CacheKey cacheKey = new CacheKey(targetClass, name, Byte.TYPE);
        return PRIMITIVE_ACCESSOR_CACHE.computeIfAbsent(cacheKey, k -> Reflection.buildByteAccessor(targetClass, name));
    }

    private static ToByteFunction<Object> buildByteAccessor(Class<?> targetClass, String name) {
        try {
            MethodHandle methodHandle = Reflection.createMethodHandle(targetClass, name, Byte.TYPE, "applyAsByte", ToByteFunction.class);
            return methodHandle.invokeExact();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static Object shortFieldAccessor(Class<?> targetClass, String name) {
        CacheKey cacheKey = new CacheKey(targetClass, name, Short.TYPE);
        return PRIMITIVE_ACCESSOR_CACHE.computeIfAbsent(cacheKey, k -> Reflection.buildShortAccessor(targetClass, name));
    }

    private static ToShortFunction<Object> buildShortAccessor(Class<?> targetClass, String name) {
        try {
            MethodHandle methodHandle = Reflection.createMethodHandle(targetClass, name, Short.TYPE, "applyAsShort", ToShortFunction.class);
            return methodHandle.invokeExact();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static Object booleanFieldAccessor(Class<?> targetClass, String name) {
        CacheKey cacheKey = new CacheKey(targetClass, name, Boolean.TYPE);
        return PRIMITIVE_ACCESSOR_CACHE.computeIfAbsent(cacheKey, k -> Reflection.buildBooleanAccessor(targetClass, name));
    }

    private static ToBooleanFunction<Object> buildBooleanAccessor(Class<?> targetClass, String name) {
        try {
            MethodHandle methodHandle = Reflection.createMethodHandle(targetClass, name, Boolean.TYPE, "applyAsBoolean", ToBooleanFunction.class);
            return methodHandle.invokeExact();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static MethodHandle createMethodHandle(Class<?> targetClass, String name, Class<?> fieldType, String methodName, Class<?> extractorFunction) throws NoSuchMethodException, LambdaConversionException {
        LookupMethod lookupMethod = Reflection.findRecordMethod(targetClass, name, fieldType);
        CallSite callSite = LambdaMetafactory.metafactory(lookupMethod.lookup(), methodName, MethodType.methodType(extractorFunction), MethodType.methodType(fieldType, Object.class), lookupMethod.methodHandle(), MethodType.methodType(fieldType, targetClass));
        return callSite.getTarget();
    }

    private static final LookupMethod findRecordMethod(Class<?> targetClass, String name, Class<?> fieldType) throws NoSuchMethodException {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            MethodHandle methodHandle = lookup.findVirtual(targetClass, name, MethodType.methodType(fieldType));
            return new LookupMethod(lookup, methodHandle);
        }
        catch (IllegalAccessException e) {
            try {
                MethodHandles.Lookup privateLookup = MethodHandles.privateLookupIn(targetClass, lookup);
                MethodHandle methodHandle = privateLookup.findVirtual(targetClass, name, MethodType.methodType(fieldType));
                return new LookupMethod(privateLookup, methodHandle);
            }
            catch (IllegalAccessException e1) {
                throw new RuntimeException("Cannot access field: " + name, e1);
            }
        }
    }

    private static class CacheKey {
        private final Class<?> targetClass;
        private final String fieldName;
        private final Class<?> fieldType;

        public CacheKey(Class<?> targetClass, String fieldName, Class<?> fieldType) {
            this.targetClass = targetClass;
            this.fieldName = fieldName;
            this.fieldType = fieldType;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)obj;
            return this.targetClass == cacheKey.targetClass && this.fieldName.equals(cacheKey.fieldName) && this.fieldType == cacheKey.fieldType;
        }

        public int hashCode() {
            return System.identityHashCode(this.targetClass) ^ this.fieldName.hashCode() ^ System.identityHashCode(this.fieldType);
        }
    }

    private record LookupMethod(MethodHandles.Lookup lookup, MethodHandle methodHandle) {
    }
}

