/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl.write;

import com.jerolba.carpet.RecordTypeConversionException;
import com.jerolba.carpet.annotation.PrecisionScale;
import com.jerolba.carpet.annotation.Rounding;
import com.jerolba.carpet.impl.write.DecimalConfig;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;

class BigDecimalWrite {
    private final Integer precision;
    private final Integer scale;
    private final RoundingMode roundingMode;
    private final DecimalMapper mapper;

    public BigDecimalWrite(DecimalConfig decimalConfig) {
        this.precision = decimalConfig.precision();
        this.scale = decimalConfig.scale();
        this.roundingMode = decimalConfig.roundingMode();
        this.mapper = BigDecimalWrite.calcMapper(decimalConfig.precision());
    }

    public void write(RecordConsumer recordConsumer, Object value) {
        BigDecimal dec = this.rescaleIfNeeded((BigDecimal)value);
        switch (this.mapper) {
            case INT: {
                recordConsumer.addInteger(dec.unscaledValue().intValue());
                break;
            }
            case LONG: {
                recordConsumer.addLong(dec.unscaledValue().longValue());
                break;
            }
            case BINARY: {
                byte[] a = dec.unscaledValue().toByteArray();
                recordConsumer.addBinary(Binary.fromConstantByteArray((byte[])a));
            }
        }
    }

    private static DecimalMapper calcMapper(int precision) {
        if (precision <= 9) {
            return DecimalMapper.INT;
        }
        if (precision <= 18) {
            return DecimalMapper.LONG;
        }
        return DecimalMapper.BINARY;
    }

    private BigDecimal rescaleIfNeeded(BigDecimal value) {
        int valuePrecision;
        int valueScale = value.scale();
        boolean scaleAdjusted = false;
        if (valueScale != this.scale) {
            try {
                if (this.roundingMode != null) {
                    value = value.setScale((int)this.scale, this.roundingMode);
                    scaleAdjusted = true;
                } else {
                    value = value.setScale((int)this.scale, RoundingMode.UNNECESSARY);
                    scaleAdjusted = true;
                }
            }
            catch (ArithmeticException aex) {
                throw new RecordTypeConversionException("Cannot encode BigDecimal with scale " + valueScale + " as scale " + this.scale + " without rounding");
            }
        }
        if ((valuePrecision = value.precision()) > this.precision) {
            if (scaleAdjusted) {
                throw new RecordTypeConversionException("Cannot encode BigDecimal with precision " + valuePrecision + " as max precision " + this.precision + ". This is after safely adjusting scale from " + valueScale + " to required " + this.scale);
            }
            throw new RecordTypeConversionException("Cannot encode BigDecimal with precision " + valuePrecision + " as max precision " + this.precision);
        }
        return value;
    }

    static DecimalConfig buildDecimalConfig(PrecisionScale precisionAndScale, Rounding rounding, DecimalConfig decimalConfig) {
        Integer precision = precisionAndScale != null ? Integer.valueOf(precisionAndScale.precision()) : null;
        Integer scale = precisionAndScale != null ? Integer.valueOf(precisionAndScale.scale()) : null;
        RoundingMode roundingMode = rounding != null ? rounding.value() : null;
        return BigDecimalWrite.buildDecimalConfig(precision, scale, roundingMode, decimalConfig);
    }

    static DecimalConfig buildDecimalConfig(Integer precision, Integer scale, RoundingMode roundingMode, DecimalConfig decimalConfig) {
        if (decimalConfig == null) {
            decimalConfig = DecimalConfig.decimalConfig();
        }
        if (precision != null && scale != null) {
            decimalConfig = decimalConfig.withPrecisionAndScale(precision, scale);
        }
        if (roundingMode != null) {
            decimalConfig = decimalConfig.withRoundingMode(roundingMode);
        }
        return decimalConfig;
    }

    static enum DecimalMapper {
        INT,
        LONG,
        BINARY;

    }
}

