/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl.read.converter;

import com.jerolba.carpet.impl.read.converter.InstantRead;
import com.jerolba.carpet.impl.read.converter.LocalDateTimeRead;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.variant.Variant;

public class VariantRead {
    private final LocalDateTimeRead localDateTimeRead = new LocalDateTimeRead();

    public Object deserialize(Variant variant) {
        if (variant == null) {
            return null;
        }
        Variant.Type type = variant.getType();
        return switch (type) {
            case Variant.Type.NULL -> null;
            case Variant.Type.BOOLEAN -> variant.getBoolean();
            case Variant.Type.BYTE -> variant.getByte();
            case Variant.Type.SHORT -> variant.getShort();
            case Variant.Type.INT -> variant.getInt();
            case Variant.Type.LONG -> variant.getLong();
            case Variant.Type.FLOAT -> Float.valueOf(variant.getFloat());
            case Variant.Type.DOUBLE -> variant.getDouble();
            case Variant.Type.STRING -> variant.getString();
            case Variant.Type.DECIMAL4, Variant.Type.DECIMAL8, Variant.Type.DECIMAL16 -> variant.getDecimal();
            case Variant.Type.UUID -> variant.getUUID();
            case Variant.Type.BINARY -> Binary.fromConstantByteBuffer((ByteBuffer)variant.getBinary());
            case Variant.Type.ARRAY -> this.deserializeArray(variant);
            case Variant.Type.OBJECT -> this.deserializeObject(variant);
            case Variant.Type.DATE -> LocalDate.ofEpochDay(variant.getLong());
            case Variant.Type.TIME -> LocalTime.ofNanoOfDay(variant.getLong() * 1000L);
            case Variant.Type.TIMESTAMP_TZ -> InstantRead.instantFromMicrosFromEpoch(variant.getLong());
            case Variant.Type.TIMESTAMP_NANOS_TZ -> InstantRead.instantFromNanosFromEpoch(variant.getLong());
            case Variant.Type.TIMESTAMP_NTZ -> this.localDateTimeRead.localDateTimeFromMicrosFromEpoch(variant.getLong() * 1000L);
            case Variant.Type.TIMESTAMP_NANOS_NTZ -> this.localDateTimeRead.localDateTimeFromNanosFromEpoch(variant.getLong());
            default -> throw new IllegalArgumentException("Unsupported variant type: " + String.valueOf(type));
        };
    }

    private Map<String, Object> deserializeObject(Variant variant) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int size = variant.numObjectElements();
        for (int i = 0; i < size; ++i) {
            Variant.ObjectField fieldAtIndex = variant.getFieldAtIndex(i);
            Object value = this.deserialize(fieldAtIndex.value);
            map.put(fieldAtIndex.key, value);
        }
        return map;
    }

    private List<Object> deserializeArray(Variant variant) {
        ArrayList<Object> list = new ArrayList<Object>();
        int size = variant.numArrayElements();
        for (int i = 0; i < size; ++i) {
            Variant element = variant.getElementAtIndex(i);
            list.add(this.deserialize(element));
        }
        return list;
    }
}

