/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl.read.converter;

import java.time.LocalTime;
import java.util.function.Consumer;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.schema.LogicalTypeAnnotation;

public class LocalTimeConverter
extends PrimitiveConverter {
    private final Consumer<Object> consumer;
    private LocalTime[] dict = null;
    private final long factor;
    private final LogicalTypeAnnotation.TimeUnit timeUnit;

    public LocalTimeConverter(Consumer<Object> consumer, LogicalTypeAnnotation.TimeUnit timeUnit) {
        this.consumer = consumer;
        this.timeUnit = timeUnit;
        this.factor = switch (timeUnit) {
            default -> throw new IncompatibleClassChangeError();
            case LogicalTypeAnnotation.TimeUnit.MILLIS -> 1000000L;
            case LogicalTypeAnnotation.TimeUnit.MICROS -> 1000L;
            case LogicalTypeAnnotation.TimeUnit.NANOS -> 1L;
        };
    }

    public void addInt(int millisInDay) {
        this.consumer.accept(this.convert(millisInDay));
    }

    public void addLong(long microsOrNanos) {
        this.consumer.accept(this.convert(microsOrNanos));
    }

    public void addValueFromDictionary(int dictionaryId) {
        this.consumer.accept(this.dict[dictionaryId]);
    }

    public boolean hasDictionarySupport() {
        return true;
    }

    public void setDictionary(Dictionary dictionary) {
        int maxId = dictionary.getMaxId();
        this.dict = new LocalTime[maxId + 1];
        if (this.timeUnit == LogicalTypeAnnotation.TimeUnit.MILLIS) {
            for (int i = 0; i <= maxId; ++i) {
                this.dict[i] = this.convert(dictionary.decodeToInt(i));
            }
        } else {
            for (int i = 0; i <= maxId; ++i) {
                this.dict[i] = this.convert(dictionary.decodeToLong(i));
            }
        }
    }

    private LocalTime convert(long time) {
        return LocalTime.ofNanoOfDay(time * this.factor);
    }
}

