/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl.read.converter;

import java.util.function.Consumer;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;

public class GeometryConverter
extends PrimitiveConverter {
    private final WKBReader wkbReader = new WKBReader();
    private Geometry[] dict = null;
    private final Consumer<Object> consumer;

    public GeometryConverter(Consumer<Object> consumer) {
        this.consumer = consumer;
    }

    public void addBinary(Binary value) {
        this.consumer.accept(this.convert(value));
    }

    public boolean hasDictionarySupport() {
        return true;
    }

    public void setDictionary(Dictionary dictionary) {
        int maxId = dictionary.getMaxId();
        this.dict = new Geometry[maxId + 1];
        for (int i = 0; i <= maxId; ++i) {
            this.dict[i] = this.convert(dictionary.decodeToBinary(i));
        }
    }

    public void addValueFromDictionary(int dictionaryId) {
        this.consumer.accept(this.dict[dictionaryId]);
    }

    private Geometry convert(Binary value) {
        try {
            return this.wkbReader.read(value.getBytes());
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

