/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl.read;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

class ColumnPath {
    private final List<Column> path;
    private final Column head;

    ColumnPath() {
        this.path = new ArrayList<Column>();
        this.head = null;
    }

    private ColumnPath(List<Column> path, Column head) {
        this.path = path;
        this.head = head;
    }

    public ColumnPath add(Class<?> clazz, String field, String column) {
        ArrayList<Column> appended = new ArrayList<Column>(this.path);
        Column head = new Column(clazz, field, column);
        appended.add(head);
        return new ColumnPath(appended, head);
    }

    public String getClassName() {
        return this.head.clazz.getName();
    }

    public String path() {
        return this.path.stream().map(c -> c.column).collect(Collectors.joining("."));
    }

    public String getColumnName() {
        return this.head.column;
    }

    public String getFieldName() {
        return this.head.field;
    }

    private record Column(Class<?> clazz, String field, String column) {
    }
}

