/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl.read;

import com.jerolba.carpet.impl.read.CarpetMaterializer;
import com.jerolba.carpet.impl.read.CarpetReadConfiguration;
import com.jerolba.carpet.impl.read.ColumnToFieldMapper;
import com.jerolba.carpet.impl.read.SchemaFilter;
import com.jerolba.carpet.impl.read.SchemaValidation;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.conf.ParquetConfiguration;
import org.apache.parquet.hadoop.api.InitContext;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;

public class CarpetReadSupport<T>
extends ReadSupport<T> {
    private final Class<T> readClass;
    private final CarpetReadConfiguration carpetConfiguration;
    private final ColumnToFieldMapper columnToFieldMapper;

    public CarpetReadSupport(Class<T> readClass, CarpetReadConfiguration carpetConfiguration) {
        this.readClass = readClass;
        this.carpetConfiguration = carpetConfiguration;
        this.columnToFieldMapper = new ColumnToFieldMapper(carpetConfiguration.fieldMatchingStrategy());
    }

    public RecordMaterializer<T> prepareForRead(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema, ReadSupport.ReadContext readContext) {
        return new CarpetMaterializer<T>(this.readClass, readContext.getRequestedSchema(), this.columnToFieldMapper);
    }

    public RecordMaterializer<T> prepareForRead(ParquetConfiguration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema, ReadSupport.ReadContext readContext) {
        return new CarpetMaterializer<T>(this.readClass, readContext.getRequestedSchema(), this.columnToFieldMapper);
    }

    public ReadSupport.ReadContext init(InitContext initContext) {
        SchemaValidation validation = new SchemaValidation(this.carpetConfiguration.isFailOnMissingColumn(), this.carpetConfiguration.isFailNarrowingPrimitiveConversion(), this.carpetConfiguration.isFailOnNullForPrimitives());
        SchemaFilter schemaFilter = new SchemaFilter(validation, this.columnToFieldMapper);
        MessageType projection = schemaFilter.project(this.readClass, (GroupType)initContext.getFileSchema());
        LinkedHashMap metadata = new LinkedHashMap();
        return new ReadSupport.ReadContext(projection, metadata);
    }
}

