/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl;

import com.jerolba.carpet.impl.JavaType;
import com.jerolba.carpet.impl.Parameterized;
import com.jerolba.carpet.impl.ParameterizedMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;

public class ParameterizedCollection {
    private final Type collectionType;
    private final AnnotatedType annotatedCollectionElementType;

    public ParameterizedCollection(Type collectionType, AnnotatedType annotatedCollectionElementType) {
        this.collectionType = collectionType;
        this.annotatedCollectionElementType = annotatedCollectionElementType;
    }

    public ParameterizedCollection(Type collectionType, AnnotatedParameterizedType type) {
        this(collectionType, type.getAnnotatedActualTypeArguments()[0]);
    }

    public Class<?> getActualType() {
        return Parameterized.getClassFromType(this.annotatedCollectionElementType.getType(), "in Collection");
    }

    public JavaType getActualJavaType() {
        return new JavaType(this.getActualType(), this.getAnnotations());
    }

    public Class<?> getCollectionType() {
        return (Class)this.collectionType;
    }

    public ParameterizedCollection getAsCollection() {
        return Parameterized.getParameterizedCollection(this.annotatedCollectionElementType);
    }

    public ParameterizedMap getAsMap() {
        return Parameterized.getParameterizedMap(this.annotatedCollectionElementType);
    }

    public boolean isCollection() {
        return Parameterized.isCollection(this.annotatedCollectionElementType.getType());
    }

    public boolean isMap() {
        return Parameterized.isMap(this.annotatedCollectionElementType.getType());
    }

    private Annotation[] getAnnotations() {
        return this.annotatedCollectionElementType.getDeclaredAnnotations();
    }
}

