/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet;

import com.jerolba.carpet.CarpetParquetReader;
import com.jerolba.carpet.FieldMatchingStrategy;
import com.jerolba.carpet.io.FileSystemInputFile;
import java.io.File;
import java.io.IOException;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.compression.CompressionCodecFactory;
import org.apache.parquet.conf.ParquetConfiguration;
import org.apache.parquet.crypto.FileDecryptionProperties;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.io.InputFile;

public abstract class CarpetReaderConfigurationBuilder<T, SELF extends CarpetReaderConfigurationBuilder<T, SELF>> {
    private final CarpetParquetReader.Builder<T> builder;

    public CarpetReaderConfigurationBuilder(InputFile file, Class<T> recordClass) {
        this.builder = CarpetParquetReader.builder(file, recordClass);
    }

    public CarpetReaderConfigurationBuilder(File file, Class<T> recordClass) {
        this(new FileSystemInputFile(file), recordClass);
    }

    protected abstract SELF self();

    public InputFile getInputFile() {
        return this.builder.getInputFile();
    }

    public Class<T> getRecordClass() {
        return this.builder.getRecordClass();
    }

    public SELF failOnMissingColumn(boolean failOnMissingColumn) {
        this.builder.failOnMissingColumn(failOnMissingColumn);
        return this.self();
    }

    public SELF failOnNullForPrimitives(boolean failOnNullForPrimitives) {
        this.builder.failOnNullForPrimitives(failOnNullForPrimitives);
        return this.self();
    }

    public SELF failNarrowingPrimitiveConversion(boolean failNarrowingPrimitiveConversion) {
        this.builder.failNarrowingPrimitiveConversion(failNarrowingPrimitiveConversion);
        return this.self();
    }

    public SELF fieldMatchingStrategy(FieldMatchingStrategy fieldMatchingStrategy) {
        this.builder.fieldMatchingStrategy(fieldMatchingStrategy);
        return this.self();
    }

    public SELF withConf(ParquetConfiguration conf) {
        this.builder.withConf(conf);
        return this.self();
    }

    public SELF withFilter(FilterCompat.Filter filter) {
        this.builder.withFilter(filter);
        return this.self();
    }

    public SELF withAllocator(ByteBufferAllocator allocator) {
        this.builder.withAllocator(allocator);
        return this.self();
    }

    public SELF useSignedStringMinMax(boolean useSignedStringMinMax) {
        this.builder.useSignedStringMinMax(useSignedStringMinMax);
        return this.self();
    }

    public SELF useSignedStringMinMax() {
        this.builder.useSignedStringMinMax();
        return this.self();
    }

    public SELF useStatsFilter(boolean useStatsFilter) {
        this.builder.useStatsFilter(useStatsFilter);
        return this.self();
    }

    public SELF useStatsFilter() {
        this.builder.useStatsFilter();
        return this.self();
    }

    public SELF useDictionaryFilter(boolean useDictionaryFilter) {
        this.builder.useDictionaryFilter(useDictionaryFilter);
        return this.self();
    }

    public SELF useDictionaryFilter() {
        this.builder.useDictionaryFilter();
        return this.self();
    }

    public SELF useRecordFilter(boolean useRecordFilter) {
        this.builder.useRecordFilter(useRecordFilter);
        return this.self();
    }

    public SELF useRecordFilter() {
        this.builder.useRecordFilter();
        return this.self();
    }

    public SELF useColumnIndexFilter(boolean useColumnIndexFilter) {
        this.builder.useColumnIndexFilter(useColumnIndexFilter);
        return this.self();
    }

    public SELF useColumnIndexFilter() {
        this.builder.useColumnIndexFilter();
        return this.self();
    }

    public SELF usePageChecksumVerification(boolean usePageChecksumVerification) {
        this.builder.usePageChecksumVerification(usePageChecksumVerification);
        return this.self();
    }

    public SELF useBloomFilter(boolean useBloomFilter) {
        this.builder.useBloomFilter(useBloomFilter);
        return this.self();
    }

    public SELF useBloomFilter() {
        this.builder.useBloomFilter();
        return this.self();
    }

    public SELF usePageChecksumVerification() {
        this.builder.usePageChecksumVerification();
        return this.self();
    }

    public SELF withFileRange(long start, long end) {
        this.builder.withFileRange(start, end);
        return this.self();
    }

    public SELF withCodecFactory(CompressionCodecFactory codecFactory) {
        this.builder.withCodecFactory(codecFactory);
        return this.self();
    }

    public SELF withDecryption(FileDecryptionProperties fileDecryptionProperties) {
        this.builder.withDecryption(fileDecryptionProperties);
        return this.self();
    }

    public SELF set(String key, String value) {
        this.builder.set(key, value);
        return this.self();
    }

    public ParquetReader<T> buildParquetReader() throws IOException {
        return this.builder.build();
    }
}

