/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.log;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.aj.ImmutabilityChecker;
import java.util.Formattable;
import java.util.Formatter;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

@Immutable
final class NanoDecor
implements Formattable {
    private final transient Double nano;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public NanoDecor(Long nan) {
        Long l = nan;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)l);
        try {
            this.nano = nan == null ? null : Double.valueOf(nan.longValue());
        }
        finally {
            ImmutabilityChecker.aspectOf().after(joinPoint);
        }
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        if (this.nano == null) {
            formatter.format("NULL", new Object[0]);
        } else {
            StringBuilder format = new StringBuilder();
            format.append('%');
            if ((flags & 1) == 1) {
                format.append('-');
            }
            if (width > 0) {
                format.append(Integer.toString(width));
            }
            if ((flags & 2) == 2) {
                format.append('S');
            } else {
                format.append('s');
            }
            formatter.format(format.toString(), this.toText(precision));
        }
    }

    private String toText(int precision) {
        String title;
        double number;
        if (this.nano < 1000.0) {
            number = this.nano;
            title = "ns";
        } else if (this.nano < 1000000.0) {
            number = this.nano / 1000.0;
            title = "\u00b5s";
        } else if (this.nano < 1.0E9) {
            number = this.nano / 1000000.0;
            title = "ms";
        } else if (this.nano < 6.0E10) {
            number = this.nano / 1.0E9;
            title = "s";
        } else {
            number = this.nano / 6.0E10;
            title = "min";
        }
        String format = precision >= 0 ? String.format("%%.%df%%s", precision) : String.format("%%.0f%%s", new Object[0]);
        return String.format(format, number, title);
    }

    public String toString() {
        return "NanoDecor(nano=" + this.nano + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NanoDecor)) {
            return false;
        }
        NanoDecor other = (NanoDecor)o;
        Double this$nano = this.nano;
        Double other$nano = other.nano;
        return !(this$nano == null ? other$nano != null : !((Object)this$nano).equals(other$nano));
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        Double $nano = this.nano;
        result = result * 31 + ($nano == null ? 0 : ((Object)$nano).hashCode());
        return result;
    }

    static {
        NanoDecor.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("NanoDecor.java", NanoDecor.class);
        ajc$tjp_0 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.jcabi.log.NanoDecor", "java.lang.Long", "nan", ""), 71);
    }
}

