/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.log;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.aj.ImmutabilityChecker;
import java.util.Formattable;
import java.util.Formatter;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

@Immutable
final class MsDecor
implements Formattable {
    private final transient Double millis;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public MsDecor(Long msec) {
        Long l = msec;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)l);
        try {
            this.millis = msec == null ? null : Double.valueOf(msec.longValue());
        }
        finally {
            ImmutabilityChecker.aspectOf().after(joinPoint);
        }
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        if (this.millis == null) {
            formatter.format("NULL", new Object[0]);
        } else {
            StringBuilder format = new StringBuilder();
            format.append('%');
            if ((flags & 1) == 1) {
                format.append('-');
            }
            if (width > 0) {
                format.append(Integer.toString(width));
            }
            if ((flags & 2) == 2) {
                format.append('S');
            } else {
                format.append('s');
            }
            formatter.format(format.toString(), this.toText(precision));
        }
    }

    private String toText(int precision) {
        String title;
        double number;
        if (this.millis < 1000.0) {
            number = this.millis;
            title = "ms";
        } else if (this.millis < 60000.0) {
            number = this.millis / 1000.0;
            title = "s";
        } else if (this.millis < 3600000.0) {
            number = this.millis / 60000.0;
            title = "min";
        } else if (this.millis < 8.64E7) {
            number = this.millis / 3600000.0;
            title = "hr";
        } else if (this.millis < 2.592E9) {
            number = this.millis / 8.64E7;
            title = "days";
        } else {
            number = this.millis / 2.592E9;
            title = "mon";
        }
        String format = precision >= 0 ? String.format("%%.%df%%s", precision) : String.format("%%.0f%%s", new Object[0]);
        return String.format(format, number, title);
    }

    public String toString() {
        return "MsDecor(millis=" + this.millis + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MsDecor)) {
            return false;
        }
        MsDecor other = (MsDecor)o;
        Double this$millis = this.millis;
        Double other$millis = other.millis;
        return !(this$millis == null ? other$millis != null : !((Object)this$millis).equals(other$millis));
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        Double $millis = this.millis;
        result = result * 31 + ($millis == null ? 0 : ((Object)$millis).hashCode());
        return result;
    }

    static {
        MsDecor.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MsDecor.java", MsDecor.class);
        ajc$tjp_0 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.jcabi.log.MsDecor", "java.lang.Long", "msec", ""), 70);
    }
}

