/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import java.net.InetAddress;
import java.net.URI;
import org.apache.commons.logging.LogFactory;

public class AwsHostNameUtils {
    public static String parseRegionName(URI endpoint) {
        String host = endpoint.getHost();
        if (!host.endsWith(".amazonaws.com")) {
            return "us-east-1";
        }
        String serviceAndRegion = host.substring(0, host.indexOf(".amazonaws.com"));
        if (serviceAndRegion.contains("s3-")) {
            return serviceAndRegion.substring(serviceAndRegion.lastIndexOf("s3-") + 3);
        }
        int separator = 46;
        if (serviceAndRegion.indexOf(separator) == -1) {
            return "us-east-1";
        }
        String region = serviceAndRegion.substring(serviceAndRegion.indexOf(separator) + 1);
        if ("us-gov".equals(region)) {
            return "us-gov-west-1";
        }
        return region;
    }

    public static String parseServiceName(URI endpoint) {
        String host = endpoint.getHost();
        if (!host.endsWith(".amazonaws.com")) {
            throw new IllegalArgumentException("Cannot parse the service name by an unrecognized endpoint(" + host + "). Please specify the service name by setEndpoint(String endpoint, String serviceName, String regionId).");
        }
        String serviceAndRegion = host.substring(0, host.indexOf(".amazonaws.com"));
        if (serviceAndRegion.contains("s3-")) {
            return "s3";
        }
        int separator = 46;
        if (serviceAndRegion.indexOf(separator) == -1) {
            return serviceAndRegion;
        }
        String service = serviceAndRegion.substring(0, serviceAndRegion.indexOf(separator));
        return service;
    }

    public static String localHostName() {
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            return localhost.getHostName();
        }
        catch (Exception e) {
            LogFactory.getLog(AwsHostNameUtils.class).debug((Object)"Failed to determine the local hostname; fall back to use \"localhost\".", (Throwable)e);
            return "localhost";
        }
    }
}

