/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.metrics.internal.cloudwatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum MachineMetric {
    TotalMemory(Dim.Memory, MetricName.JvmMetric),
    FreeMemory(Dim.Memory, MetricName.JvmMetric),
    UsedMemory(Dim.Memory, MetricName.JvmMetric),
    SpareMemory(Dim.Memory, MetricName.JvmMetric),
    ThreadCount(Dim.Threads, MetricName.JvmMetric),
    DeadLockThreadCount(Dim.Threads, MetricName.JvmMetric, false),
    DaemonThreadCount(Dim.Threads, MetricName.JvmMetric, false),
    PeakThreadCount(Dim.Threads, MetricName.JvmMetric),
    TotalStartedThreadCount(Dim.Threads, MetricName.JvmMetric),
    OpenFileDescriptorCount(Dim.FileDescriptors, MetricName.OSMetric),
    SpareFileDescriptorCount(Dim.FileDescriptors, MetricName.OSMetric);

    private final Dim dimension;
    private final boolean includeZeroValue;
    private final MetricName metricName;

    private MachineMetric(Dim dimension, MetricName metricName) {
        this(dimension, metricName, true);
    }

    private MachineMetric(Dim dimension, MetricName metricName, boolean includeZeroValue) {
        this.dimension = dimension;
        this.metricName = metricName;
        this.includeZeroValue = includeZeroValue;
    }

    String getDimensionName() {
        return this.dimension.name();
    }

    String getMetricName() {
        return this.metricName.name();
    }

    boolean includeZeroValue() {
        return this.includeZeroValue;
    }

    static String getOSMetricName() {
        return MetricName.OSMetric.name();
    }

    private static class _ {
        static final boolean INCLUDES_ZERO_VALUES = true;
        static final boolean EXCLUDES_ZERO_VALUES = false;

        private _() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Dim {
        Memory,
        Threads,
        FileDescriptors;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MetricName {
        JvmMetric,
        OSMetric;

    }
}

