/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ServiceNameFactory;
import com.amazonaws.auth.Signer;
import com.amazonaws.auth.SignerFactory;
import com.amazonaws.handlers.RequestHandler;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.http.AmazonHttpClient;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.http.HttpRequest;
import com.amazonaws.metrics.AwsSdkMetrics;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.regions.Region;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.AwsHostNameUtils;
import com.amazonaws.util.Classes;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AmazonWebServiceClient {
    private static final String AMAZON = "Amazon";
    private static final String AWS = "AWS";
    protected URI endpoint;
    protected ClientConfiguration clientConfiguration;
    protected AmazonHttpClient client;
    protected final List<RequestHandler2> requestHandler2s;
    protected int timeOffset;
    private Signer signer;
    private volatile String serviceName;

    public AmazonWebServiceClient(ClientConfiguration clientConfiguration) {
        this(clientConfiguration, null);
    }

    public AmazonWebServiceClient(ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        this.clientConfiguration = clientConfiguration;
        this.client = new AmazonHttpClient(clientConfiguration, requestMetricCollector);
        this.requestHandler2s = new CopyOnWriteArrayList<RequestHandler2>();
    }

    protected Signer getSigner() {
        return this.signer;
    }

    public void setEndpoint(String endpoint) throws IllegalArgumentException {
        URI uri = this.configEndpoint(endpoint);
        this.configSigner(uri);
    }

    private URI configEndpoint(String endpoint) throws IllegalArgumentException {
        if (!endpoint.contains("://")) {
            endpoint = this.clientConfiguration.getProtocol().toString() + "://" + endpoint;
        }
        try {
            this.endpoint = new URI(endpoint);
            return this.endpoint;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void setEndpoint(String endpoint, String serviceName, String regionId) {
        this.configEndpoint(endpoint);
        this.configSigner(serviceName, regionId);
    }

    protected void configSigner(URI uri) {
        String region = AwsHostNameUtils.parseRegionName(uri);
        String service = this.getServiceNameIntern();
        this.signer = SignerFactory.getSigner(service, region);
    }

    protected void configSigner(String serviceName, String regionId) {
        this.signer = SignerFactory.getSigner(serviceName, regionId);
    }

    public void setRegion(Region region) throws IllegalArgumentException {
        if (region == null) {
            throw new IllegalArgumentException("No region provided");
        }
        String serviceName = this.getServiceNameIntern();
        if (!region.isServiceSupported(serviceName)) {
            throw new IllegalArgumentException(serviceName + " isn't supported in region " + region.getName());
        }
        String serviceEndpoint = region.getServiceEndpoint(serviceName);
        int protocolIdx = serviceEndpoint.indexOf("://");
        if (protocolIdx >= 0) {
            serviceEndpoint = serviceEndpoint.substring(protocolIdx + "://".length());
        }
        this.setEndpoint(serviceEndpoint);
    }

    public void setConfiguration(ClientConfiguration clientConfiguration) {
        this.clientConfiguration = clientConfiguration;
        this.client = new AmazonHttpClient(clientConfiguration);
    }

    public void shutdown() {
        this.client.shutdown();
    }

    @Deprecated
    protected <T> HttpRequest convertToHttpRequest(Request<T> request, HttpMethodName methodName) {
        HttpRequest httpRequest = new HttpRequest(methodName);
        for (Map.Entry<String, String> parameter : request.getParameters().entrySet()) {
            httpRequest.addParameter(parameter.getKey(), parameter.getValue());
        }
        for (Map.Entry<String, String> parameter : request.getHeaders().entrySet()) {
            httpRequest.addHeader(parameter.getKey(), parameter.getValue());
        }
        httpRequest.setServiceName(request.getServiceName());
        httpRequest.setEndpoint(request.getEndpoint());
        httpRequest.setResourcePath(request.getResourcePath());
        httpRequest.setOriginalRequest(request.getOriginalRequest());
        return httpRequest;
    }

    @Deprecated
    public void addRequestHandler(RequestHandler requestHandler) {
        this.requestHandler2s.add(RequestHandler2.adapt(requestHandler));
    }

    public void addRequestHandler(RequestHandler2 requestHandler2) {
        this.requestHandler2s.add(requestHandler2);
    }

    public void removeRequestHandler(RequestHandler requestHandler) {
        this.requestHandler2s.remove(RequestHandler2.adapt(requestHandler));
    }

    public void removeRequestHandler(RequestHandler2 requestHandler2) {
        this.requestHandler2s.remove(requestHandler2);
    }

    protected final ExecutionContext createExecutionContext(AmazonWebServiceRequest req) {
        boolean isMetricsEnabled = this.isRequestMetricsEnabled(req) || AmazonWebServiceClient.isProfilingEnabled();
        return new ExecutionContext(this.requestHandler2s, isMetricsEnabled);
    }

    protected final ExecutionContext createExecutionContext(Request<?> req) {
        return this.createExecutionContext(req.getOriginalRequest());
    }

    @Deprecated
    protected final ExecutionContext createExecutionContext() {
        boolean isMetricsEnabled = this.isRMCEnabledAtClientOrSdkLevel() || AmazonWebServiceClient.isProfilingEnabled();
        return new ExecutionContext(this.requestHandler2s, isMetricsEnabled);
    }

    private static boolean isProfilingEnabled() {
        return System.getProperty("com.amazonaws.sdk.enableRuntimeProfiling") != null;
    }

    private boolean isRequestMetricsEnabled(AmazonWebServiceRequest req) {
        RequestMetricCollector c = req.getRequestMetricCollector();
        if (c != null && c.isEnabled()) {
            return true;
        }
        return this.isRMCEnabledAtClientOrSdkLevel();
    }

    private boolean isRMCEnabledAtClientOrSdkLevel() {
        RequestMetricCollector c = this.requestMetricCollector();
        return c != null && c.isEnabled();
    }

    public void setTimeOffset(int timeOffset) {
        this.timeOffset = timeOffset;
    }

    public AmazonWebServiceClient withTimeOffset(int timeOffset) {
        this.setTimeOffset(timeOffset);
        return this;
    }

    public int getTimeOffset() {
        return this.timeOffset;
    }

    public RequestMetricCollector getRequestMetricsCollector() {
        return this.client.getRequestMetricCollector();
    }

    protected RequestMetricCollector requestMetricCollector() {
        RequestMetricCollector mc = this.client.getRequestMetricCollector();
        return mc == null ? AwsSdkMetrics.getRequestMetricCollector() : mc;
    }

    protected final RequestMetricCollector findRequestMetricCollector(Request<?> req) {
        AmazonWebServiceRequest origReq = req.getOriginalRequest();
        RequestMetricCollector mc = origReq.getRequestMetricCollector();
        if (mc != null) {
            return mc;
        }
        mc = this.getRequestMetricsCollector();
        return mc == null ? AwsSdkMetrics.getRequestMetricCollector() : mc;
    }

    protected final void endClientExecution(AWSRequestMetrics awsRequestMetrics, Request<?> request, Response<?> response) {
        if (request != null) {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.ClientExecuteTime);
            awsRequestMetrics.getTimingInfo().endTiming();
            RequestMetricCollector c = this.findRequestMetricCollector(request);
            c.collectMetrics(request, response);
        }
    }

    @Deprecated
    protected String getServiceAbbreviation() {
        return this.getServiceNameIntern();
    }

    public String getServiceName() {
        return this.getServiceNameIntern();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getServiceNameIntern() {
        if (this.serviceName == null) {
            AmazonWebServiceClient amazonWebServiceClient = this;
            synchronized (amazonWebServiceClient) {
                if (this.serviceName == null) {
                    this.serviceName = this.computeServiceName();
                    return this.serviceName;
                }
            }
        }
        return this.serviceName;
    }

    private String computeServiceName() {
        int len;
        Class<?> httpClientClass = Classes.childClassOf(AmazonWebServiceClient.class, this);
        String httpClientName = httpClientClass.getSimpleName();
        String service = ServiceNameFactory.getServiceName(httpClientName);
        if (service != null) {
            return service;
        }
        int j = httpClientName.indexOf("JavaClient");
        if (j == -1 && (j = httpClientName.indexOf("Client")) == -1) {
            throw new IllegalStateException("Unrecognized suffix for the AWS http client class name " + httpClientName);
        }
        int i = httpClientName.indexOf(AMAZON);
        if (i == -1) {
            i = httpClientName.indexOf(AWS);
            if (i == -1) {
                throw new IllegalStateException("Unrecognized prefix for the AWS http client class name " + httpClientName);
            }
            len = AWS.length();
        } else {
            len = AMAZON.length();
        }
        if (i >= j) {
            throw new IllegalStateException("Unrecognized AWS http client class name " + httpClientName);
        }
        String serviceName = httpClientName.substring(i + len, j);
        return serviceName.toLowerCase();
    }
}

