/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.local.server;

import com.amazonaws.services.dynamodbv2.local.server.AbstractLocalDynamoDBServerHandler;
import com.amazonaws.services.dynamodbv2.local.server.LocalDynamoDBRequestHandler;
import com.amazonaws.services.dynamodbv2.local.server.LocalDynamoDBServerHandler;
import org.apache.log4j.Logger;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;

public class DynamoDBProxyServer {
    Server server;
    private AbstractLocalDynamoDBServerHandler serverHandler;
    static Logger logger = Logger.getLogger(DynamoDBProxyServer.class);

    public DynamoDBProxyServer() {
        this(8000, new LocalDynamoDBServerHandler(new LocalDynamoDBRequestHandler(0)));
    }

    public DynamoDBProxyServer(int port) {
        this(port, new LocalDynamoDBServerHandler(new LocalDynamoDBRequestHandler(0)));
    }

    public DynamoDBProxyServer(int port, boolean inMemory) {
        this(port, new LocalDynamoDBServerHandler(new LocalDynamoDBRequestHandler(0, inMemory)));
    }

    public DynamoDBProxyServer(int port, String dbFilePath) {
        this(port, new LocalDynamoDBServerHandler(new LocalDynamoDBRequestHandler(0, dbFilePath)));
    }

    public DynamoDBProxyServer(AbstractLocalDynamoDBServerHandler a) {
        this(8000, a);
    }

    public DynamoDBProxyServer(int port, AbstractLocalDynamoDBServerHandler a) {
        this.server = new Server(port);
        this.server.setHandler((Handler)a);
        this.serverHandler = a;
    }

    public void start() throws Exception {
        this.server.start();
    }

    public void stop() throws Exception {
        this.server.stop();
        this.serverHandler.close();
    }
}

