/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android;

import com.jayway.maven.plugins.android.AbstractAndroidMojo;
import com.jayway.maven.plugins.android.asm.AndroidTestFinder;
import java.io.File;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public abstract class AbstractIntegrationtestMojo
extends AbstractAndroidMojo {
    private boolean mavenTestSkip;
    private String enableIntegrationTest;

    protected boolean isEnableIntegrationTest() throws MojoFailureException, MojoExecutionException {
        if (this.mavenTestSkip) {
            return false;
        }
        if ("false".equalsIgnoreCase(this.enableIntegrationTest)) {
            return false;
        }
        if ("true".equalsIgnoreCase(this.enableIntegrationTest)) {
            return true;
        }
        if ("auto".equalsIgnoreCase(this.enableIntegrationTest)) {
            if (this.extractInstrumentationRunnerFromAndroidManifest(this.androidManifestFile) == null) {
                return false;
            }
            return AndroidTestFinder.containsAndroidTests(new File(this.project.getBuild().getDirectory(), "android-classes"));
        }
        throw new MojoFailureException("enableIntegrationTest must be configured as 'true', 'false' or 'auto'.");
    }

    protected void deployDependencies() throws MojoExecutionException {
        Set directDependentArtifacts = this.project.getDependencyArtifacts();
        if (directDependentArtifacts != null) {
            for (Artifact artifact : directDependentArtifacts) {
                String type = artifact.getType();
                if (!type.equals("apk")) continue;
                this.getLog().debug((CharSequence)("Detected apk dependency " + artifact + ". Will resolve and deploy to device..."));
                File targetApkFile = this.resolveArtifactToFile(artifact);
                if (this.undeployBeforeDeploy) {
                    this.getLog().debug((CharSequence)("Attempting undeploy of " + targetApkFile + " from device..."));
                    this.undeployApk(targetApkFile);
                }
                this.getLog().debug((CharSequence)("Deploying " + targetApkFile + " to device..."));
                this.deployApk(targetApkFile);
            }
        }
    }

    protected void deployBuiltApk() throws MojoExecutionException {
        if (!SUPPORTED_PACKAGING_TYPES.contains(this.project.getPackaging())) {
            this.getLog().info((CharSequence)("Skipping deployment on " + this.project.getPackaging()));
            return;
        }
        File apkFile = new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + "." + "apk");
        this.deployApk(apkFile);
    }

    protected void deployFile(File apkFile) throws MojoExecutionException {
        if (this.undeployBeforeDeploy) {
            this.undeployApk(apkFile);
        }
        this.deployApk(apkFile);
    }
}

