/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.phase08preparepackage;

import com.jayway.maven.plugins.android.AbstractAndroidMojo;
import com.jayway.maven.plugins.android.CommandExecutor;
import com.jayway.maven.plugins.android.ExecutionException;
import com.jayway.maven.plugins.android.configuration.Dex;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.util.DefaultFileSet;

public class DexMojo
extends AbstractAndroidMojo {
    private Dex dex;
    private String[] dexJvmArguments;
    private boolean dexCoreLibrary;
    private boolean dexNoLocals;
    private boolean dexOptimize;
    private String[] parsedJvmArguments;
    private boolean parsedCoreLibrary;
    private boolean parsedNoLocals;
    private boolean parsedOptimize;

    public void execute() throws MojoExecutionException, MojoFailureException {
        CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
        executor.setLogger(this.getLog());
        File outputFile = new File(this.project.getBuild().getDirectory() + File.separator + "classes.dex");
        File inputFile = new File(this.project.getBuild().getDirectory() + File.separator + this.project.getBuild().getFinalName() + ".jar");
        this.parseConfiguration();
        if (this.generateApk) {
            this.runDex(executor, outputFile, inputFile);
        }
        if (this.attachJar) {
            this.projectHelper.attachArtifact(this.project, "jar", this.project.getArtifact().getClassifier(), inputFile);
        }
        if (this.attachSources) {
            File apksources = this.createApkSourcesFile();
            this.projectHelper.attachArtifact(this.project, "apksources", apksources);
        }
    }

    private void parseConfiguration() {
        if (this.dex != null) {
            this.parsedJvmArguments = this.dex.getJvmArguments();
            this.parsedCoreLibrary = this.dex.isCoreLibrary();
            this.parsedNoLocals = this.dex.isNoLocals();
            this.parsedOptimize = this.dex.isOptimize();
        } else {
            this.parsedJvmArguments = this.dexJvmArguments;
            this.parsedCoreLibrary = this.dexCoreLibrary;
            this.parsedNoLocals = this.dexNoLocals;
            this.parsedOptimize = this.dexOptimize;
        }
    }

    private void runDex(CommandExecutor executor, File outputFile, File inputFile) throws MojoExecutionException {
        File classesOutputDirectory = new File(this.project.getBuild().getDirectory(), "android-classes");
        ArrayList<String> commands = new ArrayList<String>();
        if (this.parsedJvmArguments != null) {
            for (String jvmArgument : this.parsedJvmArguments) {
                if (!jvmArgument.startsWith("-")) {
                    jvmArgument = "-" + jvmArgument;
                }
                this.getLog().debug((CharSequence)("Adding jvm argument " + jvmArgument));
                commands.add(jvmArgument);
            }
        }
        commands.add("-jar");
        commands.add(this.getAndroidSdk().getPathForTool("dx.jar"));
        commands.add("--dex");
        if (!this.parsedOptimize) {
            commands.add("--no-optimize");
        }
        if (this.parsedCoreLibrary) {
            commands.add("--core-library");
        }
        commands.add("--output=" + outputFile.getAbsolutePath());
        if (this.parsedNoLocals) {
            commands.add("--no-locals");
        }
        commands.add(classesOutputDirectory.getAbsolutePath());
        String javaExecutable = DexMojo.getJavaExecutable().getAbsolutePath();
        this.getLog().info((CharSequence)(javaExecutable + " " + ((Object)commands).toString()));
        try {
            executor.executeCommand(javaExecutable, commands, this.project.getBasedir(), false);
        }
        catch (ExecutionException e) {
            throw new MojoExecutionException("", (Exception)e);
        }
    }

    private static File getJavaExecutable() {
        String javaHome = System.getProperty("java.home");
        String slash = File.separator;
        return new File(javaHome + slash + "bin" + slash + "java");
    }

    protected File createApkSourcesFile() throws MojoExecutionException {
        File apksources = new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + ".apksources");
        FileUtils.deleteQuietly((File)apksources);
        try {
            JarArchiver jarArchiver = new JarArchiver();
            jarArchiver.setDestFile(apksources);
            this.addDirectory(jarArchiver, this.assetsDirectory, "assets");
            this.addDirectory(jarArchiver, this.resourceDirectory, "res");
            this.addDirectory(jarArchiver, this.sourceDirectory, "src/main/java");
            this.addJavaResources(jarArchiver, this.project.getBuild().getResources());
            jarArchiver.createArchive();
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("ArchiverException while creating .apksource file.", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("IOException while creating .apksource file.", (Exception)e);
        }
        return apksources;
    }

    protected String endWithSlash(String prefix) {
        if (!(prefix = StringUtils.defaultIfEmpty((String)prefix, (String)"/")).endsWith("/")) {
            prefix = prefix + "/";
        }
        return prefix;
    }

    protected void addDirectory(JarArchiver jarArchiver, File directory, String prefix) throws ArchiverException {
        if (directory != null && directory.exists()) {
            DefaultFileSet fileSet = new DefaultFileSet();
            fileSet.setPrefix(this.endWithSlash(prefix));
            fileSet.setDirectory(directory);
            jarArchiver.addFileSet((FileSet)fileSet);
        }
    }

    protected void addJavaResources(JarArchiver jarArchiver, List<Resource> javaResources) throws ArchiverException {
        for (Resource javaResource : javaResources) {
            this.addJavaResource(jarArchiver, javaResource);
        }
    }

    protected void addJavaResource(JarArchiver jarArchiver, Resource javaResource) throws ArchiverException {
        File javaResourceDirectory;
        if (javaResource != null && (javaResourceDirectory = new File(javaResource.getDirectory())).exists()) {
            DefaultFileSet javaResourceFileSet = new DefaultFileSet();
            javaResourceFileSet.setDirectory(javaResourceDirectory);
            javaResourceFileSet.setPrefix(this.endWithSlash("src/main/resources"));
            jarArchiver.addFileSet((FileSet)javaResourceFileSet);
        }
    }
}

