/*
 * Decompiled with CFR 0.152.
 */
package com.javadocmd.simplelatlng.window;

import com.javadocmd.simplelatlng.LatLng;
import com.javadocmd.simplelatlng.util.LatLngConfig;
import com.javadocmd.simplelatlng.util.LengthUnit;
import com.javadocmd.simplelatlng.window.FilterHelper;
import java.util.Collection;
import java.util.Iterator;

public abstract class LatLngWindow<T extends LatLngWindow<T>> {
    public static double lengthToLatitudeDelta(double length, LengthUnit unit) {
        return Math.toDegrees(length / LatLngConfig.getEarthRadius(unit));
    }

    public static double latitudeDeltaToLength(double deltaLat, LengthUnit unit) {
        return LatLngConfig.getEarthRadius(unit) * Math.toRadians(deltaLat);
    }

    public static double lengthToLongitudeDelta(double length, LengthUnit unit, double latitude) {
        return Math.toDegrees(length / (LatLngConfig.getEarthRadius(unit) * Math.cos(Math.toRadians(latitude))));
    }

    public static double longitudeDeltaToLength(double deltaLng, LengthUnit unit, double latitude) {
        return LatLngConfig.getEarthRadius(unit) * Math.toRadians(deltaLng) * Math.cos(Math.toRadians(latitude));
    }

    public abstract LatLng getCenter();

    public abstract boolean contains(LatLng var1);

    public abstract boolean overlaps(T var1);

    public <E> void filter(Collection<E> collection, FilterHelper<E> helper) {
        Iterator<E> i = collection.iterator();
        while (i.hasNext()) {
            E object = i.next();
            if (this.contains(helper.getLatLng(object))) continue;
            i.remove();
        }
    }

    public <E> void filterCopy(Collection<E> source, Collection<E> destination, FilterHelper<E> helper) {
        for (E object : source) {
            if (!this.contains(helper.getLatLng(object))) continue;
            destination.add(object);
        }
    }
}

