/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.parser;

import com.itextpdf.text.xml.XMLUtil;
import com.itextpdf.text.xml.simpleparser.IanaEncodings;
import com.itextpdf.tool.xml.parser.State;
import com.itextpdf.tool.xml.parser.StateController;
import com.itextpdf.tool.xml.parser.TagState;
import com.itextpdf.tool.xml.parser.XMLParserListener;
import com.itextpdf.tool.xml.parser.XMLParserMemory;
import com.itextpdf.tool.xml.parser.io.MonitorInputReader;
import com.itextpdf.tool.xml.parser.io.ParserMonitor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class XMLParser {
    private State state;
    private final StateController controller;
    private final List<XMLParserListener> listeners;
    private final XMLParserMemory memory;
    private ParserMonitor monitor;
    private byte[] text = null;
    private TagState tagState;

    public XMLParser() {
        this(true);
    }

    public XMLParser(boolean isHtml) {
        this.controller = new StateController(this, isHtml);
        this.controller.unknown();
        this.memory = new XMLParserMemory();
        this.listeners = new CopyOnWriteArrayList<XMLParserListener>();
    }

    public XMLParser(XMLParserListener listener) {
        this(true);
        this.listeners.add(listener);
    }

    public XMLParser(boolean isHtml, XMLParserListener listener) {
        this(isHtml);
        this.listeners.add(listener);
    }

    public XMLParser addListener(XMLParserListener pl) {
        this.listeners.add(pl);
        return this;
    }

    public XMLParser removeListener(XMLParserListener pl) {
        this.listeners.remove(pl);
        return this;
    }

    public void parse(InputStream in) throws IOException {
        this.parseStream(in);
    }

    public void parse(InputStream in, boolean detectEncoding) throws IOException {
        if (detectEncoding) {
            this.parse(this.detectEncoding(in));
        } else {
            this.parse(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(Reader reader) throws IOException {
        int read = -1;
        Reader r = this.monitor != null ? new MonitorInputReader(reader, this.monitor) : reader;
        try {
            while (-1 != (read = r.read())) {
                this.state.process(read);
            }
        }
        finally {
            r.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseStream(InputStream r) throws IOException {
        int read = -1;
        try {
            while (-1 != (read = r.read())) {
                this.state.process(read);
            }
        }
        finally {
            r.close();
        }
    }

    public InputStreamReader detectEncoding(InputStream in) throws IOException, UnsupportedEncodingException {
        byte[] b4 = new byte[4];
        int count = in.read(b4);
        if (count != 4) {
            throw new IOException("Insufficient length");
        }
        String encoding = XMLUtil.getEncodingName((byte[])b4);
        String decl = null;
        if (encoding.equals("UTF-8")) {
            int c;
            StringBuffer sb = new StringBuffer();
            while ((c = in.read()) != -1 && c != 62) {
                sb.append((char)c);
            }
            decl = sb.toString();
        } else if (encoding.equals("CP037")) {
            int c;
            ByteArrayOutputStream bi = new ByteArrayOutputStream();
            while ((c = in.read()) != -1 && c != 110) {
                bi.write(c);
            }
            decl = new String(bi.toByteArray(), "CP037");
        }
        if (decl != null && (decl = XMLParser.getDeclaredEncoding(decl)) != null) {
            encoding = decl;
        }
        return new InputStreamReader(in, IanaEncodings.getJavaEncoding((String)encoding));
    }

    protected void setState(State state) {
        this.state = state;
    }

    public XMLParser append(int character) {
        this.memory.current().write(character);
        return this;
    }

    public XMLParser append(char character) {
        this.memory.current().write(character);
        return this;
    }

    public StateController selectState() {
        return this.controller;
    }

    public void unknownData() {
        for (XMLParserListener l : this.listeners) {
            l.unknownText(this.memory.current().toString());
        }
    }

    public void flush() {
        this.memory.resetBuffer();
    }

    public byte[] current() {
        return this.memory.current().toByteArray();
    }

    public XMLParserMemory memory() {
        return this.memory;
    }

    public void startElement() {
        this.currentTagState(TagState.OPEN);
        this.callText();
        for (XMLParserListener l : this.listeners) {
            l.startElement(this.memory.getCurrentTag(), this.memory.getAttributes(), this.memory.getNameSpace());
        }
    }

    private void callText() {
        if (null != this.text && this.text.length > 0) {
            for (XMLParserListener l : this.listeners) {
                l.text(this.text);
            }
            this.text = null;
        }
    }

    public void endElement() {
        this.currentTagState(TagState.CLOSE);
        this.callText();
        for (XMLParserListener l : this.listeners) {
            l.endElement(this.memory.getCurrentTag(), this.memory.getNameSpace());
        }
    }

    public void text(byte[] bs) {
        this.text = bs;
    }

    public void comment() {
        this.callText();
        for (XMLParserListener l : this.listeners) {
            l.comment(this.memory.current().toString());
        }
    }

    private static String getDeclaredEncoding(String decl) {
        int idx2;
        if (decl == null) {
            return null;
        }
        int idx = decl.indexOf("encoding");
        if (idx < 0) {
            return null;
        }
        int idx1 = decl.indexOf(34, idx);
        if (idx1 == (idx2 = decl.indexOf(39, idx))) {
            return null;
        }
        if (idx1 < 0 && idx2 > 0 || idx2 > 0 && idx2 < idx1) {
            int idx3 = decl.indexOf(39, idx2 + 1);
            if (idx3 < 0) {
                return null;
            }
            return decl.substring(idx2 + 1, idx3);
        }
        if (idx2 < 0 && idx1 > 0 || idx1 > 0 && idx1 < idx2) {
            int idx3 = decl.indexOf(34, idx1 + 1);
            if (idx3 < 0) {
                return null;
            }
            return decl.substring(idx1 + 1, idx3);
        }
        return null;
    }

    public char currentLastChar() {
        byte[] current = this.memory.current().toByteArray();
        if (current.length > 0) {
            return (char)(current.length - 1);
        }
        return ' ';
    }

    public String currentTag() {
        return this.memory.getCurrentTag();
    }

    public TagState currentTagState() {
        return this.tagState;
    }

    private void currentTagState(TagState state) {
        this.tagState = state;
    }

    public void setMonitor(ParserMonitor monitor) {
        this.monitor = monitor;
    }

    public String bufferToString() {
        return this.memory.current().toString();
    }

    public XMLParser append(byte[] bytes) {
        for (byte b : bytes) {
            this.memory.current().write(b);
        }
        return this;
    }

    public int bufferSize() {
        return null != this.memory.current() ? this.memory.current().size() : 0;
    }
}

