/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.html;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.Element;
import com.itextpdf.text.Paragraph;
import com.itextpdf.tool.xml.NoCustomContextException;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.WorkerContext;
import com.itextpdf.tool.xml.css.FontSizeTranslator;
import com.itextpdf.tool.xml.css.apply.NoNewLineParagraphCssApplier;
import com.itextpdf.tool.xml.css.apply.ParagraphCssApplier;
import com.itextpdf.tool.xml.exceptions.LocaleMessages;
import com.itextpdf.tool.xml.exceptions.RuntimeWorkerException;
import com.itextpdf.tool.xml.html.TagProcessor;
import com.itextpdf.tool.xml.html.pdfelement.NoNewLineParagraph;
import com.itextpdf.tool.xml.pipeline.css.CSSResolver;
import com.itextpdf.tool.xml.pipeline.css.CssResolverPipeline;
import com.itextpdf.tool.xml.pipeline.ctx.MapContext;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipeline;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipelineContext;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTagProcessor
implements TagProcessor {
    private final FontSizeTranslator fontsizeTrans;
    private final ThreadLocal<WorkerContext> ctxLocal = new ThreadLocal();

    public AbstractTagProcessor() {
        this.fontsizeTrans = FontSizeTranslator.getInstance();
    }

    @Override
    public void setContext(WorkerContext context) {
        this.ctxLocal.set(context);
    }

    public CSSResolver getCSSResolver() throws NoCustomContextException {
        return (CSSResolver)((MapContext)this.ctxLocal.get().get(CssResolverPipeline.class.getName())).get("CSS_RESOLVER");
    }

    public HtmlPipelineContext getHtmlPipelineContext() throws NoCustomContextException {
        return (HtmlPipelineContext)this.ctxLocal.get().get(HtmlPipeline.class.getName());
    }

    @Override
    public final List<Element> startElement(Tag tag) {
        float fontSize = this.fontsizeTrans.translateFontSize(tag);
        tag.getCSS().put("font-size", fontSize + "pt");
        String pagebreak = tag.getCSS().get("page-break-before");
        if (null != pagebreak && "always".equalsIgnoreCase(pagebreak)) {
            ArrayList<Element> list = new ArrayList<Element>(2);
            list.add((Element)Chunk.NEXTPAGE);
            list.addAll(this.start(tag));
            return list;
        }
        return this.start(tag);
    }

    public List<Element> start(Tag tag) {
        return new ArrayList<Element>(0);
    }

    @Override
    public List<Element> content(Tag tag, String content) {
        return new ArrayList<Element>(0);
    }

    @Override
    public final List<Element> endElement(Tag tag, List<Element> currentContent) {
        List<Element> list = this.end(tag, currentContent);
        String pagebreak = tag.getCSS().get("page-break-after");
        if (null != pagebreak && "always".equalsIgnoreCase(pagebreak)) {
            list.add((Element)Chunk.NEXTPAGE);
            return list;
        }
        return list;
    }

    public List<Element> end(Tag tag, List<Element> currentContent) {
        return new ArrayList<Element>(currentContent);
    }

    @Override
    public boolean isStackOwner() {
        return false;
    }

    public final List<Element> currentContentToParagraph(List<Element> currentContent, boolean addNewLines, boolean applyCSS, Tag tag) {
        try {
            ArrayList<Element> list = new ArrayList<Element>();
            if (currentContent.size() > 0) {
                if (addNewLines) {
                    Paragraph p = new Paragraph();
                    for (Element e : currentContent) {
                        p.add(e);
                    }
                    if (applyCSS) {
                        p = new ParagraphCssApplier(this.getHtmlPipelineContext()).apply(p, tag);
                    }
                    list.add((Element)p);
                } else {
                    NoNewLineParagraph p = new NoNewLineParagraph();
                    for (Element e : currentContent) {
                        p.add(e);
                    }
                    p = new NoNewLineParagraphCssApplier(this.getHtmlPipelineContext()).apply(p, tag);
                    list.add((Element)p);
                }
            }
            return list;
        }
        catch (NoCustomContextException e) {
            throw new RuntimeWorkerException(LocaleMessages.getInstance().getMessage("customcontext.404"), e);
        }
    }

    public final List<Element> currentContentToParagraph(List<Element> currentContent, boolean addNewLines) {
        return this.currentContentToParagraph(currentContent, addNewLines, false, null);
    }
}

