/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.css.apply;

import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.css.CssApplier;
import com.itextpdf.tool.xml.css.CssUtils;
import com.itextpdf.tool.xml.css.FontSizeTranslator;
import com.itextpdf.tool.xml.css.apply.MaxLeadingAndSize;
import com.itextpdf.tool.xml.html.pdfelement.NoNewLineParagraph;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipelineContext;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoNewLineParagraphCssApplier
implements CssApplier<NoNewLineParagraph> {
    private final CssUtils utils = CssUtils.getInstance();
    private final MaxLeadingAndSize m = new MaxLeadingAndSize();
    private final HtmlPipelineContext configuration;

    public NoNewLineParagraphCssApplier(HtmlPipelineContext htmlPipelineContext) {
        this.configuration = htmlPipelineContext;
    }

    @Override
    public NoNewLineParagraph apply(NoNewLineParagraph p, Tag t) {
        if (this.configuration.getRootTags().contains(t.getTag())) {
            this.m.setLeading(t);
        } else {
            this.m.setVariablesBasedOnChildren(t);
        }
        float fontSize = FontSizeTranslator.getInstance().getFontSize(t);
        float lmb = 0.0f;
        boolean hasLMB = false;
        Map<String, String> css = t.getCSS();
        for (Map.Entry<String, String> entry : css.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if ("margin-top".equalsIgnoreCase(key)) {
                p.setSpacingBefore(p.getSpacingBefore() + this.utils.calculateMarginTop(value, fontSize, this.configuration));
                continue;
            }
            if ("padding-top".equalsIgnoreCase(key)) {
                p.setSpacingBefore(p.getSpacingBefore() + this.utils.parseValueToPt(value, fontSize));
                continue;
            }
            if ("margin-bottom".equalsIgnoreCase(key)) {
                float after = this.utils.parseValueToPt(value, fontSize);
                p.setSpacingAfter(p.getSpacingAfter() + after);
                lmb = after;
                hasLMB = true;
                continue;
            }
            if ("padding-bottom".equalsIgnoreCase(key)) {
                p.setSpacingAfter(p.getSpacingAfter() + this.utils.parseValueToPt(value, fontSize));
                continue;
            }
            if ("margin-left".equalsIgnoreCase(key)) {
                p.setIndentationLeft(p.getIndentationLeft() + this.utils.parseValueToPt(value, fontSize));
                continue;
            }
            if ("margin-right".equalsIgnoreCase(key)) {
                p.setIndentationRight(p.getIndentationRight() + this.utils.parseValueToPt(value, fontSize));
                continue;
            }
            if ("padding-left".equalsIgnoreCase(key)) {
                p.setIndentationLeft(p.getIndentationLeft() + this.utils.parseValueToPt(value, fontSize));
                continue;
            }
            if ("padding-right".equalsIgnoreCase(key)) {
                p.setIndentationRight(p.getIndentationRight() + this.utils.parseValueToPt(value, fontSize));
                continue;
            }
            if ("text-align".equalsIgnoreCase(key)) {
                if ("right".equalsIgnoreCase(value)) {
                    p.setAlignment(2);
                    continue;
                }
                if ("center".equalsIgnoreCase(value)) {
                    p.setAlignment(1);
                    continue;
                }
                if ("left".equalsIgnoreCase(value)) {
                    p.setAlignment(0);
                    continue;
                }
                if (!"justify".equalsIgnoreCase(value)) continue;
                p.setAlignment(3);
                continue;
            }
            if (!"text-indent".equalsIgnoreCase(key)) continue;
            p.setFirstLineIndent(this.utils.parseValueToPt(value, fontSize));
        }
        if (null != t.getParent()) {
            String parent = t.getParent().getTag();
            if (css.get("margin-top") == null && this.configuration.getRootTags().contains(parent)) {
                p.setSpacingBefore(p.getSpacingBefore() + this.utils.calculateMarginTop(fontSize + "pt", 0.0f, this.configuration));
            }
            if (css.get("margin-bottom") == null && this.configuration.getRootTags().contains(parent)) {
                p.setSpacingAfter(p.getSpacingAfter() + fontSize);
                css.put("margin-bottom", fontSize + "pt");
                lmb = fontSize;
                hasLMB = true;
            }
            p.setLeading(this.m.getLargestLeading());
            if (p.getAlignment() == -1) {
                p.setAlignment(0);
            }
        }
        if (hasLMB) {
            this.configuration.getMemory().put("lastMarginBottom", Float.valueOf(lmb));
        }
        return p;
    }
}

