/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures;

import com.itextpdf.forms.PdfAcroForm;
import com.itextpdf.forms.PdfSigFieldLockDictionary;
import com.itextpdf.forms.fields.PdfFormField;
import com.itextpdf.forms.fields.PdfSignatureFormField;
import com.itextpdf.io.source.ByteBuffer;
import com.itextpdf.io.source.IRandomAccessSource;
import com.itextpdf.io.source.RASInputStream;
import com.itextpdf.io.source.RandomAccessSourceFactory;
import com.itextpdf.io.util.DateTimeUtil;
import com.itextpdf.io.util.FileUtil;
import com.itextpdf.io.util.StreamUtil;
import com.itextpdf.kernel.PdfException;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDate;
import com.itextpdf.kernel.pdf.PdfDeveloperExtension;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfLiteral;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfOutputStream;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfReader;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.PdfVersion;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.kernel.pdf.StampingProperties;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfWidgetAnnotation;
import com.itextpdf.signatures.DigestAlgorithms;
import com.itextpdf.signatures.ICrlClient;
import com.itextpdf.signatures.IExternalDigest;
import com.itextpdf.signatures.IExternalSignature;
import com.itextpdf.signatures.IExternalSignatureContainer;
import com.itextpdf.signatures.IOcspClient;
import com.itextpdf.signatures.ITSAClient;
import com.itextpdf.signatures.PdfPKCS7;
import com.itextpdf.signatures.PdfSignature;
import com.itextpdf.signatures.PdfSignatureAppearance;
import com.itextpdf.signatures.SignUtils;
import com.itextpdf.signatures.SignatureUtil;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PdfSigner {
    public static final int NOT_CERTIFIED = 0;
    public static final int CERTIFIED_NO_CHANGES_ALLOWED = 1;
    public static final int CERTIFIED_FORM_FILLING = 2;
    public static final int CERTIFIED_FORM_FILLING_AND_ANNOTATIONS = 3;
    protected int certificationLevel = 0;
    protected String fieldName;
    protected RandomAccessFile raf;
    protected byte[] bout;
    protected long[] range;
    protected PdfDocument document;
    protected PdfSignature cryptoDictionary;
    protected ISignatureEvent signatureEvent;
    protected OutputStream originalOS;
    protected ByteArrayOutputStream temporaryOS;
    protected File tempFile;
    protected Map<PdfName, PdfLiteral> exclusionLocations;
    protected boolean preClosed = false;
    protected PdfSigFieldLockDictionary fieldLock;
    protected PdfSignatureAppearance appearance;
    protected Calendar signDate;
    protected boolean closed;

    public PdfSigner(PdfReader reader, OutputStream outputStream, boolean append) throws IOException {
        this(reader, outputStream, null, append);
    }

    public PdfSigner(PdfReader reader, OutputStream outputStream, String path, boolean append) throws IOException {
        StampingProperties properties = new StampingProperties().preserveEncryption();
        if (append) {
            properties.useAppendMode();
        }
        if (path == null) {
            this.temporaryOS = new ByteArrayOutputStream();
            this.document = new PdfDocument(reader, new PdfWriter((OutputStream)this.temporaryOS), properties);
        } else {
            this.tempFile = FileUtil.createTempFile((String)path);
            this.document = new PdfDocument(reader, new PdfWriter((OutputStream)FileUtil.getFileOutputStream((File)this.tempFile)), properties);
        }
        this.originalOS = outputStream;
        this.signDate = DateTimeUtil.getCurrentTimeCalendar();
        this.fieldName = this.getNewSigFieldName();
        this.appearance = new PdfSignatureAppearance(this.document, new Rectangle(0.0f, 0.0f), 1);
        this.appearance.setSignDate(this.signDate);
        this.closed = false;
    }

    public Calendar getSignDate() {
        return this.signDate;
    }

    public void setSignDate(Calendar signDate) {
        this.signDate = signDate;
        this.appearance.setSignDate(signDate);
    }

    public PdfSignatureAppearance getSignatureAppearance() {
        return this.appearance;
    }

    public int getCertificationLevel() {
        return this.certificationLevel;
    }

    public void setCertificationLevel(int certificationLevel) {
        this.certificationLevel = certificationLevel;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public PdfSignature getSignatureDictionary() {
        return this.cryptoDictionary;
    }

    public ISignatureEvent getSignatureEvent() {
        return this.signatureEvent;
    }

    public void setSignatureEvent(ISignatureEvent signatureEvent) {
        this.signatureEvent = signatureEvent;
    }

    public String getNewSigFieldName() {
        PdfAcroForm acroForm = PdfAcroForm.getAcroForm((PdfDocument)this.document, (boolean)true);
        String name = "Signature";
        int step = 1;
        while (acroForm.getField(name + step) != null) {
            ++step;
        }
        return name + step;
    }

    public void setFieldName(String fieldName) {
        if (fieldName != null) {
            if (fieldName.indexOf(46) >= 0) {
                throw new IllegalArgumentException("Field names cannot contain a dot.");
            }
            PdfAcroForm acroForm = PdfAcroForm.getAcroForm((PdfDocument)this.document, (boolean)true);
            if (acroForm.getField(fieldName) != null) {
                PdfFormField field = acroForm.getField(fieldName);
                if (!PdfName.Sig.equals((Object)field.getFormType())) {
                    throw new IllegalArgumentException("Field type is not a signature field type.");
                }
                if (field.getValue() != null) {
                    throw new IllegalArgumentException("Field has been already signed.");
                }
                this.appearance.setFieldName(fieldName);
                List widgets = field.getWidgets();
                if (widgets.size() > 0) {
                    PdfWidgetAnnotation widget = (PdfWidgetAnnotation)widgets.get(0);
                    this.appearance.setPageRect(this.getWidgetRectangle(widget));
                    this.appearance.setPageNumber(this.getWidgetPageNumber(widget));
                }
            }
            this.fieldName = fieldName;
        }
    }

    public PdfDocument getDocument() {
        return this.document;
    }

    protected void setDocument(PdfDocument document) {
        this.document = document;
    }

    public void setOriginalOutputStream(OutputStream originalOS) {
        this.originalOS = originalOS;
    }

    public PdfSigFieldLockDictionary getFieldLockDict() {
        return this.fieldLock;
    }

    public void setFieldLockDict(PdfSigFieldLockDictionary fieldLock) {
        this.fieldLock = fieldLock;
    }

    public void signDetached(IExternalDigest externalDigest, IExternalSignature externalSignature, Certificate[] chain, Collection<ICrlClient> crlList, IOcspClient ocspClient, ITSAClient tsaClient, int estimatedSize, CryptoStandard sigtype) throws IOException, GeneralSecurityException {
        if (this.closed) {
            throw new PdfException("This instance of PdfSigner has been already closed.");
        }
        Collection<byte[]> crlBytes = null;
        int i = 0;
        while (crlBytes == null && i < chain.length) {
            crlBytes = this.processCrl(chain[i++], crlList);
        }
        if (estimatedSize == 0) {
            estimatedSize = 8192;
            if (crlBytes != null) {
                for (byte[] element : crlBytes) {
                    estimatedSize += element.length + 10;
                }
            }
            if (ocspClient != null) {
                estimatedSize += 4192;
            }
            if (tsaClient != null) {
                estimatedSize += 4192;
            }
        }
        PdfSignatureAppearance appearance = this.getSignatureAppearance();
        appearance.setCertificate(chain[0]);
        if (sigtype == CryptoStandard.CADES) {
            this.addDeveloperExtension(PdfDeveloperExtension.ESIC_1_7_EXTENSIONLEVEL2);
        }
        PdfSignature dic = new PdfSignature(PdfName.Adobe_PPKLite, sigtype == CryptoStandard.CADES ? PdfName.ETSI_CAdES_DETACHED : PdfName.Adbe_pkcs7_detached);
        dic.setReason(appearance.getReason());
        dic.setLocation(appearance.getLocation());
        dic.setSignatureCreator(appearance.getSignatureCreator());
        dic.setContact(appearance.getContact());
        dic.setDate(new PdfDate(this.getSignDate()));
        this.cryptoDictionary = dic;
        HashMap<PdfName, Integer> exc = new HashMap<PdfName, Integer>();
        exc.put(PdfName.Contents, estimatedSize * 2 + 2);
        this.preClose(exc);
        String hashAlgorithm = externalSignature.getHashAlgorithm();
        PdfPKCS7 sgn = new PdfPKCS7(null, chain, hashAlgorithm, null, externalDigest, false);
        InputStream data = this.getRangeStream();
        byte[] hash = DigestAlgorithms.digest(data, SignUtils.getMessageDigest(hashAlgorithm, externalDigest));
        byte[] ocsp = null;
        if (chain.length >= 2 && ocspClient != null) {
            ocsp = ocspClient.getEncoded((X509Certificate)chain[0], (X509Certificate)chain[1], null);
        }
        byte[] sh = sgn.getAuthenticatedAttributeBytes(hash, ocsp, crlBytes, sigtype);
        byte[] extSignature = externalSignature.sign(sh);
        sgn.setExternalDigest(extSignature, null, externalSignature.getEncryptionAlgorithm());
        byte[] encodedSig = sgn.getEncodedPKCS7(hash, tsaClient, ocsp, crlBytes, sigtype);
        if (estimatedSize < encodedSig.length) {
            throw new IOException("Not enough space");
        }
        byte[] paddedSig = new byte[estimatedSize];
        System.arraycopy(encodedSig, 0, paddedSig, 0, encodedSig.length);
        PdfDictionary dic2 = new PdfDictionary();
        dic2.put(PdfName.Contents, (PdfObject)new PdfString(paddedSig).setHexWriting(true));
        this.close(dic2);
        this.closed = true;
    }

    public void signExternalContainer(IExternalSignatureContainer externalSignatureContainer, int estimatedSize) throws GeneralSecurityException, IOException {
        if (this.closed) {
            throw new PdfException("This instance of PdfSigner has been already closed.");
        }
        PdfSignature dic = new PdfSignature();
        PdfSignatureAppearance appearance = this.getSignatureAppearance();
        dic.setReason(appearance.getReason());
        dic.setLocation(appearance.getLocation());
        dic.setSignatureCreator(appearance.getSignatureCreator());
        dic.setContact(appearance.getContact());
        dic.setDate(new PdfDate(this.getSignDate()));
        externalSignatureContainer.modifySigningDictionary((PdfDictionary)dic.getPdfObject());
        this.cryptoDictionary = dic;
        HashMap<PdfName, Integer> exc = new HashMap<PdfName, Integer>();
        exc.put(PdfName.Contents, estimatedSize * 2 + 2);
        this.preClose(exc);
        InputStream data = this.getRangeStream();
        byte[] encodedSig = externalSignatureContainer.sign(data);
        if (estimatedSize < encodedSig.length) {
            throw new IOException("Not enough space");
        }
        byte[] paddedSig = new byte[estimatedSize];
        System.arraycopy(encodedSig, 0, paddedSig, 0, encodedSig.length);
        PdfDictionary dic2 = new PdfDictionary();
        dic2.put(PdfName.Contents, (PdfObject)new PdfString(paddedSig).setHexWriting(true));
        this.close(dic2);
        this.closed = true;
    }

    public void timestamp(ITSAClient tsa, String signatureName) throws IOException, GeneralSecurityException {
        byte[] tsToken;
        int n;
        if (this.closed) {
            throw new PdfException("This instance of PdfSigner has been already closed.");
        }
        int contentEstimated = tsa.getTokenSizeEstimate();
        this.addDeveloperExtension(PdfDeveloperExtension.ESIC_1_7_EXTENSIONLEVEL5);
        this.setFieldName(signatureName);
        PdfSignature dic = new PdfSignature(PdfName.Adobe_PPKLite, PdfName.ETSI_RFC3161);
        dic.put(PdfName.Type, (PdfObject)PdfName.DocTimeStamp);
        this.cryptoDictionary = dic;
        HashMap<PdfName, Integer> exc = new HashMap<PdfName, Integer>();
        exc.put(PdfName.Contents, contentEstimated * 2 + 2);
        this.preClose(exc);
        InputStream data = this.getRangeStream();
        MessageDigest messageDigest = tsa.getMessageDigest();
        byte[] buf = new byte[4096];
        while ((n = data.read(buf)) > 0) {
            messageDigest.update(buf, 0, n);
        }
        byte[] tsImprint = messageDigest.digest();
        try {
            tsToken = tsa.getTimeStampToken(tsImprint);
        }
        catch (Exception e) {
            throw new GeneralSecurityException(e.getMessage(), e);
        }
        if (contentEstimated + 2 < tsToken.length) {
            throw new IOException("Not enough space");
        }
        byte[] paddedSig = new byte[contentEstimated];
        System.arraycopy(tsToken, 0, paddedSig, 0, tsToken.length);
        PdfDictionary dic2 = new PdfDictionary();
        dic2.put(PdfName.Contents, (PdfObject)new PdfString(paddedSig).setHexWriting(true));
        this.close(dic2);
        this.closed = true;
    }

    public static void signDeferred(PdfDocument document, String fieldName, OutputStream outs, IExternalSignatureContainer externalSignatureContainer) throws IOException, GeneralSecurityException {
        SignatureUtil signatureUtil = new SignatureUtil(document);
        PdfDictionary v = signatureUtil.getSignatureDictionary(fieldName);
        if (v == null) {
            throw new PdfException("There is no field in the document with such name: {0}.").setMessageParams(new Object[]{fieldName});
        }
        if (!signatureUtil.signatureCoversWholeDocument(fieldName)) {
            new PdfException("Signature with name {0} is not the last. It doesn't cover the whole document.").setMessageParams(new Object[]{fieldName});
        }
        PdfArray b = v.getAsArray(PdfName.ByteRange);
        long[] gaps = SignatureUtil.asLongArray(b);
        if (b.size() != 4 || gaps[0] != 0L) {
            throw new IllegalArgumentException("Single exclusion space supported");
        }
        IRandomAccessSource readerSource = document.getReader().getSafeFile().createSourceView();
        RASInputStream rg = new RASInputStream(new RandomAccessSourceFactory().createRanged(readerSource, gaps));
        byte[] signedContent = externalSignatureContainer.sign((InputStream)rg);
        int spaceAvailable = (int)(gaps[2] - gaps[1]) - 2;
        if ((spaceAvailable & 1) != 0) {
            throw new IllegalArgumentException("Gap is not a multiple of 2");
        }
        if ((spaceAvailable /= 2) < signedContent.length) {
            throw new PdfException("Available space is not enough for signature.");
        }
        StreamUtil.copyBytes((IRandomAccessSource)readerSource, (long)0L, (long)(gaps[1] + 1L), (OutputStream)outs);
        ByteBuffer bb = new ByteBuffer(spaceAvailable * 2);
        for (byte bi : signedContent) {
            bb.appendHex(bi);
        }
        int remain = (spaceAvailable - signedContent.length) * 2;
        for (int k = 0; k < remain; ++k) {
            bb.append((byte)48);
        }
        byte[] bbArr = bb.toByteArray();
        outs.write(bbArr);
        StreamUtil.copyBytes((IRandomAccessSource)readerSource, (long)(gaps[2] - 1L), (long)(gaps[3] + 1L), (OutputStream)outs);
    }

    protected Collection<byte[]> processCrl(Certificate cert, Collection<ICrlClient> crlList) {
        if (crlList == null) {
            return null;
        }
        ArrayList<byte[]> crlBytes = new ArrayList<byte[]>();
        for (ICrlClient cc : crlList) {
            Collection<byte[]> b;
            if (cc == null || (b = cc.getEncoded((X509Certificate)cert, null)) == null) continue;
            crlBytes.addAll(b);
        }
        if (crlBytes.size() == 0) {
            return null;
        }
        return crlBytes;
    }

    protected void addDeveloperExtension(PdfDeveloperExtension extension) {
        this.document.getCatalog().addDeveloperExtension(extension);
    }

    protected boolean isPreClosed() {
        return this.preClosed;
    }

    protected void preClose(Map<PdfName, Integer> exclusionSizes) throws IOException {
        PdfDictionary ap;
        if (this.preClosed) {
            throw new PdfException("Document has been already pre closed.");
        }
        this.preClosed = true;
        PdfAcroForm acroForm = PdfAcroForm.getAcroForm((PdfDocument)this.document, (boolean)true);
        SignatureUtil sgnUtil = new SignatureUtil(this.document);
        String name = this.getFieldName();
        boolean fieldExist = sgnUtil.doesSignatureFieldExist(name);
        acroForm.setSignatureFlags(3);
        PdfSigFieldLockDictionary fieldLock = null;
        if (this.cryptoDictionary == null) {
            throw new PdfException("No crypto dictionary defined.");
        }
        ((PdfDictionary)this.cryptoDictionary.getPdfObject()).makeIndirect(this.document);
        if (fieldExist) {
            int n;
            PdfSignatureFormField sigField = (PdfSignatureFormField)acroForm.getField(this.fieldName);
            sigField.put(PdfName.V, this.cryptoDictionary.getPdfObject());
            fieldLock = sigField.getSigFieldLockDictionary();
            if (fieldLock == null && this.fieldLock != null) {
                ((PdfDictionary)this.fieldLock.getPdfObject()).makeIndirect(this.document);
                sigField.put(PdfName.Lock, this.fieldLock.getPdfObject());
                fieldLock = this.fieldLock;
            }
            sigField.put(PdfName.P, this.document.getPage(this.appearance.getPageNumber()).getPdfObject());
            sigField.put(PdfName.V, this.cryptoDictionary.getPdfObject());
            PdfObject obj = ((PdfDictionary)sigField.getPdfObject()).get(PdfName.F);
            boolean bl = false;
            if (obj != null && obj.isNumber()) {
                n = ((PdfNumber)obj).intValue();
            }
            int n2 = n | 0x80;
            sigField.put(PdfName.F, (PdfObject)new PdfNumber(n2));
            ap = new PdfDictionary();
            ap.put(PdfName.N, this.appearance.getAppearance().getPdfObject());
            sigField.put(PdfName.AP, (PdfObject)ap);
            sigField.setModified();
        } else {
            PdfWidgetAnnotation widget = new PdfWidgetAnnotation(this.appearance.getPageRect());
            widget.setFlags(132);
            PdfSignatureFormField sigField = PdfFormField.createSignature((PdfDocument)this.document);
            sigField.setFieldName(name);
            sigField.put(PdfName.V, this.cryptoDictionary.getPdfObject());
            sigField.addKid(widget);
            if (this.fieldLock != null) {
                ((PdfDictionary)this.fieldLock.getPdfObject()).makeIndirect(this.document);
                sigField.put(PdfName.Lock, this.fieldLock.getPdfObject());
                fieldLock = this.fieldLock;
            }
            int n = this.appearance.getPageNumber();
            widget.setPage(this.document.getPage(n));
            ap = widget.getAppearanceDictionary();
            if (ap == null) {
                ap = new PdfDictionary();
                widget.put(PdfName.AP, (PdfObject)ap);
            }
            ap.put(PdfName.N, this.appearance.getAppearance().getPdfObject());
            acroForm.addField((PdfFormField)sigField, this.document.getPage(n));
            if (((PdfDictionary)acroForm.getPdfObject()).isIndirect()) {
                acroForm.setModified();
            } else {
                this.document.getCatalog().setModified();
            }
        }
        this.exclusionLocations = new HashMap<PdfName, PdfLiteral>();
        PdfLiteral lit = new PdfLiteral(80);
        this.exclusionLocations.put(PdfName.ByteRange, lit);
        this.cryptoDictionary.put(PdfName.ByteRange, (PdfObject)lit);
        for (Map.Entry entry : exclusionSizes.entrySet()) {
            PdfName key = (PdfName)entry.getKey();
            lit = new PdfLiteral(((Integer)entry.getValue()).intValue());
            this.exclusionLocations.put(key, lit);
            this.cryptoDictionary.put(key, (PdfObject)lit);
        }
        if (this.certificationLevel > 0) {
            this.addDocMDP(this.cryptoDictionary);
        }
        if (fieldLock != null) {
            this.addFieldMDP(this.cryptoDictionary, fieldLock);
        }
        if (this.signatureEvent != null) {
            this.signatureEvent.getSignatureDictionary(this.cryptoDictionary);
        }
        if (this.certificationLevel > 0) {
            PdfDictionary docmdp = new PdfDictionary();
            docmdp.put(PdfName.DocMDP, this.cryptoDictionary.getPdfObject());
            this.document.getCatalog().put(PdfName.Perms, (PdfObject)docmdp);
            this.document.getCatalog().setModified();
        }
        ((PdfDictionary)this.cryptoDictionary.getPdfObject()).flush(false);
        this.document.close();
        this.range = new long[this.exclusionLocations.size() * 2];
        long byteRangePosition = this.exclusionLocations.get(PdfName.ByteRange).getPosition();
        this.exclusionLocations.remove(PdfName.ByteRange);
        int idx = 1;
        for (PdfLiteral lit1 : this.exclusionLocations.values()) {
            long n = lit1.getPosition();
            this.range[idx++] = n;
            this.range[idx++] = (long)lit1.getBytesCount() + n;
        }
        Arrays.sort(this.range, 1, this.range.length - 1);
        for (int k = 3; k < this.range.length - 2; k += 2) {
            int n = k;
            this.range[n] = this.range[n] - this.range[k - 1];
        }
        if (this.tempFile == null) {
            this.bout = this.temporaryOS.toByteArray();
            this.range[this.range.length - 1] = (long)this.bout.length - this.range[this.range.length - 2];
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            PdfOutputStream os = new PdfOutputStream((OutputStream)bos);
            os.write(91);
            for (int k = 0; k < this.range.length; ++k) {
                ((PdfOutputStream)os.writeLong(this.range[k])).write(32);
            }
            os.write(93);
            System.arraycopy(bos.toByteArray(), 0, this.bout, (int)byteRangePosition, bos.size());
        } else {
            try {
                this.raf = FileUtil.getRandomAccessFile((File)this.tempFile);
                long len = this.raf.length();
                this.range[this.range.length - 1] = len - this.range[this.range.length - 2];
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                PdfOutputStream os = new PdfOutputStream((OutputStream)bos);
                os.write(91);
                for (int k = 0; k < this.range.length; ++k) {
                    ((PdfOutputStream)os.writeLong(this.range[k])).write(32);
                }
                os.write(93);
                this.raf.seek(byteRangePosition);
                this.raf.write(bos.toByteArray(), 0, bos.size());
            }
            catch (IOException e) {
                try {
                    this.raf.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.tempFile.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e;
            }
        }
    }

    protected InputStream getRangeStream() throws IOException {
        RandomAccessSourceFactory fac = new RandomAccessSourceFactory();
        return new RASInputStream(fac.createRanged(this.getUnderlyingSource(), this.range));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close(PdfDictionary update) throws IOException {
        try {
            if (!this.preClosed) {
                throw new PdfException("Document must be preClosed.");
            }
            ByteArrayOutputStream bous = new ByteArrayOutputStream();
            PdfOutputStream os = new PdfOutputStream((OutputStream)bous);
            for (PdfName key : update.keySet()) {
                PdfObject obj = update.get(key);
                PdfLiteral lit = this.exclusionLocations.get(key);
                if (lit == null) {
                    throw new IllegalArgumentException("The key didn't reserve space in preclose");
                }
                bous.reset();
                os.write(obj);
                if (bous.size() > lit.getBytesCount()) {
                    throw new IllegalArgumentException("The key is too big");
                }
                if (this.tempFile == null) {
                    System.arraycopy(bous.toByteArray(), 0, this.bout, (int)lit.getPosition(), bous.size());
                    continue;
                }
                this.raf.seek(lit.getPosition());
                this.raf.write(bous.toByteArray(), 0, bous.size());
            }
            if (update.size() != this.exclusionLocations.size()) {
                throw new IllegalArgumentException("The update dictionary has less keys than required");
            }
            if (this.tempFile == null) {
                this.originalOS.write(this.bout, 0, this.bout.length);
            } else if (this.originalOS != null) {
                int r;
                this.raf.seek(0L);
                byte[] buf = new byte[8192];
                for (long length = this.raf.length(); length > 0L; length -= (long)r) {
                    r = this.raf.read(buf, 0, (int)Math.min((long)buf.length, length));
                    if (r < 0) {
                        throw new EOFException("unexpected eof");
                    }
                    this.originalOS.write(buf, 0, r);
                }
            }
        }
        finally {
            if (this.tempFile != null) {
                this.raf.close();
                if (this.originalOS != null) {
                    this.tempFile.delete();
                }
            }
            if (this.originalOS != null) {
                try {
                    this.originalOS.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected IRandomAccessSource getUnderlyingSource() throws IOException {
        RandomAccessSourceFactory fac = new RandomAccessSourceFactory();
        return this.raf == null ? fac.createSource(this.bout) : fac.createSource(this.raf);
    }

    protected void addDocMDP(PdfSignature crypto) {
        PdfDictionary reference = new PdfDictionary();
        PdfDictionary transformParams = new PdfDictionary();
        transformParams.put(PdfName.P, (PdfObject)new PdfNumber(this.certificationLevel));
        transformParams.put(PdfName.V, (PdfObject)new PdfName("1.2"));
        transformParams.put(PdfName.Type, (PdfObject)PdfName.TransformParams);
        reference.put(PdfName.TransformMethod, (PdfObject)PdfName.DocMDP);
        reference.put(PdfName.Type, (PdfObject)PdfName.SigRef);
        reference.put(PdfName.TransformParams, (PdfObject)transformParams);
        if (this.document.getPdfVersion().compareTo(PdfVersion.PDF_1_6) < 0) {
            reference.put(new PdfName("DigestValue"), (PdfObject)new PdfString("aa"));
            PdfArray loc = new PdfArray();
            loc.add((PdfObject)new PdfNumber(0));
            loc.add((PdfObject)new PdfNumber(0));
            reference.put(new PdfName("DigestLocation"), (PdfObject)loc);
            reference.put(new PdfName("DigestMethod"), (PdfObject)new PdfName("MD5"));
        }
        reference.put(PdfName.Data, this.document.getTrailer().get(PdfName.Root));
        PdfArray types = new PdfArray();
        types.add((PdfObject)reference);
        crypto.put(PdfName.Reference, (PdfObject)types);
    }

    protected void addFieldMDP(PdfSignature crypto, PdfSigFieldLockDictionary fieldLock) {
        PdfDictionary reference = new PdfDictionary();
        PdfDictionary transformParams = new PdfDictionary();
        transformParams.putAll((PdfDictionary)fieldLock.getPdfObject());
        transformParams.put(PdfName.Type, (PdfObject)PdfName.TransformParams);
        transformParams.put(PdfName.V, (PdfObject)new PdfName("1.2"));
        reference.put(PdfName.TransformMethod, (PdfObject)PdfName.FieldMDP);
        reference.put(PdfName.Type, (PdfObject)PdfName.SigRef);
        reference.put(PdfName.TransformParams, (PdfObject)transformParams);
        reference.put(new PdfName("DigestValue"), (PdfObject)new PdfString("aa"));
        PdfArray loc = new PdfArray();
        loc.add((PdfObject)new PdfNumber(0));
        loc.add((PdfObject)new PdfNumber(0));
        reference.put(new PdfName("DigestLocation"), (PdfObject)loc);
        reference.put(new PdfName("DigestMethod"), (PdfObject)new PdfName("MD5"));
        reference.put(PdfName.Data, this.document.getTrailer().get(PdfName.Root));
        PdfArray types = ((PdfDictionary)crypto.getPdfObject()).getAsArray(PdfName.Reference);
        if (types == null) {
            types = new PdfArray();
        }
        types.add((PdfObject)reference);
        crypto.put(PdfName.Reference, (PdfObject)types);
    }

    protected Rectangle getWidgetRectangle(PdfWidgetAnnotation widget) {
        return widget.getRectangle().toRectangle();
    }

    protected int getWidgetPageNumber(PdfWidgetAnnotation widget) {
        int pageNumber = 0;
        PdfDictionary pageDict = ((PdfDictionary)widget.getPdfObject()).getAsDictionary(PdfName.P);
        if (pageDict != null) {
            pageNumber = this.document.getPageNumber(pageDict);
        } else {
            for (int i = 1; i <= this.document.getNumberOfPages(); ++i) {
                PdfPage page = this.document.getPage(i);
                if (page.isFlushed() || !page.containsAnnotation((PdfAnnotation)widget)) continue;
                pageNumber = i;
                break;
            }
        }
        return pageNumber;
    }

    public static interface ISignatureEvent {
        public void getSignatureDictionary(PdfSignature var1);
    }

    public static enum CryptoStandard {
        CMS,
        CADES;

    }
}

