/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.io.util.TextUtil;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.kernel.numbering.EnglishAlphabetNumbering;
import com.itextpdf.kernel.numbering.GreekAlphabetNumbering;
import com.itextpdf.kernel.numbering.RomanNumbering;
import com.itextpdf.layout.element.Image;
import com.itextpdf.layout.element.List;
import com.itextpdf.layout.element.ListItem;
import com.itextpdf.layout.element.Text;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.property.ListNumberingType;
import com.itextpdf.layout.renderer.AbstractRenderer;
import com.itextpdf.layout.renderer.BlockRenderer;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.ImageRenderer;
import com.itextpdf.layout.renderer.ListItemRenderer;
import com.itextpdf.layout.renderer.TextRenderer;
import java.io.IOException;
import java.util.ArrayList;

public class ListRenderer
extends BlockRenderer {
    public ListRenderer(List modelElement) {
        super(modelElement);
    }

    @Override
    public LayoutResult layout(LayoutContext layoutContext) {
        if (!this.hasOwnProperty(40)) {
            ArrayList<Object> symbolRenderers = new ArrayList<Object>();
            int listItemNum = this.getProperty(36, 1);
            for (int i = 0; i < this.childRenderers.size(); ++i) {
                if (!(((IRenderer)this.childRenderers.get(i)).getModelElement() instanceof ListItem)) continue;
                ((IRenderer)this.childRenderers.get(i)).setParent(this);
                IRenderer currentSymbolRenderer = this.makeListSymbolRenderer(listItemNum++, (IRenderer)this.childRenderers.get(i));
                ((IRenderer)this.childRenderers.get(i)).setParent(null);
                symbolRenderers.add(currentSymbolRenderer);
                LayoutResult layoutResult = currentSymbolRenderer.setParent(this).layout(layoutContext);
                currentSymbolRenderer.setParent(null);
                if (layoutResult.getStatus() == 1) continue;
                return new LayoutResult(3, null, null, this, layoutResult.getCauseOfNothing());
            }
            float maxSymbolWidth = 0.0f;
            for (IRenderer iRenderer : symbolRenderers) {
                maxSymbolWidth = Math.max(maxSymbolWidth, iRenderer.getOccupiedArea().getBBox().getWidth());
            }
            Float symbolIndent = (Float)this.modelElement.getProperty(39);
            listItemNum = 0;
            for (IRenderer childRenderer : this.childRenderers) {
                childRenderer.deleteOwnProperty(44);
                childRenderer.setProperty(44, Float.valueOf(childRenderer.getProperty(44, Float.valueOf(0.0f)).floatValue() + maxSymbolWidth + (symbolIndent != null ? symbolIndent.floatValue() : 0.0f)));
                if (!(childRenderer.getModelElement() instanceof ListItem)) continue;
                IRenderer symbolRenderer = (IRenderer)symbolRenderers.get(listItemNum++);
                ((ListItemRenderer)childRenderer).addSymbolRenderer(symbolRenderer, maxSymbolWidth);
            }
        }
        LayoutResult result = super.layout(layoutContext);
        if (Boolean.TRUE.equals(this.getPropertyAsBoolean(26)) && null != result.getCauseOfNothing()) {
            if (1 == result.getStatus()) {
                result = this.correctListSplitting(this, null, result.getCauseOfNothing(), result.getOccupiedArea());
            } else if (2 == result.getStatus()) {
                result = this.correctListSplitting(result.getSplitRenderer(), result.getOverflowRenderer(), result.getCauseOfNothing(), result.getOccupiedArea());
            }
        }
        return result;
    }

    @Override
    public IRenderer getNextRenderer() {
        return new ListRenderer((List)this.modelElement);
    }

    @Override
    protected AbstractRenderer createSplitRenderer(int layoutResult) {
        AbstractRenderer splitRenderer = super.createSplitRenderer(layoutResult);
        splitRenderer.setProperty(40, Boolean.TRUE);
        return splitRenderer;
    }

    @Override
    protected AbstractRenderer createOverflowRenderer(int layoutResult) {
        AbstractRenderer overflowRenderer = super.createOverflowRenderer(layoutResult);
        overflowRenderer.setProperty(40, Boolean.TRUE);
        return overflowRenderer;
    }

    protected IRenderer makeListSymbolRenderer(int index, IRenderer renderer) {
        Object defaultListSymbol = renderer.getProperty(37);
        if (defaultListSymbol instanceof Text) {
            return new TextRenderer((Text)defaultListSymbol);
        }
        if (defaultListSymbol instanceof Image) {
            return new ImageRenderer((Image)defaultListSymbol);
        }
        if (defaultListSymbol instanceof ListNumberingType) {
            TextRenderer textRenderer;
            String numberText;
            ListNumberingType numberingType = (ListNumberingType)((Object)defaultListSymbol);
            switch (numberingType) {
                case DECIMAL: {
                    numberText = String.valueOf(index);
                    break;
                }
                case ROMAN_LOWER: {
                    numberText = RomanNumbering.toRomanLowerCase((int)index);
                    break;
                }
                case ROMAN_UPPER: {
                    numberText = RomanNumbering.toRomanUpperCase((int)index);
                    break;
                }
                case ENGLISH_LOWER: {
                    numberText = EnglishAlphabetNumbering.toLatinAlphabetNumberLowerCase((int)index);
                    break;
                }
                case ENGLISH_UPPER: {
                    numberText = EnglishAlphabetNumbering.toLatinAlphabetNumberUpperCase((int)index);
                    break;
                }
                case GREEK_LOWER: {
                    numberText = GreekAlphabetNumbering.toGreekAlphabetNumberLowerCase((int)index);
                    break;
                }
                case GREEK_UPPER: {
                    numberText = GreekAlphabetNumbering.toGreekAlphabetNumberUpperCase((int)index);
                    break;
                }
                case ZAPF_DINGBATS_1: {
                    numberText = TextUtil.charToString((char)((char)(index + 171)));
                    break;
                }
                case ZAPF_DINGBATS_2: {
                    numberText = TextUtil.charToString((char)((char)(index + 181)));
                    break;
                }
                case ZAPF_DINGBATS_3: {
                    numberText = TextUtil.charToString((char)((char)(index + 191)));
                    break;
                }
                case ZAPF_DINGBATS_4: {
                    numberText = TextUtil.charToString((char)((char)(index + 201)));
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            Text textElement = new Text((String)renderer.getProperty(41) + numberText + (String)renderer.getProperty(42));
            if (numberingType == ListNumberingType.GREEK_LOWER || numberingType == ListNumberingType.GREEK_UPPER || numberingType == ListNumberingType.ZAPF_DINGBATS_1 || numberingType == ListNumberingType.ZAPF_DINGBATS_2 || numberingType == ListNumberingType.ZAPF_DINGBATS_3 || numberingType == ListNumberingType.ZAPF_DINGBATS_4) {
                final String constantFont = numberingType == ListNumberingType.GREEK_LOWER || numberingType == ListNumberingType.GREEK_UPPER ? "Symbol" : "ZapfDingbats";
                textRenderer = new TextRenderer(textElement){

                    @Override
                    public void draw(DrawContext drawContext) {
                        try {
                            this.setProperty(20, PdfFontFactory.createFont((String)constantFont));
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        super.draw(drawContext);
                    }
                };
                try {
                    textRenderer.setProperty(20, PdfFontFactory.createFont((String)constantFont));
                }
                catch (IOException iOException) {}
            } else {
                textRenderer = new TextRenderer(textElement);
            }
            return textRenderer;
        }
        throw new IllegalStateException();
    }

    private LayoutResult correctListSplitting(IRenderer splitRenderer, IRenderer overflowRenderer, IRenderer causeOfNothing, LayoutArea occupiedArea) {
        int firstNotRendered = splitRenderer.getChildRenderers().get(0).getChildRenderers().indexOf(causeOfNothing);
        if (-1 == firstNotRendered) {
            return new LayoutResult(null == overflowRenderer ? 1 : 2, occupiedArea, splitRenderer, overflowRenderer, this);
        }
        IRenderer firstListItemRenderer = splitRenderer.getChildRenderers().get(0);
        ListRenderer newOverflowRenderer = (ListRenderer)this.createOverflowRenderer(2);
        newOverflowRenderer.deleteOwnProperty(26);
        newOverflowRenderer.childRenderers.add(new ListItemRenderer((ListItem)firstListItemRenderer.getModelElement()));
        newOverflowRenderer.childRenderers.addAll(splitRenderer.getChildRenderers().subList(1, splitRenderer.getChildRenderers().size()));
        ArrayList<IRenderer> childrenStillRemainingToRender = new ArrayList<IRenderer>(firstListItemRenderer.getChildRenderers().subList(firstNotRendered + 1, firstListItemRenderer.getChildRenderers().size()));
        splitRenderer.getChildRenderers().removeAll(splitRenderer.getChildRenderers().subList(1, splitRenderer.getChildRenderers().size()));
        if (0 != childrenStillRemainingToRender.size()) {
            newOverflowRenderer.getChildRenderers().get(0).getChildRenderers().addAll(childrenStillRemainingToRender);
            splitRenderer.getChildRenderers().get(0).getChildRenderers().removeAll(childrenStillRemainingToRender);
            newOverflowRenderer.getChildRenderers().get(0).setProperty(44, splitRenderer.getChildRenderers().get(0).getProperty(44));
        } else {
            newOverflowRenderer.childRenderers.remove(0);
        }
        if (null != overflowRenderer) {
            newOverflowRenderer.childRenderers.addAll(overflowRenderer.getChildRenderers());
        }
        if (0 != newOverflowRenderer.childRenderers.size()) {
            return new LayoutResult(2, occupiedArea, splitRenderer, newOverflowRenderer, this);
        }
        return new LayoutResult(1, occupiedArea, null, null, this);
    }
}

