/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.kernel.color.Color;
import com.itextpdf.kernel.color.DeviceRgb;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNull;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.tagging.PdfStructElem;
import com.itextpdf.kernel.pdf.tagutils.AccessibilityProperties;
import com.itextpdf.kernel.pdf.tagutils.IAccessibleElement;
import com.itextpdf.layout.border.Border;
import com.itextpdf.layout.element.Cell;
import com.itextpdf.layout.property.Background;
import com.itextpdf.layout.property.HorizontalAlignment;
import com.itextpdf.layout.property.ListNumberingType;
import com.itextpdf.layout.property.TextAlignment;
import com.itextpdf.layout.property.Underline;
import com.itextpdf.layout.property.UnitValue;
import com.itextpdf.layout.renderer.AbstractRenderer;
import java.util.List;

public class AccessibleAttributesApplier {
    public static void applyLayoutAttributes(PdfName role, AbstractRenderer renderer, PdfDocument doc) {
        if (!(renderer.getModelElement() instanceof IAccessibleElement)) {
            return;
        }
        int tagType = PdfStructElem.identifyType((PdfDocument)doc, (PdfName)role);
        PdfDictionary attributes = new PdfDictionary();
        PdfName attributesType = PdfName.Layout;
        attributes.put(PdfName.O, (PdfObject)attributesType);
        PdfDictionary roleMap = doc.getStructTreeRoot().getRoleMap();
        if (roleMap.containsKey(role)) {
            role = roleMap.getAsName(role);
        }
        AccessibleAttributesApplier.applyCommonLayoutAttributes(renderer, attributes);
        if (tagType == PdfStructElem.BlockLevel) {
            AccessibleAttributesApplier.applyBlockLevelLayoutAttributes(role, renderer, attributes, doc);
        }
        if (tagType == PdfStructElem.InlineLevel) {
            AccessibleAttributesApplier.applyInlineLevelLayoutAttributes(renderer, attributes);
        }
        if (tagType == PdfStructElem.Illustration) {
            AccessibleAttributesApplier.applyIllustrationLayoutAttributes(renderer, attributes);
        }
        if (attributes.size() > 1) {
            AccessibilityProperties properties = ((IAccessibleElement)renderer.getModelElement()).getAccessibilityProperties();
            AccessibleAttributesApplier.removeSameAttributesTypeIfPresent(properties, attributesType);
            properties.addAttributes(attributes);
        }
    }

    public static void applyListAttributes(AbstractRenderer renderer) {
        if (!(renderer.getModelElement() instanceof com.itextpdf.layout.element.List)) {
            return;
        }
        PdfDictionary attributes = new PdfDictionary();
        PdfName attributesType = PdfName.List;
        attributes.put(PdfName.O, (PdfObject)attributesType);
        Object listSymbol = renderer.getProperty(37);
        if (listSymbol instanceof ListNumberingType) {
            ListNumberingType numberingType = (ListNumberingType)((Object)listSymbol);
            attributes.put(PdfName.ListNumbering, (PdfObject)AccessibleAttributesApplier.transformNumberingTypeToName(numberingType));
        }
        if (attributes.size() > 1) {
            AccessibilityProperties properties = ((IAccessibleElement)renderer.getModelElement()).getAccessibilityProperties();
            AccessibleAttributesApplier.removeSameAttributesTypeIfPresent(properties, attributesType);
            properties.addAttributes(attributes);
        }
    }

    public static void applyTableAttributes(AbstractRenderer renderer) {
        if (!(renderer.getModelElement() instanceof IAccessibleElement)) {
            return;
        }
        IAccessibleElement accessibleElement = (IAccessibleElement)renderer.getModelElement();
        PdfDictionary attributes = new PdfDictionary();
        PdfName attributesType = PdfName.Table;
        attributes.put(PdfName.O, (PdfObject)attributesType);
        if (accessibleElement instanceof Cell) {
            Cell cell = (Cell)accessibleElement;
            if (cell.getRowspan() != 1) {
                attributes.put(PdfName.RowSpan, (PdfObject)new PdfNumber(cell.getRowspan()));
            }
            if (cell.getColspan() != 1) {
                attributes.put(PdfName.ColSpan, (PdfObject)new PdfNumber(cell.getColspan()));
            }
        }
        if (attributes.size() > 1) {
            AccessibilityProperties properties = accessibleElement.getAccessibilityProperties();
            AccessibleAttributesApplier.removeSameAttributesTypeIfPresent(properties, attributesType);
            properties.addAttributes(attributes);
        }
    }

    private static void applyCommonLayoutAttributes(AbstractRenderer renderer, PdfDictionary attributes) {
        Background background = (Background)renderer.getProperty(6);
        if (background != null && background.getColor() instanceof DeviceRgb) {
            attributes.put(PdfName.BackgroundColor, (PdfObject)new PdfArray(background.getColor().getColorValue()));
        }
        if (!(renderer.getModelElement() instanceof Cell)) {
            AccessibleAttributesApplier.applyBorderAttributes(renderer, attributes);
        }
        AccessibleAttributesApplier.applyPaddingAttribute(renderer, attributes);
        Color color = renderer.getPropertyAsColor(21);
        if (color != null && color instanceof DeviceRgb) {
            attributes.put(PdfName.Color, (PdfObject)new PdfArray(color.getColorValue()));
        }
    }

    private static void applyBlockLevelLayoutAttributes(PdfName role, AbstractRenderer renderer, PdfDictionary attributes, PdfDocument doc) {
        boolean connectedToTag;
        boolean elementIsOnSinglePage;
        TextAlignment textAlignment;
        Float firstLineIndent;
        Float endIndent;
        Float startIndent;
        Float spaceAfter;
        int[] marginsOrder;
        Float[] margins = new Float[]{renderer.getPropertyAsFloat(46), renderer.getPropertyAsFloat(43), renderer.getPropertyAsFloat(44), renderer.getPropertyAsFloat(45)};
        Float spaceBefore = margins[(marginsOrder = new int[]{0, 1, 2, 3})[0]];
        if (spaceBefore != null && spaceBefore.floatValue() != 0.0f) {
            attributes.put(PdfName.SpaceBefore, (PdfObject)new PdfNumber((double)spaceBefore.floatValue()));
        }
        if ((spaceAfter = margins[marginsOrder[1]]) != null && spaceAfter.floatValue() != 0.0f) {
            attributes.put(PdfName.SpaceAfter, (PdfObject)new PdfNumber((double)spaceAfter.floatValue()));
        }
        if ((startIndent = margins[marginsOrder[2]]) != null && startIndent.floatValue() != 0.0f) {
            attributes.put(PdfName.StartIndent, (PdfObject)new PdfNumber((double)startIndent.floatValue()));
        }
        if ((endIndent = margins[marginsOrder[3]]) != null && endIndent.floatValue() != 0.0f) {
            attributes.put(PdfName.EndIndent, (PdfObject)new PdfNumber((double)endIndent.floatValue()));
        }
        if ((firstLineIndent = (Float)renderer.getProperty(18)) != null && firstLineIndent.floatValue() != 0.0f) {
            attributes.put(PdfName.TextIndent, (PdfObject)new PdfNumber((double)firstLineIndent.floatValue()));
        }
        if ((textAlignment = (TextAlignment)((Object)renderer.getProperty(70))) != null && !role.equals((Object)PdfName.TH) && !role.equals((Object)PdfName.TD)) {
            attributes.put(PdfName.TextAlign, (PdfObject)AccessibleAttributesApplier.transformTextAlignmentValueToName(textAlignment));
        }
        boolean bl = elementIsOnSinglePage = !(connectedToTag = doc.getTagStructureContext().isElementConnectedToTag((IAccessibleElement)renderer.getModelElement())) && renderer.isLastRendererForModelElement;
        if (elementIsOnSinglePage) {
            Rectangle bbox = renderer.getOccupiedArea().getBBox();
            attributes.put(PdfName.BBox, (PdfObject)new PdfArray(bbox));
        }
        if (role.equals((Object)PdfName.TH) || role.equals((Object)PdfName.TD) || role.equals((Object)PdfName.Table)) {
            Float height;
            UnitValue width = (UnitValue)renderer.getProperty(77);
            if (width != null && width.isPointValue()) {
                attributes.put(PdfName.Width, (PdfObject)new PdfNumber((double)width.getValue()));
            }
            if ((height = renderer.getPropertyAsFloat(27)) != null) {
                attributes.put(PdfName.Height, (PdfObject)new PdfNumber((double)height.floatValue()));
            }
        }
        if (role.equals((Object)PdfName.TH) || role.equals((Object)PdfName.TD)) {
            HorizontalAlignment horizontalAlignment = (HorizontalAlignment)((Object)renderer.getProperty(28));
            if (horizontalAlignment != null) {
                attributes.put(PdfName.BlockAlign, (PdfObject)AccessibleAttributesApplier.transformBlockAlignToName(horizontalAlignment));
            }
            if (textAlignment != null && textAlignment != TextAlignment.JUSTIFIED && textAlignment != TextAlignment.JUSTIFIED_ALL) {
                attributes.put(PdfName.InlineAlign, (PdfObject)AccessibleAttributesApplier.transformTextAlignmentValueToName(textAlignment));
            }
        }
    }

    private static void applyInlineLevelLayoutAttributes(AbstractRenderer renderer, PdfDictionary attributes) {
        Object underlines;
        Float textRise = renderer.getPropertyAsFloat(72);
        if (textRise != null && textRise.floatValue() != 0.0f) {
            attributes.put(PdfName.BaselineShift, (PdfObject)new PdfNumber((double)textRise.floatValue()));
        }
        if ((underlines = renderer.getProperty(74)) != null) {
            Float fontSize = renderer.getPropertyAsFloat(24);
            Underline underline = null;
            if (underlines instanceof List && !((List)underlines).isEmpty() && ((List)underlines).get(0) instanceof Underline) {
                underline = (Underline)((List)underlines).get(0);
            } else if (underlines instanceof Underline) {
                underline = (Underline)underlines;
            }
            if (underline != null) {
                attributes.put(PdfName.TextDecorationType, (PdfObject)(underline.getYPosition(fontSize.floatValue()) > 0.0f ? PdfName.LineThrough : PdfName.Underline));
                if (underline.getColor() instanceof DeviceRgb) {
                    attributes.put(PdfName.TextDecorationColor, (PdfObject)new PdfArray(underline.getColor().getColorValue()));
                }
                attributes.put(PdfName.TextDecorationThickness, (PdfObject)new PdfNumber((double)underline.getThickness(fontSize.floatValue())));
            }
        }
    }

    private static void applyIllustrationLayoutAttributes(AbstractRenderer renderer, PdfDictionary attributes) {
        Rectangle bbox = renderer.getOccupiedArea().getBBox();
        attributes.put(PdfName.BBox, (PdfObject)new PdfArray(bbox));
        UnitValue width = (UnitValue)renderer.getProperty(77);
        if (width != null && width.isPointValue()) {
            attributes.put(PdfName.Width, (PdfObject)new PdfNumber((double)width.getValue()));
        } else {
            attributes.put(PdfName.Width, (PdfObject)new PdfNumber((double)bbox.getWidth()));
        }
        Float height = renderer.getPropertyAsFloat(27);
        if (height != null) {
            attributes.put(PdfName.Height, (PdfObject)new PdfNumber((double)height.floatValue()));
        } else {
            attributes.put(PdfName.Height, (PdfObject)new PdfNumber((double)bbox.getHeight()));
        }
    }

    private static void applyPaddingAttribute(AbstractRenderer renderer, PdfDictionary attributes) {
        float[] paddings = new float[]{renderer.getPropertyAsFloat(50).floatValue(), renderer.getPropertyAsFloat(49).floatValue(), renderer.getPropertyAsFloat(47).floatValue(), renderer.getPropertyAsFloat(48).floatValue()};
        PdfNumber padding = null;
        if (paddings[0] == paddings[1] && paddings[0] == paddings[2] && paddings[0] == paddings[3]) {
            if (paddings[0] != 0.0f) {
                padding = new PdfNumber((double)paddings[0]);
            }
        } else {
            int[] paddingsOrder;
            PdfArray paddingArray = new PdfArray();
            for (int i : paddingsOrder = new int[]{0, 1, 2, 3}) {
                paddingArray.add((PdfObject)new PdfNumber((double)paddings[i]));
            }
            padding = paddingArray;
        }
        if (padding != null) {
            attributes.put(PdfName.Padding, padding);
        }
    }

    private static void applyBorderAttributes(AbstractRenderer renderer, PdfDictionary attributes) {
        boolean generalBorderProperties;
        boolean specificBorderProperties = renderer.getProperty(13) != null || renderer.getProperty(12) != null || renderer.getProperty(10) != null || renderer.getProperty(11) != null;
        boolean bl = generalBorderProperties = !specificBorderProperties && renderer.getProperty(9) != null;
        if (generalBorderProperties) {
            Border generalBorder = (Border)renderer.getProperty(9);
            Color generalBorderColor = generalBorder.getColor();
            int borderType = generalBorder.getType();
            float borderWidth = generalBorder.getWidth();
            if (generalBorderColor instanceof DeviceRgb) {
                attributes.put(PdfName.BorderColor, (PdfObject)new PdfArray(generalBorderColor.getColorValue()));
                attributes.put(PdfName.BorderStyle, (PdfObject)AccessibleAttributesApplier.transformBorderTypeToName(borderType));
                attributes.put(PdfName.BorderThikness, (PdfObject)new PdfNumber((double)borderWidth));
            }
        }
        if (specificBorderProperties) {
            int[] borderOrder;
            PdfArray borderColors = new PdfArray();
            PdfArray borderTypes = new PdfArray();
            PdfArray borderWidths = new PdfArray();
            boolean atLeastOneRgb = false;
            Border[] borders = renderer.getBorders();
            boolean allColorsEqual = true;
            boolean allTypesEqual = true;
            boolean allWidthsEqual = true;
            for (int i = 1; i < borders.length; ++i) {
                Border border = borders[i];
                if (border == null) continue;
                if (!border.getColor().equals((Object)borders[0].getColor())) {
                    allColorsEqual = false;
                }
                if (border.getWidth() != borders[0].getWidth()) {
                    allWidthsEqual = false;
                }
                if (border.getType() == borders[0].getType()) continue;
                allTypesEqual = false;
            }
            for (int i : borderOrder = new int[]{0, 1, 2, 3}) {
                if (borders[i] != null) {
                    if (borders[i].getColor() instanceof DeviceRgb) {
                        borderColors.add((PdfObject)new PdfArray(borders[i].getColor().getColorValue()));
                        atLeastOneRgb = true;
                    } else {
                        borderColors.add((PdfObject)PdfNull.PDF_NULL);
                    }
                    borderTypes.add((PdfObject)AccessibleAttributesApplier.transformBorderTypeToName(borders[i].getType()));
                    borderWidths.add((PdfObject)new PdfNumber((double)borders[i].getWidth()));
                    continue;
                }
                borderColors.add((PdfObject)PdfNull.PDF_NULL);
                borderTypes.add((PdfObject)PdfName.None);
                borderWidths.add((PdfObject)PdfNull.PDF_NULL);
            }
            if (atLeastOneRgb) {
                if (allColorsEqual) {
                    attributes.put(PdfName.BorderColor, borderColors.get(0));
                } else {
                    attributes.put(PdfName.BorderColor, (PdfObject)borderColors);
                }
            }
            if (allTypesEqual) {
                attributes.put(PdfName.BorderStyle, borderTypes.get(0));
            } else {
                attributes.put(PdfName.BorderStyle, (PdfObject)borderTypes);
            }
            if (allWidthsEqual) {
                attributes.put(PdfName.BorderThikness, borderWidths.get(0));
            } else {
                attributes.put(PdfName.BorderThikness, (PdfObject)borderWidths);
            }
        }
    }

    private static PdfName transformTextAlignmentValueToName(TextAlignment textAlignment) {
        boolean isLeftToRight = true;
        switch (textAlignment) {
            case LEFT: {
                if (isLeftToRight) {
                    return PdfName.Start;
                }
                return PdfName.End;
            }
            case CENTER: {
                return PdfName.Center;
            }
            case RIGHT: {
                if (isLeftToRight) {
                    return PdfName.End;
                }
                return PdfName.Start;
            }
            case JUSTIFIED: 
            case JUSTIFIED_ALL: {
                return PdfName.Justify;
            }
        }
        return PdfName.Start;
    }

    private static PdfName transformBlockAlignToName(HorizontalAlignment horizontalAlignment) {
        boolean isLeftToRight = true;
        switch (horizontalAlignment) {
            case LEFT: {
                if (isLeftToRight) {
                    return PdfName.Before;
                }
                return PdfName.After;
            }
            case CENTER: {
                return PdfName.Middle;
            }
            case RIGHT: {
                if (isLeftToRight) {
                    return PdfName.After;
                }
                return PdfName.Before;
            }
        }
        return PdfName.Before;
    }

    private static PdfName transformBorderTypeToName(int borderType) {
        switch (borderType) {
            case 0: {
                return PdfName.Solid;
            }
            case 1: {
                return PdfName.Dashed;
            }
            case 2: {
                return PdfName.Dotted;
            }
            case 4: {
                return PdfName.Dotted;
            }
            case 3: {
                return PdfName.Double;
            }
            case 5: {
                return PdfName.Groove;
            }
            case 6: {
                return PdfName.Inset;
            }
            case 7: {
                return PdfName.Outset;
            }
            case 8: {
                return PdfName.Ridge;
            }
        }
        return PdfName.Solid;
    }

    private static PdfName transformNumberingTypeToName(ListNumberingType numberingType) {
        switch (numberingType) {
            case DECIMAL: {
                return PdfName.Decimal;
            }
            case ROMAN_UPPER: {
                return PdfName.UpperRoman;
            }
            case ROMAN_LOWER: {
                return PdfName.LowerRoman;
            }
            case ENGLISH_UPPER: 
            case GREEK_UPPER: {
                return PdfName.UpperAlpha;
            }
            case ENGLISH_LOWER: 
            case GREEK_LOWER: {
                return PdfName.LowerAlpha;
            }
        }
        return PdfName.None;
    }

    private static void removeSameAttributesTypeIfPresent(AccessibilityProperties properties, PdfName attributesType) {
        PdfDictionary attr;
        int i;
        List attributesList = properties.getAttributesList();
        for (i = 0; i < attributesList.size() && !attributesType.equals((Object)(attr = (PdfDictionary)attributesList.get(i)).get(PdfName.O)); ++i) {
        }
        if (i < attributesList.size()) {
            attributesList.remove(i);
        }
    }
}

