/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.element;

import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.tagutils.AccessibilityProperties;
import com.itextpdf.layout.element.BlockElement;
import com.itextpdf.layout.element.Image;
import com.itextpdf.layout.element.ListItem;
import com.itextpdf.layout.element.Text;
import com.itextpdf.layout.property.ListNumberingType;
import com.itextpdf.layout.property.ListSymbolAlignment;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.ListRenderer;

public class List
extends BlockElement<List> {
    public static final String DEFAULT_LIST_SYMBOL = "- ";
    protected PdfName role = PdfName.L;
    protected AccessibilityProperties tagProperties;

    public List() {
        this.setListSymbol(DEFAULT_LIST_SYMBOL);
    }

    public List(ListNumberingType listNumberingType) {
        this.setListSymbol(listNumberingType);
    }

    @Override
    public <T1> T1 getDefaultProperty(int property) {
        switch (property) {
            case 41: {
                return (T1)"";
            }
            case 42: {
                return (T1)". ";
            }
        }
        return super.getDefaultProperty(property);
    }

    public List add(ListItem listItem) {
        this.childElements.add(listItem);
        return this;
    }

    public List add(String text) {
        return this.add(new ListItem(text));
    }

    public List setItemStartIndex(int start) {
        this.setProperty(36, start);
        return this;
    }

    public List setListSymbol(String symbol) {
        return this.setListSymbol(new Text(symbol));
    }

    public List setListSymbol(Text text) {
        this.setProperty(37, text);
        return this;
    }

    public List setListSymbol(Image image) {
        this.setProperty(37, image);
        return this;
    }

    public List setListSymbol(ListNumberingType listNumberingType) {
        if (listNumberingType == ListNumberingType.ZAPF_DINGBATS_1 || listNumberingType == ListNumberingType.ZAPF_DINGBATS_2 || listNumberingType == ListNumberingType.ZAPF_DINGBATS_3 || listNumberingType == ListNumberingType.ZAPF_DINGBATS_4) {
            this.setPostSymbolText(" ");
        }
        this.setProperty(37, (Object)listNumberingType);
        return this;
    }

    public List setListSymbolAlignment(ListSymbolAlignment alignment) {
        this.setProperty(38, (Object)alignment);
        return this;
    }

    public Float getSymbolIndent() {
        return (Float)this.getProperty(39);
    }

    public List setSymbolIndent(float symbolIndent) {
        this.setProperty(39, Float.valueOf(symbolIndent));
        return this;
    }

    public String getPostSymbolText() {
        return (String)this.getProperty(42);
    }

    public void setPostSymbolText(String postSymbolText) {
        this.setProperty(42, postSymbolText);
    }

    public String getPreSymbolText() {
        return (String)this.getProperty(41);
    }

    public void setPreSymbolText(String preSymbolText) {
        this.setProperty(41, preSymbolText);
    }

    public PdfName getRole() {
        return this.role;
    }

    public void setRole(PdfName role) {
        this.role = role;
        if (PdfName.Artifact.equals((Object)role)) {
            this.propagateArtifactRoleToChildElements();
        }
    }

    public AccessibilityProperties getAccessibilityProperties() {
        if (this.tagProperties == null) {
            this.tagProperties = new AccessibilityProperties();
        }
        return this.tagProperties;
    }

    @Override
    protected IRenderer makeNewRenderer() {
        return new ListRenderer(this);
    }
}

