/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.source;

import com.itextpdf.io.source.ByteBufferRandomAccessSource;
import com.itextpdf.io.source.IRandomAccessSource;
import com.itextpdf.io.source.MapFailedException;
import java.io.IOException;
import java.nio.channels.FileChannel;

class MappedChannelRandomAccessSource
implements IRandomAccessSource {
    private final FileChannel channel;
    private final long offset;
    private final long length;
    private ByteBufferRandomAccessSource source;

    public MappedChannelRandomAccessSource(FileChannel channel, long offset, long length) {
        if (offset < 0L) {
            throw new IllegalArgumentException(offset + " is negative");
        }
        if (length <= 0L) {
            throw new IllegalArgumentException(length + " is zero or negative");
        }
        this.channel = channel;
        this.offset = offset;
        this.length = length;
        this.source = null;
    }

    void open() throws IOException {
        if (this.source != null) {
            return;
        }
        if (!this.channel.isOpen()) {
            throw new IllegalStateException("Channel is closed");
        }
        try {
            this.source = new ByteBufferRandomAccessSource(this.channel.map(FileChannel.MapMode.READ_ONLY, this.offset, this.length));
        }
        catch (IOException e) {
            if (MappedChannelRandomAccessSource.exceptionIsMapFailureException(e)) {
                throw new MapFailedException(e);
            }
            throw e;
        }
    }

    private static boolean exceptionIsMapFailureException(IOException e) {
        return e.getMessage() != null && e.getMessage().contains("Map failed");
    }

    @Override
    public int get(long position) throws IOException {
        if (this.source == null) {
            throw new IOException("RandomAccessSource not opened");
        }
        return this.source.get(position);
    }

    @Override
    public int get(long position, byte[] bytes, int off, int len) throws IOException {
        if (this.source == null) {
            throw new IOException("RandomAccessSource not opened");
        }
        return this.source.get(position, bytes, off, len);
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public void close() throws IOException {
        if (this.source == null) {
            return;
        }
        this.source.close();
        this.source = null;
    }

    public String toString() {
        return this.getClass().getName() + " (" + this.offset + ", " + this.length + ")";
    }
}

