/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ant;

import com.intellij.ant.AntClassWriter;
import com.intellij.compiler.notNullVerification.NotNullVerifyingInstrumenter;
import com.intellij.uiDesigner.compiler.AlienFormFileException;
import com.intellij.uiDesigner.compiler.AsmCodeGenerator;
import com.intellij.uiDesigner.compiler.FormErrorInfo;
import com.intellij.uiDesigner.compiler.NestedFormLoader;
import com.intellij.uiDesigner.compiler.Utils;
import com.intellij.uiDesigner.lw.CompiledClassPropertiesProvider;
import com.intellij.uiDesigner.lw.LwRootContainer;
import com.intellij.uiDesigner.lw.PropertiesProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.types.Path;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class Javac2
extends Javac {
    private ArrayList myFormFiles;

    protected void compile() {
        super.compile();
        ClassLoader loader = this.buildClasspathClassLoader();
        if (loader == null) {
            return;
        }
        this.instrumentForms(loader);
        if (this.isJdkVersion(5) || this.isJdkVersion(6)) {
            int instrumented = this.instrumentNotNull(this.getDestdir(), loader);
            this.log("Added @NotNull assertions to " + instrumented + " files", 2);
        } else {
            this.log("Skipped @NotNull instrumentation because target JDK is not 1.5 or 1.6", 2);
        }
    }

    private void instrumentForms(ClassLoader loader) {
        ArrayList formsToInstrument = this.myFormFiles;
        if (formsToInstrument.size() == 0) {
            this.log("No forms to instrument found", 3);
            return;
        }
        HashMap<String, File> class2form = new HashMap<String, File>();
        int i = 0;
        while (i < formsToInstrument.size()) {
            block18: {
                LwRootContainer rootContainer;
                String formFileContent;
                File formFile = (File)formsToInstrument.get(i);
                this.log("compiling form " + formFile.getAbsolutePath(), 3);
                byte[] bytes = new byte[(int)formFile.length()];
                try {
                    FileInputStream fileReader = new FileInputStream(formFile);
                    fileReader.read(bytes);
                    fileReader.close();
                }
                catch (IOException e) {
                    this.fireError(e.getMessage());
                    break block18;
                }
                try {
                    formFileContent = new String(bytes, "utf8");
                }
                catch (UnsupportedEncodingException e) {
                    this.fireError(e.getMessage());
                    break block18;
                }
                try {
                    rootContainer = Utils.getRootContainer(formFileContent, (PropertiesProvider)new CompiledClassPropertiesProvider(loader));
                }
                catch (AlienFormFileException e) {
                    break block18;
                }
                catch (Exception e) {
                    this.fireError("Cannot process form file " + formFile.getAbsolutePath() + ". Reason: " + e);
                    break block18;
                }
                String classToBind = rootContainer.getClassToBind();
                if (classToBind != null) {
                    String name = classToBind.replace('.', '/');
                    File classFile = this.getClassFile(name);
                    if (classFile == null) {
                        this.log(formFile.getAbsolutePath() + ": Class to bind does not exist: " + classToBind, 1);
                    } else {
                        File alreadyProcessedForm = (File)class2form.get(classToBind);
                        if (alreadyProcessedForm != null) {
                            this.fireError(formFile.getAbsolutePath() + ": " + "The form is bound to the class " + classToBind + ".\n" + "Another form " + alreadyProcessedForm.getAbsolutePath() + " is also bound to this class.");
                        } else {
                            class2form.put(classToBind, formFile);
                            AsmCodeGenerator codeGenerator = new AsmCodeGenerator(rootContainer, loader, new AntNestedFormLoader(loader), false, new AntClassWriter(this.getAsmClassWriterFlags(), loader));
                            codeGenerator.patchFile(classFile);
                            FormErrorInfo[] warnings = codeGenerator.getWarnings();
                            int j = 0;
                            while (j < warnings.length) {
                                this.log(formFile.getAbsolutePath() + ": " + warnings[j].getErrorMessage(), 1);
                                ++j;
                            }
                            FormErrorInfo[] errors = codeGenerator.getErrors();
                            if (errors.length > 0) {
                                StringBuffer message = new StringBuffer();
                                int j2 = 0;
                                while (j2 < errors.length) {
                                    if (message.length() > 0) {
                                        message.append("\n");
                                    }
                                    message.append(formFile.getAbsolutePath()).append(": ").append(errors[j2].getErrorMessage());
                                    ++j2;
                                }
                                this.fireError(message.toString());
                            }
                        }
                    }
                }
            }
            ++i;
        }
    }

    private int getAsmClassWriterFlags() {
        return this.isJdkVersion(6) ? 2 : 1;
    }

    private boolean isJdkVersion(int ver) {
        String versionString = Integer.toString(ver);
        String targetVersion = this.getTarget();
        if (targetVersion == null) {
            String[] strings = this.getCurrentCompilerArgs();
            int i = 0;
            while (i < strings.length) {
                this.log("currentCompilerArgs: " + strings[i], 3);
                if (strings[i].equals("-target") && i < strings.length - 1) {
                    targetVersion = strings[i + 1];
                    break;
                }
                ++i;
            }
        }
        if (targetVersion != null) {
            this.log("targetVersion: " + targetVersion, 3);
            return targetVersion.equals(versionString) || targetVersion.equals("1." + versionString);
        }
        return this.getCompilerVersion().equals("javac1." + versionString);
    }

    private ClassLoader buildClasspathClassLoader() {
        StringBuffer classPathBuffer = new StringBuffer();
        classPathBuffer.append(this.getDestdir().getAbsolutePath());
        Path classpath = this.getClasspath();
        if (classpath != null) {
            String[] pathElements = classpath.list();
            int i = 0;
            while (i < pathElements.length) {
                String pathElement = pathElements[i];
                classPathBuffer.append(File.pathSeparator);
                classPathBuffer.append(pathElement);
                ++i;
            }
        }
        classPathBuffer.append(File.pathSeparator);
        classPathBuffer.append(Javac2.getInternalClassPath());
        String classPath = classPathBuffer.toString();
        this.log("classpath=" + classPath, 2);
        try {
            return Javac2.createClassLoader(classPath);
        }
        catch (MalformedURLException e) {
            this.fireError(e.getMessage());
            return null;
        }
    }

    private int instrumentNotNull(File dir, ClassLoader loader) {
        int instrumented = 0;
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            String name = file.getName();
            if (name.endsWith(".class")) {
                String path = file.getPath();
                this.log("Adding @NotNull assertions to " + path, 3);
                try {
                    Object var17_16;
                    FileInputStream inputStream = new FileInputStream(file);
                    try {
                        ClassReader reader = new ClassReader((InputStream)inputStream);
                        AntClassWriter writer = new AntClassWriter(this.getAsmClassWriterFlags(), loader);
                        NotNullVerifyingInstrumenter instrumenter = new NotNullVerifyingInstrumenter((ClassVisitor)writer);
                        reader.accept((ClassVisitor)instrumenter, 0);
                        if (instrumenter.isModification()) {
                            Object var15_15;
                            FileOutputStream fileOutputStream = new FileOutputStream(path);
                            try {
                                fileOutputStream.write(writer.toByteArray());
                                ++instrumented;
                                var15_15 = null;
                            }
                            catch (Throwable throwable) {
                                var15_15 = null;
                                fileOutputStream.close();
                                throw throwable;
                            }
                            fileOutputStream.close();
                            {
                            }
                        }
                        var17_16 = null;
                    }
                    catch (Throwable throwable) {
                        var17_16 = null;
                        inputStream.close();
                        throw throwable;
                    }
                    inputStream.close();
                    {
                    }
                }
                catch (IOException e) {
                    this.log("Failed to instrument @NotNull assertion for " + path + ": " + e.getMessage(), 1);
                }
            } else if (file.isDirectory()) {
                instrumented += this.instrumentNotNull(file, loader);
            }
            ++i;
        }
        return instrumented;
    }

    private static String getInternalClassPath() {
        String class_path = System.getProperty("java.class.path");
        String boot_path = System.getProperty("sun.boot.class.path");
        String ext_path = System.getProperty("java.ext.dirs");
        ArrayList<String> list = new ArrayList<String>();
        Javac2.getPathComponents(class_path, list);
        Javac2.getPathComponents(boot_path, list);
        ArrayList dirs = new ArrayList();
        Javac2.getPathComponents(ext_path, dirs);
        Iterator e = dirs.iterator();
        while (e.hasNext()) {
            File ext_dir = new File((String)e.next());
            String[] extensions = ext_dir.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return (name = name.toLowerCase()).endsWith(".zip") || name.endsWith(".jar");
                }
            });
            if (extensions == null) continue;
            int i = 0;
            while (i < extensions.length) {
                list.add(ext_path + File.separatorChar + extensions[i]);
                ++i;
            }
        }
        StringBuffer buf = new StringBuffer();
        Iterator e2 = list.iterator();
        while (e2.hasNext()) {
            buf.append((String)e2.next());
            if (!e2.hasNext()) continue;
            buf.append(File.pathSeparatorChar);
        }
        return buf.toString().intern();
    }

    private static void getPathComponents(String path, ArrayList list) {
        if (path != null) {
            StringTokenizer tok = new StringTokenizer(path, File.pathSeparator);
            while (tok.hasMoreTokens()) {
                String name = tok.nextToken();
                File file = new File(name);
                if (!file.exists()) continue;
                list.add(name);
            }
        }
    }

    private void fireError(String message) {
        if (this.failOnError) {
            throw new BuildException(message, this.getLocation());
        }
        this.log(message, 0);
    }

    private File getClassFile(String className) {
        String classOrInnerName = this.getClassOrInnerName(className);
        if (classOrInnerName == null) {
            return null;
        }
        return new File(this.getDestdir().getAbsolutePath(), classOrInnerName + ".class");
    }

    private String getClassOrInnerName(String className) {
        File classFile = new File(this.getDestdir().getAbsolutePath(), className + ".class");
        if (classFile.exists()) {
            return className;
        }
        int position = className.lastIndexOf(47);
        if (position == -1) {
            return null;
        }
        return this.getClassOrInnerName(className.substring(0, position) + '$' + className.substring(position + 1));
    }

    private static URLClassLoader createClassLoader(String classPath) throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        StringTokenizer tokenizer = new StringTokenizer(classPath, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            String s = tokenizer.nextToken();
            urls.add(new File(s).toURL());
        }
        URL[] urlsArr = urls.toArray(new URL[urls.size()]);
        return new URLClassLoader(urlsArr, null);
    }

    protected void resetFileLists() {
        super.resetFileLists();
        this.myFormFiles = new ArrayList();
    }

    protected void scanDir(File srcDir, File destDir, String[] files) {
        super.scanDir(srcDir, destDir, files);
        int i = 0;
        while (i < files.length) {
            String file = files[i];
            if (file.endsWith(".form")) {
                this.log("Found form file " + file, 3);
                this.myFormFiles.add(new File(srcDir, file));
            }
            ++i;
        }
    }

    private class AntNestedFormLoader
    implements NestedFormLoader {
        private final ClassLoader myLoader;
        private final HashMap myFormCache = new HashMap();

        public AntNestedFormLoader(ClassLoader loader) {
            this.myLoader = loader;
        }

        public LwRootContainer loadForm(String formFileName) throws Exception {
            if (this.myFormCache.containsKey(formFileName)) {
                return (LwRootContainer)this.myFormCache.get(formFileName);
            }
            String formFileFullName = formFileName.toLowerCase();
            Javac2.this.log("Searching for form " + formFileFullName, 3);
            Iterator iterator = Javac2.this.myFormFiles.iterator();
            while (iterator.hasNext()) {
                File file = (File)iterator.next();
                String name = file.getAbsolutePath().replace(File.separatorChar, '/').toLowerCase();
                Javac2.this.log("Comparing with " + name, 3);
                if (!name.endsWith(formFileFullName)) continue;
                FileInputStream formInputStream = new FileInputStream(file);
                LwRootContainer container = Utils.getRootContainer(formInputStream, null);
                this.myFormCache.put(formFileName, container);
                return container;
            }
            InputStream resourceStream = this.myLoader.getResourceAsStream("/" + formFileName + ".form");
            if (resourceStream != null) {
                LwRootContainer container = Utils.getRootContainer(resourceStream, null);
                this.myFormCache.put(formFileName, container);
                return container;
            }
            throw new Exception("Cannot find nested form file " + formFileName);
        }

        public String getClassToBindName(LwRootContainer container) {
            String className = container.getClassToBind();
            String result = Javac2.this.getClassOrInnerName(className.replace('.', '/'));
            if (result != null) {
                return result.replace('/', '.');
            }
            return className;
        }
    }
}

