/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.sys;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.sys.CachingTDBMaker;
import com.hp.hpl.jena.tdb.sys.DatasetGraphMakerTDB;
import com.hp.hpl.jena.tdb.sys.DatasetGraphSetup;
import com.hp.hpl.jena.tdb.sys.DatasetGraphSetupMem;

public class TDBMaker {
    public static final DatasetGraphMakerTDB uncachedFactory = new DatasetGraphSetup();
    public static final DatasetGraphMakerTDB cachedFactory;
    private static final boolean CACHING = true;
    public static final DatasetGraphMakerTDB stdFactory;
    public static final DatasetGraphMakerTDB memFactory;
    private static DatasetGraphMakerTDB factory;

    public static void clearDatasetCache() {
        if (factory instanceof CachingTDBMaker) {
            ((CachingTDBMaker)factory).flush();
        }
    }

    public static synchronized void syncDatasetCache() {
        if (factory instanceof CachingTDBMaker) {
            ((CachingTDBMaker)factory).sync();
        }
    }

    public static void releaseDataset(DatasetGraphTDB dataset) {
        factory.releaseDatasetGraph(dataset);
    }

    public static Graph _createGraph() {
        return factory.createDatasetGraph().getDefaultGraph();
    }

    public static Graph _createGraph(Location loc) {
        return factory.createDatasetGraph(loc).getDefaultGraph();
    }

    public static DatasetGraphTDB _createDatasetGraph() {
        return factory.createDatasetGraph();
    }

    public static DatasetGraphTDB _createDatasetGraph(Location loc) {
        return factory.createDatasetGraph(loc);
    }

    public static void setImplFactory(DatasetGraphMakerTDB f) {
        factory = f;
    }

    public static DatasetGraphMakerTDB getImplFactory() {
        return factory;
    }

    static {
        stdFactory = cachedFactory = new CachingTDBMaker(uncachedFactory);
        memFactory = new DatasetGraphSetupMem();
        factory = stdFactory;
    }
}

