/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.schemaregistry.serde;

import com.hortonworks.registries.schemaregistry.SchemaIdVersion;
import com.hortonworks.registries.schemaregistry.SchemaMetadata;
import com.hortonworks.registries.schemaregistry.SchemaVersion;
import com.hortonworks.registries.schemaregistry.client.ISchemaRegistryClient;
import com.hortonworks.registries.schemaregistry.errors.IncompatibleSchemaException;
import com.hortonworks.registries.schemaregistry.errors.InvalidSchemaException;
import com.hortonworks.registries.schemaregistry.errors.SchemaBranchNotFoundException;
import com.hortonworks.registries.schemaregistry.errors.SchemaNotFoundException;
import com.hortonworks.registries.schemaregistry.exceptions.RegistryException;
import com.hortonworks.registries.schemaregistry.serde.AbstractSerDes;
import com.hortonworks.registries.schemaregistry.serde.SerDesException;
import com.hortonworks.registries.schemaregistry.serde.SnapshotSerializer;

public abstract class AbstractSnapshotSerializer<I, O>
extends AbstractSerDes
implements SnapshotSerializer<I, O, SchemaMetadata> {
    public AbstractSnapshotSerializer() {
    }

    public AbstractSnapshotSerializer(ISchemaRegistryClient schemaRegistryClient) {
        super(schemaRegistryClient);
    }

    public final O serialize(I input, SchemaMetadata schemaMetadata) throws SerDesException {
        this.ensureInitialized();
        String schema = this.getSchemaText(input);
        try {
            SchemaIdVersion schemaIdVersion = this.schemaRegistryClient.addSchemaVersion(schemaMetadata, new SchemaVersion(schema, "Schema registered by serializer:" + this.getClass()));
            return this.doSerialize(input, schemaIdVersion);
        }
        catch (IncompatibleSchemaException | InvalidSchemaException | SchemaBranchNotFoundException | SchemaNotFoundException e) {
            throw new RegistryException(e);
        }
    }

    protected abstract String getSchemaText(I var1);

    protected abstract O doSerialize(I var1, SchemaIdVersion var2) throws SerDesException;

    private void ensureInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("init should be invoked before invoking serialize operation");
        }
        if (this.closed) {
            throw new IllegalStateException("This serializer is already closed");
        }
    }
}

