<%--
  #%L
  SGQ :: Web
  $Id:$
  $HeadURL:$
  %%
  Copyright (C) 2012, 2014 Herboristerie Cailleau
  %%
  Herboristerie Cailleau - Tous droits réservés
  #L%
  --%>
<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<%@taglib uri="/struts-tags" prefix="s" %>
<%@taglib uri="http://www.opensymphony.com/sitemesh/decorator" prefix="decorator" %>
<%@taglib uri="http://shiro.apache.org/tags" prefix="shiro" %>
<html xmlns="http://www.w3.org/1999/xhtml">
    <head>
       <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
       <title>SGQ : <decorator:title default="Système de gestion de la qualit&eacute;"/></title>
       <link rel="stylesheet" type="text/css" href="<s:url value='/nuiton-js/sgq.css' />" />
       <link rel="stylesheet" type="text/css" href="<s:url value='/nuiton-js/sgq-print.css' />" media="print" />
       <script type="text/javascript" src="<s:url value='/nuiton-js/sgq.js' />"></script>
       <decorator:head/>
    </head>
    <body>
        <% if(com.herbocailleau.sgq.business.ServiceFactory.getConfig().isDevMode()) {%>
        <div class="banner">
          <a href="http://forge.codelutin.com/projects/sgq-ch">En développement</a>
        </div>
        <%}%>
        <div id="sgq-header">
            <div class="logo">
                <a href="<s:url action='index' namespace='/' />">
                    <img src="<s:url value='/img/logo.gif'/>" />
                 </a>
            </div>
            
            <span class="application">SGQ</span>
            
            <div class="infos">
	            <div class="userinfo">
                    <img class="print" src="<s:url value='/img/printer_off.png' />"
                        title="Imprimer" onclick="window.print();" /> -
                    <shiro:authenticated>
                      <shiro:principal /> -
	            	  <a href="<s:url action='logout' namespace='/security' />">D&eacute;connexion</a>
                    </shiro:authenticated>
                    <shiro:notAuthenticated>
                      <a href="<s:url action='login' namespace='/security' />">Connexion</a>
                    </shiro:notAuthenticated>
	            </div>
	            <div class="search">
	                <form action="<s:url action='search-result' namespace='/user' />" method="get">
	                    <input type="text" name="search.query" />
	                    <input type="submit" value="Rechercher" />
	                </form>
	            </div>
            </div>
        </div>

        <div id="sgq-body">
	        <div id="sgq-menu">
	           <ul>
                   <shiro:hasPermission name="search:read">
                   <li><a href="<s:url action='search-result' namespace='/user' />">Consultation des donn&eacute;es</a></li>
                   </shiro:hasPermission>
               </ul>
               <ul>
                   <shiro:hasPermission name="batch:receive:read">
	               <li><a href="<s:url action='batch-receive-view' namespace='/user' />">R&eacute;ception des lots</a></li>
                   </shiro:hasPermission>
                   <shiro:hasPermission name="analyze:prepare">
                   <li><a href="<s:url action='analyze-prepare' namespace='/user' />">Pr&eacute;paration d'analyses</a></li>
                   </shiro:hasPermission>
                   <shiro:hasPermission name="analyze:dashboard">
	               <li><a href="<s:url action='analyze-dashboard' namespace='/user' />">Gestion des analyses</a></li>
                   </shiro:hasPermission>
                   <shiro:hasPermission name="label:import">
	               <li><a href="<s:url action='label-import' namespace='/user' />">Gestion &eacute;tiquettes</a></li>
                   </shiro:hasPermission>
                   <shiro:hasPermission name="places:read">
	               <li><a href="<s:url action='place' namespace='/user' />">Lots par emplacement</a></li>
                   </shiro:hasPermission>
                   <shiro:hasPermission name="inventory:export">
	               <li><a href="<s:url action='inventory-view' namespace='/user' />">Inventaire</a></li>
                   </shiro:hasPermission>
               </ul>
               <ul>
	               <li class="sgq-submenu">R&eacute;f&eacute;rentiels&thinsp;:
	                   <ul>
                           <shiro:hasPermission name="product:read">
	                       <li><a href="<s:url action='product-list' namespace='/admin' />">Produits</a></li>
                           </shiro:hasPermission>
                           <shiro:hasPermission name="client:write">
	                       <li><a href="<s:url action='client-list' namespace='/admin' />">Clients d&eacute;di&eacute;s</a></li>
                           </shiro:hasPermission>
                           <shiro:hasPermission name="supplier:write">
	                       <li><a href="<s:url action='supplier-list' namespace='/admin' />">Fournisseurs</a></li>
                           </shiro:hasPermission>
                           <shiro:hasPermission name="place:write">
	                       <li><a href="<s:url action='place-list' namespace='/admin' />">Emplacements</a></li>
                           </shiro:hasPermission>
	                   </ul>
	               </li>
               </ul>

               <ul>
	               <li class="sgq-submenu">Administration&thinsp;:
	               		<ul>
                            <shiro:hasPermission name="analyze:type:list">
	               			<li><a href="<s:url action='analyze-type-list' namespace='/admin' />">Types d'analyses</a></li>
                            </shiro:hasPermission>
                            <shiro:hasPermission name="product:status:list">
                            <li><a href="<s:url action='product-status-list' namespace='/admin' />">Statuts des produits</a></li>
                            </shiro:hasPermission>
                            <shiro:hasPermission name="security:write">
	               			<li><a href="<s:url action='user-roles' namespace='/security' />">Gestion de la s&eacute;curit&eacute;</a></li>
                            </shiro:hasPermission>
                            <%--<shiro:hasPermission name="backup:write">
                            <li><a href="<s:url action='backup-run!input' namespace='/admin' />">Sauvegarde des données</a></li>
                            </shiro:hasPermission>--%>
	               		</ul>
	               </li>
	           </ul>
	        </div>

	        <div id="sgq-content">
	            <decorator:body/>
	        </div>
        </div>

        <div id="sgq-footer">
           <ul>
            <shiro:hasPermission name="misc:read:links">
              <li><a href="http://forge.codelutin.com/projects/sgq-ch">Cailleau - SGQ</a></li>
              <li><a href="http://forge.codelutin.com/projects/sgq-ch/roadmap?completed=1">
                <%-- on n'ai pas forcement dans une stack struts ici --%>
            	<%=com.herbocailleau.sgq.business.ServiceFactory.getConfig().getApplicationVersion()%>
           	  </a> -</li>
            </shiro:hasPermission>
            <li><a href="<%=com.herbocailleau.sgq.business.ServiceFactory.getConfig().getDocumentationUrl()%>">Documentation</a></li>
            <shiro:hasPermission name="misc:read:links">
              <li>- <a href="mailto:sgq-ch-devel@list.forge.codelutin.com">Contact</a></li>
            </shiro:hasPermission>
            <li>- Copyright 2012, 2014 <a href="http://www.herbo-cailleau.com/">Herboristerie Cailleau</a>,
            	Tous droits r&eacute;serv&eacute;s</li>
           </ul> 
        </div>
    </body>
</html>
