/*
 * #%L
 * SGQ :: Business
 * $Id: ProductPlaceDAOImpl.java 105 2012-09-28 14:22:53Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-1.1.3/sgq-business/src/main/java/com/herbocailleau/sgq/entities/ProductPlaceDAOImpl.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.entities;

import java.util.List;

import org.nuiton.topia.TopiaException;

public class ProductPlaceDAOImpl<E extends ProductPlace> extends ProductPlaceDAOAbstract<E> {

    /**
     * Delete all ProductPlace association class.
     * 
     * @throws TopiaException
     */
    public void deleteAll() throws TopiaException {
        String query = "delete from " + ProductPlace.class.getName();
        context.execute(query);
    }

    /**
     * Find unique product place for specified zone.
     * 
     * @param presentation presentation
     * @param zone zone
     * @return la liste des résultats (un part type de presentation)
     * @throws TopiaException 
     * @see PresentationCode pour les types de presentation
     */
    public List<ProductPlace> findByPresentationAndZone(Presentation presentation, Zone zone) throws TopiaException {
        String query = "from " + ProductPlace.class.getName() +
                " where product = :product" +
                " and place.zone = :zone";
        List<ProductPlace> productPlaces = context.findAll(query, "product",
                presentation.getBatch().getProduct(), "zone", zone);
        return productPlaces;
    }

} //ProductPlaceDAOImpl<E extends ProductPlace>
