/*
 * #%L
 * SGQ :: Business
 * $Id: PresentationModel.java 113 2012-10-02 14:38:07Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-1.1.1/sgq-business/src/main/java/com/herbocailleau/sgq/business/model/PresentationModel.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.business.model;

import java.util.ArrayList;
import java.util.List;

import com.herbocailleau.sgq.entities.Place;
import com.herbocailleau.sgq.entities.Presentation;

/**
 * Model de présentation ajoutant des informations supplémentaires par rapport
 * au informations du modèle (emplacements...)
 * 
 * @author echatellier
 */
public class PresentationModel {

    protected Presentation presentation;
    
    protected List<Place> places;

    public PresentationModel(Presentation presentation) {
        this.presentation = presentation;
        places = new ArrayList<Place>();
    }

    public Presentation getPresentation() {
        return presentation;
    }

    public List<Place> getPlaces() {
        return places;
    }

    public void addPlace(Place place) {
        places.add(place);
    }
}
