/*
 * #%L
 * SGQ :: Business
 * $Id: ProductionDAOImpl.java 113 2012-10-02 14:38:07Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.4/sgq-business/src/main/java/com/herbocailleau/sgq/entities/ProductionDAOImpl.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.entities;

import java.util.Date;
import java.util.List;

import org.nuiton.topia.TopiaException;

public class ProductionDAOImpl<E extends Production> extends ProductionDAOAbstract<E> {
    
    /**
     * Trouve parmis les production la date de la derniere production
     * effectuer par la zone source specifiée.
     * 
     * @param zone zone source
     * @return date or {@code null}
     * @throws TopiaException 
     */
    public Date findMaxDateForZone(Zone zone) throws TopiaException {
        String query = "select max(date) from " + Production.class.getName() +
                " where " + Production.PROPERTY_SOURCE + " = :zone";
        
        Date result = (Date)context.findUnique(query, "zone", zone);
        return result;
    }

    /**
     * Trouve une production effectuée pour une présentation VERS une zone.
     * Il peut y en avoir d'autre, mais retourne la première.
     * 
     * @param presentation presentation
     * @param zone zone
     * @return une expedition au hazard
     * @throws TopiaException 
     */
    public Production findSingleForPresentationAndZone(Presentation presentation, Zone zone) throws TopiaException {
        String query = "from " + Production.class.getName() +
                " where presentation = :presentation" +
                " and " + Production.PROPERTY_DESTINATION + " = :zone";

        // on ne peut pas utiliser findUnique qui lance une exception en cas
        // de resultat multiples, ce qui arrive inevitablement
        List<Production> results = context.find(query, 0, 1, "presentation", presentation,
                "zone", zone);
        Production result = null;
        if (!results.isEmpty()) {
            result = results.get(0);
        }
        return result;
    }

} //ProductionDAOImpl<E extends Production>
