/*
 * #%L
 * SGQ :: Business
 * $Id: SupplierImportModel.java 113 2012-10-02 14:38:07Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.4/sgq-business/src/main/java/com/herbocailleau/sgq/business/services/csv/SupplierImportModel.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.business.services.csv;

import java.text.ParseException;

import org.nuiton.util.csv.ValueParser;
import org.nuiton.util.csv.ext.AbstractImportModel;

import com.herbocailleau.sgq.entities.Supplier;
import com.herbocailleau.sgq.entities.SupplierImpl;

/**
 * Modèle d'import du fichier CSV des fournisseurs;
 * 
 * "Code fournisseur";"Nom fournisseur";"Prestataire"
 * 
 * @author echatellier
 */
public class SupplierImportModel extends AbstractImportModel<Supplier> {

    public SupplierImportModel() {
        super(';');
        newMandatoryColumn("Code fournisseur", Supplier.PROPERTY_CODE);
        newMandatoryColumn("Nom fournisseur", Supplier.PROPERTY_NAME, new ValueParser<String>() {
            @Override
            public String parse(String value) throws ParseException {
                return value.trim();
            }
        });
        newMandatoryColumn("Prestataire", Supplier.PROPERTY_LABORATORY, new ValueParser<Boolean>() {
            @Override
            public Boolean parse(String value) throws ParseException {
                Boolean result = Boolean.FALSE;
                if ("Laboratoire".equalsIgnoreCase(value)) {
                    result = Boolean.TRUE;
                }
                return result;
            }
        });
    }

    @Override
    public Supplier newEmptyInstance() {
        return new SupplierImpl();
    }
}
