/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.business.services.csv;

import com.herbocailleau.sgq.business.SgqBusinessException;
import com.herbocailleau.sgq.business.services.csv.PlaceBean;
import com.herbocailleau.sgq.entities.PresentationCode;
import com.herbocailleau.sgq.entities.Product;
import com.herbocailleau.sgq.entities.Zone;
import java.text.ParseException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.util.csv.ValueParser;
import org.nuiton.util.csv.ext.AbstractImportModel;

public class PlaceImportModel
extends AbstractImportModel<PlaceBean> {
    public PlaceImportModel(final Map<String, Product> products) {
        super(';');
        this.newMandatoryColumn("Zone", "zone", (ValueParser)new ValueParser<Zone>(){

            public Zone parse(String value) throws ParseException {
                return Zone.valueOf(value);
            }
        });
        this.newMandatoryColumn("Emplacement", "code");
        this.newMandatoryColumn("Localisation", "name");
        this.newMandatoryColumn("Code Pr\u00e9sentation", "presentationCode", (ValueParser)new ValueParser<PresentationCode>(){

            public PresentationCode parse(String value) throws ParseException {
                PresentationCode presentationCode = null;
                if (StringUtils.isNotBlank((CharSequence)value)) {
                    presentationCode = PresentationCode.getPresentationCodeFor(value.charAt(0));
                }
                return presentationCode;
            }
        });
        this.newMandatoryColumn("Code Produit", "product", (ValueParser)new ValueParser<Product>(){

            public Product parse(String value) throws ParseException {
                Product product = (Product)products.get(value);
                if (product == null) {
                    throw new SgqBusinessException("Can't find product " + value);
                }
                return product;
            }
        });
        this.newIgnoredColumn("Nom de la Plante");
        this.newIgnoredColumn("Nom du produit");
    }

    public PlaceBean newEmptyInstance() {
        return new PlaceBean();
    }
}

