/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.business.services.csv;

import com.herbocailleau.sgq.business.SgqBusinessException;
import com.herbocailleau.sgq.entities.Batch;
import com.herbocailleau.sgq.entities.BatchImpl;
import com.herbocailleau.sgq.entities.Client;
import com.herbocailleau.sgq.entities.Country;
import com.herbocailleau.sgq.entities.Product;
import com.herbocailleau.sgq.entities.Supplier;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.csv.ValueParser;
import org.nuiton.util.csv.ext.AbstractImportModel;

public class BatchImportModel
extends AbstractImportModel<Batch> {
    private static final Log log = LogFactory.getLog(BatchImportModel.class);

    public BatchImportModel(final Map<String, Supplier> suppliers, final Map<String, Client> clients, final Map<String, Product> products) {
        super(';');
        this.newMandatoryColumn("DATE_R", "entryDate", (ValueParser)new ValueParser<Date>(){
            protected DateFormat df = new SimpleDateFormat("dd/MM/yyyy");

            public Date parse(String value) throws ParseException {
                return this.df.parse(value);
            }
        });
        this.newMandatoryColumn("CODE_FOUR_R", "supplier", (ValueParser)new ValueParser<Supplier>(){

            public Supplier parse(String value) throws ParseException {
                Supplier supplier = (Supplier)suppliers.get(value);
                if (supplier == null) {
                    throw new SgqBusinessException(I18n._((String)"Impossible de trouver le fournisseur %s", (Object[])new Object[]{value}));
                }
                return supplier;
            }
        });
        this.newIgnoredColumn("FOUR_R");
        this.newMandatoryColumn("COMM_R", "orderNumber", (ValueParser)new ValueParser<Integer>(){

            public Integer parse(String value) throws ParseException {
                return Integer.valueOf(value);
            }
        });
        this.newMandatoryColumn("COLIS_R", "packageCount", (ValueParser)new ValueParser<Integer>(){

            public Integer parse(String value) throws ParseException {
                return Integer.valueOf(value);
            }
        });
        this.newMandatoryColumn("POIDS_R", "quantity", (ValueParser)new ValueParser<Double>(){

            public Double parse(String value) throws ParseException {
                return Double.valueOf(value.replace(',', '.').replaceAll("[^\\d.]", ""));
            }
        });
        this.newMandatoryColumn("PRO_R", "product", (ValueParser)new ValueParser<Product>(){

            public Product parse(String value) throws ParseException {
                Product product;
                if (value.startsWith(".")) {
                    value = StringUtils.removeStart((String)value, (String)".");
                }
                if ((product = (Product)products.get(value)) == null) {
                    throw new SgqBusinessException(I18n._((String)"Impossible de trouver le produit %s ", (Object[])new Object[]{value}));
                }
                return product;
            }
        });
        this.newIgnoredColumn("PAYS_R");
        this.newMandatoryColumn("CODE_PAYS_R", "origin", (ValueParser)new ValueParser<Country>(){

            public Country parse(String value) throws ParseException {
                return Country.valueOf(value);
            }
        });
        this.newMandatoryColumn("LOT_R", "number", (ValueParser)new ValueParser<Integer>(){

            public Integer parse(String value) throws ParseException {
                return Integer.valueOf(value);
            }
        });
        this.newMandatoryColumn("DLUO_R", "dluo", (ValueParser)new ValueParser<Date>(){
            protected DateFormat df = new SimpleDateFormat("dd/MM/yyyy");

            public Date parse(String value) throws ParseException {
                return this.df.parse(value);
            }
        });
        this.newIgnoredColumn("CLI_R");
        this.newMandatoryColumn("CODE_CLI_R", "dedicatedClient", (ValueParser)new ValueParser<Client>(){

            public Client parse(String value) throws ParseException {
                Client client = null;
                if (StringUtils.isNotBlank((CharSequence)value) && (client = (Client)clients.get(value)) == null) {
                    throw new SgqBusinessException(I18n._((String)"Impossible de trouver le client %s", (Object[])new Object[]{value}));
                }
                return client;
            }
        });
        this.newMandatoryColumn("ECH_R", "sampleCode");
        this.newMandatoryColumn("REM_R", "comment");
        this.newMandatoryColumn("IGNORER", "invalid", (ValueParser)new ValueParser<Boolean>(){

            public Boolean parse(String value) throws ParseException {
                if (StringUtils.isNotBlank((CharSequence)value)) {
                    throw new SgqBusinessException(I18n._((String)"Ligne ingor\u00e9e : %s", (Object[])new Object[]{value}));
                }
                return Boolean.FALSE;
            }
        });
    }

    public Batch newEmptyInstance() {
        return new BatchImpl();
    }
}

