/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.domain;

import com.helger.base.enforce.ValueEnforcer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@FunctionalInterface
public interface IHasLastModificationDateTime {
    public @Nullable LocalDateTime getLastModificationDateTime();

    default public boolean hasLastModificationDateTime() {
        return this.getLastModificationDateTime() != null;
    }

    default public @Nullable LocalDate getLastModificationDate() {
        LocalDateTime localDateTime = this.getLastModificationDateTime();
        return localDateTime == null ? null : localDateTime.toLocalDate();
    }

    default public @Nullable LocalTime getLastModificationTime() {
        LocalDateTime localDateTime = this.getLastModificationDateTime();
        return localDateTime == null ? null : localDateTime.toLocalTime();
    }

    default public boolean isLastModifiedAt(@NonNull LocalDateTime localDateTime) {
        ValueEnforcer.notNull((Object)localDateTime, (String)"LocalDateTime");
        return this.hasLastModificationDateTime() && this.getLastModificationDateTime().compareTo(localDateTime) <= 0;
    }
}

