/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.deadlock;

import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.array.ArrayHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import java.lang.management.ThreadInfo;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public class ThreadDeadlockInfo {
    private final ThreadInfo m_aThreadInfo;
    private final Thread m_aThread;
    private final StackTraceElement[] m_aStackTrace;

    public ThreadDeadlockInfo(@NonNull ThreadInfo threadInfo, @NonNull Thread thread, @Nullable StackTraceElement[] stackTraceElementArray) {
        this.m_aThreadInfo = (ThreadInfo)ValueEnforcer.notNull((Object)threadInfo, (String)"ThreadInfo");
        this.m_aThread = (Thread)ValueEnforcer.notNull((Object)thread, (String)"Thread");
        this.m_aStackTrace = (StackTraceElement[])ArrayHelper.getCopy((Object[])stackTraceElementArray);
    }

    public @NonNull ThreadInfo getThreadInfo() {
        return this.m_aThreadInfo;
    }

    public @NonNull Thread getThread() {
        return this.m_aThread;
    }

    public boolean hasStackTrace() {
        return this.m_aStackTrace != null;
    }

    @ReturnsMutableCopy
    public @Nullable StackTraceElement[] getAllStackTraceElements() {
        return (StackTraceElement[])ArrayHelper.getCopy((Object[])this.m_aStackTrace);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("threadInfo", (Object)this.m_aThreadInfo).append("thread", (Object)this.m_aThread).appendIfNotNull("stackTrace", (Object)this.m_aStackTrace).getToString();
    }
}

