/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.deadlock;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.array.ArrayHelper;
import com.helger.base.callback.CallbackList;
import com.helger.commons.deadlock.IThreadDeadlockCallback;
import com.helger.commons.deadlock.ThreadDeadlockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.Map;
import org.jspecify.annotations.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class ThreadDeadlockDetector {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadDeadlockDetector.class);
    private final ThreadMXBean m_aMBean = ManagementFactory.getThreadMXBean();
    private final CallbackList<IThreadDeadlockCallback> m_aCallbacks = new CallbackList();

    public void findDeadlockedThreads() {
        long[] lArray;
        long[] lArray2 = lArray = this.m_aMBean.isSynchronizerUsageSupported() ? this.m_aMBean.findDeadlockedThreads() : this.m_aMBean.findMonitorDeadlockedThreads();
        if (ArrayHelper.isNotEmpty((long[])lArray)) {
            Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
            Arrays.sort(lArray);
            ThreadDeadlockInfo[] threadDeadlockInfoArray = new ThreadDeadlockInfo[lArray.length];
            for (int i = 0; i < threadDeadlockInfoArray.length; ++i) {
                ThreadInfo threadInfo = this.m_aMBean.getThreadInfo(lArray[i]);
                Thread thread = null;
                StackTraceElement[] stackTraceElementArray = null;
                for (Map.Entry<Thread, StackTraceElement[]> entry : map.entrySet()) {
                    if (entry.getKey().getId() != threadInfo.getThreadId()) continue;
                    thread = entry.getKey();
                    stackTraceElementArray = entry.getValue();
                    break;
                }
                if (thread == null) {
                    throw new IllegalStateException("Deadlocked Thread not found as defined by " + threadInfo.toString());
                }
                threadDeadlockInfoArray[i] = new ThreadDeadlockInfo(threadInfo, thread, stackTraceElementArray);
            }
            if (this.m_aCallbacks.isEmpty()) {
                LOGGER.warn("Found a deadlock of " + threadDeadlockInfoArray.length + " threads but no callbacks are present!");
            } else {
                this.m_aCallbacks.forEach(iThreadDeadlockCallback -> iThreadDeadlockCallback.onDeadlockDetected(threadDeadlockInfoArray));
            }
        }
    }

    @ReturnsMutableObject
    public @NonNull CallbackList<IThreadDeadlockCallback> callbacks() {
        return this.m_aCallbacks;
    }
}

