/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.vector;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.MustImplementEqualsAndHashcode;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsVector;
import java.util.function.Supplier;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@ThreadSafe
public class SafeVector<ELEMENTTYPE>
extends CommonsVector<ELEMENTTYPE> {
    @MustImplementEqualsAndHashcode
    private final transient Supplier<? extends ELEMENTTYPE> m_aFactory;

    public SafeVector() {
        this(() -> null);
    }

    public SafeVector(@NonNull Supplier<? extends ELEMENTTYPE> supplier) {
        this.m_aFactory = (Supplier)ValueEnforcer.notNull(supplier, (String)"Factory");
    }

    public @NonNull Supplier<? extends ELEMENTTYPE> getFactory() {
        return this.m_aFactory;
    }

    private void _ensureSize(@Nonnegative int n) {
        int n2 = n - this.size() + 1;
        for (int i = 0; i < n2; ++i) {
            this.add(this.m_aFactory.get());
        }
    }

    @Override
    public synchronized ELEMENTTYPE get(@Nonnegative int n) {
        this._ensureSize(n);
        return (ELEMENTTYPE)super.get(n);
    }

    public synchronized @Nullable ELEMENTTYPE computeIfAbsent(@Nonnegative int n, @NonNull Supplier<? extends ELEMENTTYPE> supplier) {
        this._ensureSize(n);
        Object object = super.get(n);
        if (object == null) {
            object = supplier.get();
            super.set(n, object);
        }
        return (ELEMENTTYPE)object;
    }

    @Override
    public synchronized ELEMENTTYPE set(@Nonnegative int n, @NonNull ELEMENTTYPE ELEMENTTYPE) {
        this._ensureSize(n);
        return super.set(n, ELEMENTTYPE);
    }

    @Override
    public synchronized boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        SafeVector safeVector = (SafeVector)object;
        return this.m_aFactory.equals(safeVector.m_aFactory);
    }

    @Override
    public synchronized int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append(this.m_aFactory).getHashCode();
    }

    @Override
    public synchronized String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("factory", this.m_aFactory).getToString();
    }
}

