/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.enumeration;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import java.util.Enumeration;
import java.util.Iterator;
import org.jspecify.annotations.NonNull;

public final class EnumerationFromIterator<ELEMENTTYPE>
implements Enumeration<ELEMENTTYPE> {
    private final Iterator<? extends ELEMENTTYPE> m_aIter;

    public EnumerationFromIterator(@NonNull Iterable<? extends ELEMENTTYPE> iterable) {
        this(iterable.iterator());
    }

    public EnumerationFromIterator(@NonNull Iterator<? extends ELEMENTTYPE> iterator) {
        this.m_aIter = (Iterator)ValueEnforcer.notNull(iterator, (String)"Iterator");
    }

    @Override
    public boolean hasMoreElements() {
        return this.m_aIter.hasNext();
    }

    @Override
    public ELEMENTTYPE nextElement() {
        return this.m_aIter.next();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("iter", this.m_aIter).getToString();
    }

    public static <ELEMENTTYPE> @NonNull EnumerationFromIterator<ELEMENTTYPE> create(@NonNull Iterator<? extends ELEMENTTYPE> iterator) {
        return new EnumerationFromIterator<ELEMENTTYPE>(iterator);
    }

    public static <ELEMENTTYPE> @NonNull EnumerationFromIterator<ELEMENTTYPE> create(@NonNull Iterable<? extends ELEMENTTYPE> iterable) {
        return new EnumerationFromIterator<ELEMENTTYPE>(iterable);
    }
}

