/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.commons;

import com.helger.annotation.Nonnegative;
import com.helger.base.functional.IThrowingConsumer;
import com.helger.base.iface.IHasSize;
import com.helger.base.state.EContinue;
import com.helger.collection.CollectionFind;
import com.helger.collection.CollectionHelper;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ObjIntConsumer;
import java.util.function.Predicate;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface ICommonsIterable<ELEMENTTYPE>
extends Iterable<ELEMENTTYPE>,
IHasSize {
    default public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    default public void forEachByIndex(@NonNull ObjIntConsumer<? super ELEMENTTYPE> objIntConsumer) {
        int n = 0;
        for (Object t : this) {
            objIntConsumer.accept(t, n);
            ++n;
        }
    }

    default public @NonNull EContinue forEachBreakable(@NonNull Function<? super ELEMENTTYPE, EContinue> function) {
        Objects.requireNonNull(function);
        for (Object t : this) {
            if (!function.apply(t).isBreak()) continue;
            return EContinue.BREAK;
        }
        return EContinue.CONTINUE;
    }

    default public <EXTYPE extends Throwable> void forEachThrowing(@NonNull IThrowingConsumer<? super ELEMENTTYPE, EXTYPE> iThrowingConsumer) throws EXTYPE {
        for (Object t : this) {
            iThrowingConsumer.accept(t);
        }
    }

    default public void findAll(@Nullable Predicate<? super ELEMENTTYPE> predicate, @NonNull Consumer<? super ELEMENTTYPE> consumer) {
        CollectionFind.findAll(this, predicate, consumer);
    }

    default public <DSTTYPE> void findAllMapped(@NonNull Function<? super ELEMENTTYPE, DSTTYPE> function, @NonNull Consumer<? super DSTTYPE> consumer) {
        CollectionFind.findAllMapped(this, function, consumer);
    }

    default public <DSTTYPE> void findAllMapped(@Nullable Predicate<? super ELEMENTTYPE> predicate, @NonNull Function<? super ELEMENTTYPE, DSTTYPE> function, @NonNull Consumer<? super DSTTYPE> consumer) {
        CollectionFind.findAllMapped(this, predicate, function, consumer);
    }

    default public <DSTTYPE> void findAllMapped(@NonNull Function<? super ELEMENTTYPE, DSTTYPE> function, @Nullable Predicate<? super DSTTYPE> predicate, @NonNull Consumer<? super DSTTYPE> consumer) {
        CollectionFind.findAllMapped(this, function, predicate, consumer);
    }

    default public <DSTTYPE extends ELEMENTTYPE> void findAllInstanceOf(@NonNull Class<DSTTYPE> clazz, @NonNull Consumer<? super DSTTYPE> consumer) {
        this.findAllMapped(clazz::isInstance, clazz::cast, consumer);
    }

    default public @Nullable ELEMENTTYPE findFirst(@Nullable Predicate<? super ELEMENTTYPE> predicate) {
        return this.findFirst(predicate, null);
    }

    default public @Nullable ELEMENTTYPE findFirst(@Nullable Predicate<? super ELEMENTTYPE> predicate, @Nullable ELEMENTTYPE ELEMENTTYPE) {
        return CollectionFind.findFirst(this, predicate, ELEMENTTYPE);
    }

    default public <DSTTYPE> @Nullable DSTTYPE findFirstMapped(@Nullable Predicate<? super ELEMENTTYPE> predicate, @NonNull Function<? super ELEMENTTYPE, DSTTYPE> function) {
        return this.findFirstMapped(predicate, function, null);
    }

    default public <DSTTYPE> @Nullable DSTTYPE findFirstMapped(@Nullable Predicate<? super ELEMENTTYPE> predicate, @NonNull Function<? super ELEMENTTYPE, DSTTYPE> function, @Nullable DSTTYPE DSTTYPE) {
        return CollectionFind.findFirstMapped(this, predicate, function, DSTTYPE);
    }

    default public boolean containsAny(@Nullable Predicate<? super ELEMENTTYPE> predicate) {
        return CollectionFind.containsAny(this, predicate);
    }

    default public boolean containsNone(@Nullable Predicate<? super ELEMENTTYPE> predicate) {
        return CollectionFind.containsNone(this, predicate);
    }

    default public boolean containsOnly(@NonNull Predicate<? super ELEMENTTYPE> predicate) {
        return CollectionFind.containsOnly(this, predicate);
    }

    @Nonnegative
    default public int size() {
        return CollectionHelper.getSizeIterator(this.iterator());
    }

    @Nonnegative
    default public int getCount(@Nullable Predicate<? super ELEMENTTYPE> predicate) {
        if (predicate == null) {
            return this.size();
        }
        int n = 0;
        for (Object t : this) {
            if (!predicate.test(t)) continue;
            ++n;
        }
        return n;
    }

    @Nonnegative
    default public int findFirstIndex(@NonNull Predicate<? super ELEMENTTYPE> predicate) {
        int n = 0;
        for (Object t : this) {
            if (predicate.test(t)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Nonnegative
    default public int findLastIndex(@NonNull Predicate<? super ELEMENTTYPE> predicate) {
        int n = -1;
        int n2 = 0;
        for (Object t : this) {
            if (predicate.test(t)) {
                n = n2;
            }
            ++n2;
        }
        return n;
    }
}

