/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.io.stream;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.WillClose;
import com.helger.annotation.WillNotClose;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.builder.IBuilder;
import com.helger.base.callback.exception.IExceptionCallback;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.iface.IHasInputStream;
import com.helger.base.io.nonblocking.NonBlockingBufferedInputStream;
import com.helger.base.io.nonblocking.NonBlockingBufferedOutputStream;
import com.helger.base.io.nonblocking.NonBlockingBufferedReader;
import com.helger.base.io.nonblocking.NonBlockingBufferedWriter;
import com.helger.base.io.nonblocking.NonBlockingByteArrayInputStream;
import com.helger.base.io.nonblocking.NonBlockingByteArrayOutputStream;
import com.helger.base.io.nonblocking.NonBlockingStringReader;
import com.helger.base.io.nonblocking.NonBlockingStringWriter;
import com.helger.base.io.stream.ByteBufferInputStream;
import com.helger.base.io.stream.ByteBufferOutputStream;
import com.helger.base.io.stream.WrappedInputStream;
import com.helger.base.io.stream.WrappedOutputStream;
import com.helger.base.io.stream.WrappedReader;
import com.helger.base.io.stream.WrappedWriter;
import com.helger.base.mock.exception.IMockException;
import com.helger.base.numeric.mutable.MutableLong;
import com.helger.base.state.ESuccess;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.LongConsumer;
import java.util.function.ObjIntConsumer;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class StreamHelper {
    public static final int DEFAULT_BUFSIZE = 16384;
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamHelper.class);
    private static final StreamHelper INSTANCE = new StreamHelper();
    public static final int END_OF_STRING_MARKER = -131075;

    protected StreamHelper() {
    }

    @ReturnsMutableCopy
    public static byte @NonNull [] createDefaultCopyBufferBytes() {
        return new byte[16384];
    }

    @ReturnsMutableCopy
    public static char @NonNull [] createDefaultCopyBufferChars() {
        return new char[16384];
    }

    public static @NonNull NonBlockingStringReader createReader(@NonNull String string) {
        return new NonBlockingStringReader(string);
    }

    public static @NonNull NonBlockingStringReader createReader(char @NonNull [] cArray) {
        return new NonBlockingStringReader(cArray);
    }

    public static @Nullable InputStreamReader createReader(@Nullable InputStream inputStream, @NonNull Charset charset) {
        ValueEnforcer.notNull(charset, "Charset");
        return inputStream == null ? null : new InputStreamReader(inputStream, charset);
    }

    public static @Nullable OutputStreamWriter createWriter(@Nullable OutputStream outputStream, @NonNull Charset charset) {
        ValueEnforcer.notNull(charset, "Charset");
        return outputStream == null ? null : new OutputStreamWriter(outputStream, charset);
    }

    public static boolean isKnownEOFException(@Nullable Throwable throwable) {
        return throwable != null && StreamHelper.isKnownEOFException(throwable.getClass());
    }

    public static boolean isKnownEOFException(@Nullable Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        String string = clazz.getName();
        return string.equals("java.io.EOFException") || string.equals("org.mortbay.jetty.EofException") || string.equals("org.eclipse.jetty.io.EofException") || string.equals("org.apache.catalina.connector.ClientAbortException");
    }

    protected static @Nullable Exception internalGetPropagatableException(@NonNull Exception exception) {
        return exception instanceof IMockException ? null : exception;
    }

    public static @NonNull ESuccess closeWithoutFlush(@WillClose @Nullable AutoCloseable autoCloseable) {
        block3: {
            if (autoCloseable != null) {
                try {
                    autoCloseable.close();
                    return ESuccess.SUCCESS;
                }
                catch (Exception exception) {
                    if (StreamHelper.isKnownEOFException(exception)) break block3;
                    LOGGER.error("Failed to close object " + autoCloseable.getClass().getName(), (Throwable)StreamHelper.internalGetPropagatableException(exception));
                }
            }
        }
        return ESuccess.FAILURE;
    }

    public static @NonNull ESuccess close(@WillClose @Nullable AutoCloseable autoCloseable) {
        block5: {
            if (autoCloseable != null) {
                try {
                    if (autoCloseable instanceof Flushable) {
                        Flushable flushable = (Flushable)((Object)autoCloseable);
                        StreamHelper.flush(flushable);
                    }
                    autoCloseable.close();
                    return ESuccess.SUCCESS;
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (Exception exception) {
                    if (StreamHelper.isKnownEOFException(exception)) break block5;
                    LOGGER.error("Failed to close object " + autoCloseable.getClass().getName(), (Throwable)StreamHelper.internalGetPropagatableException(exception));
                }
            }
        }
        return ESuccess.FAILURE;
    }

    public static @NonNull ESuccess flush(@Nullable Flushable flushable) {
        block4: {
            if (flushable != null) {
                try {
                    flushable.flush();
                    return ESuccess.SUCCESS;
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (IOException iOException) {
                    if (StreamHelper.isKnownEOFException(iOException)) break block4;
                    LOGGER.error("Failed to flush object " + flushable.getClass().getName(), (Throwable)StreamHelper.internalGetPropagatableException(iOException));
                }
            }
        }
        return ESuccess.FAILURE;
    }

    public static boolean isBuffered(@Nullable InputStream inputStream) {
        WrappedInputStream wrappedInputStream;
        return inputStream instanceof BufferedInputStream || inputStream instanceof NonBlockingBufferedInputStream || inputStream instanceof ByteArrayInputStream || inputStream instanceof NonBlockingByteArrayInputStream || inputStream instanceof ByteBufferInputStream || inputStream instanceof WrappedInputStream && StreamHelper.isBuffered((wrappedInputStream = (WrappedInputStream)inputStream).getWrappedInputStream());
    }

    public static @Nullable InputStream getBuffered(@Nullable InputStream inputStream) {
        return inputStream == null || StreamHelper.isBuffered(inputStream) ? inputStream : new NonBlockingBufferedInputStream(inputStream);
    }

    public static boolean isBuffered(@Nullable OutputStream outputStream) {
        WrappedOutputStream wrappedOutputStream;
        return outputStream instanceof BufferedOutputStream || outputStream instanceof NonBlockingBufferedOutputStream || outputStream instanceof ByteArrayOutputStream || outputStream instanceof NonBlockingByteArrayOutputStream || outputStream instanceof ByteBufferOutputStream || outputStream instanceof WrappedOutputStream && StreamHelper.isBuffered((wrappedOutputStream = (WrappedOutputStream)outputStream).getWrappedOutputStream());
    }

    public static @Nullable OutputStream getBuffered(@Nullable OutputStream outputStream) {
        return outputStream == null || StreamHelper.isBuffered(outputStream) ? outputStream : new NonBlockingBufferedOutputStream(outputStream);
    }

    public static boolean isBuffered(@Nullable Reader reader) {
        WrappedReader wrappedReader;
        return reader instanceof BufferedReader || reader instanceof NonBlockingBufferedReader || reader instanceof StringReader || reader instanceof NonBlockingStringReader || reader instanceof WrappedReader && StreamHelper.isBuffered((wrappedReader = (WrappedReader)reader).getWrappedReader());
    }

    public static @Nullable Reader getBuffered(@Nullable Reader reader) {
        return reader == null || StreamHelper.isBuffered(reader) ? reader : new NonBlockingBufferedReader(reader);
    }

    public static boolean isBuffered(@Nullable Writer writer) {
        WrappedWriter wrappedWriter;
        return writer instanceof BufferedWriter || writer instanceof NonBlockingBufferedWriter || writer instanceof StringWriter || writer instanceof NonBlockingStringWriter || writer instanceof WrappedWriter && StreamHelper.isBuffered((wrappedWriter = (WrappedWriter)writer).getWrappedWriter());
    }

    public static @Nullable Writer getBuffered(@Nullable Writer writer) {
        return writer == null || StreamHelper.isBuffered(writer) ? writer : new NonBlockingBufferedWriter(writer);
    }

    public static @NonNull ESuccess copyInputStreamToOutputStream(@WillClose @Nullable InputStream inputStream, @WillNotClose @Nullable OutputStream outputStream) {
        return StreamHelper.copyByteStream().from(inputStream).closeFrom(true).to(outputStream).closeTo(false).build();
    }

    public static @NonNull ESuccess copyInputStreamToOutputStreamAndCloseOS(@WillClose @Nullable InputStream inputStream, @WillClose @Nullable OutputStream outputStream) {
        return StreamHelper.copyByteStream().from(inputStream).closeFrom(true).to(outputStream).closeTo(true).build();
    }

    public static @NonNull CopyByteStreamBuilder copyByteStream() {
        return new CopyByteStreamBuilder();
    }

    public static int getAvailable(@Nullable InputStream inputStream) {
        if (inputStream != null) {
            try {
                return inputStream.available();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return 0;
    }

    public static @Nullable NonBlockingByteArrayOutputStream getCopy(@WillClose @NonNull InputStream inputStream) {
        int n = Math.max(16384, StreamHelper.getAvailable(inputStream));
        NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream(n);
        if (StreamHelper.copyByteStream().from(inputStream).closeFrom(true).to(nonBlockingByteArrayOutputStream).closeTo(false).build().isFailure()) {
            return null;
        }
        return nonBlockingByteArrayOutputStream;
    }

    public static @Nullable NonBlockingByteArrayOutputStream getCopyWithLimit(@WillClose @NonNull InputStream inputStream, @Nonnegative long l) {
        int n = Math.max(16384, StreamHelper.getAvailable(inputStream));
        NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream(n);
        if (StreamHelper.copyByteStream().from(inputStream).closeFrom(true).to(nonBlockingByteArrayOutputStream).closeTo(false).limit(l).build().isFailure()) {
            return null;
        }
        return nonBlockingByteArrayOutputStream;
    }

    public static byte @Nullable [] getAllBytes(@Nullable IHasInputStream iHasInputStream) {
        if (iHasInputStream == null) {
            return null;
        }
        return StreamHelper.getAllBytes(iHasInputStream.getInputStream());
    }

    public static byte @Nullable [] getAllBytes(@WillClose @Nullable InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        try (NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = StreamHelper.getCopy(inputStream);){
            if (nonBlockingByteArrayOutputStream == null) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = nonBlockingByteArrayOutputStream.getBufferOrCopy();
            return byArray;
        }
    }

    public static @Nullable String getAllBytesAsString(@Nullable IHasInputStream iHasInputStream, @NonNull @Nonempty Charset charset) {
        if (iHasInputStream == null) {
            return null;
        }
        return StreamHelper.getAllBytesAsString(iHasInputStream.getInputStream(), charset);
    }

    public static @Nullable String getAllBytesAsString(@WillClose @Nullable InputStream inputStream, @NonNull @Nonempty Charset charset) {
        ValueEnforcer.notNull(charset, "Charset");
        if (inputStream == null) {
            return null;
        }
        try (NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = StreamHelper.getCopy(inputStream);){
            if (nonBlockingByteArrayOutputStream == null) {
                String string = null;
                return string;
            }
            String string = nonBlockingByteArrayOutputStream.getAsString(charset);
            return string;
        }
    }

    public static @NonNull ESuccess copyReaderToWriter(@WillClose @Nullable Reader reader, @WillNotClose @Nullable Writer writer) {
        return StreamHelper.copyCharStream().from(reader).closeFrom(true).to(writer).closeTo(false).build();
    }

    public static @NonNull ESuccess copyReaderToWriterAndCloseWriter(@WillClose @Nullable Reader reader, @WillClose @Nullable Writer writer) {
        return StreamHelper.copyCharStream().from(reader).closeFrom(true).to(writer).closeTo(true).build();
    }

    public static @NonNull CopyCharStreamBuilder copyCharStream() {
        return new CopyCharStreamBuilder();
    }

    public static @Nullable NonBlockingStringWriter getCopy(@WillClose @NonNull Reader reader) {
        NonBlockingStringWriter nonBlockingStringWriter = new NonBlockingStringWriter(16384);
        if (StreamHelper.copyCharStream().from(reader).closeFrom(true).to(nonBlockingStringWriter).closeTo(false).build().isFailure()) {
            return null;
        }
        return nonBlockingStringWriter;
    }

    public static @Nullable NonBlockingStringWriter getCopyWithLimit(@WillClose @NonNull Reader reader, @Nonnegative long l) {
        NonBlockingStringWriter nonBlockingStringWriter = new NonBlockingStringWriter(16384);
        if (StreamHelper.copyCharStream().from(reader).closeFrom(true).to(nonBlockingStringWriter).closeTo(false).limit(l).build().isFailure()) {
            return null;
        }
        return nonBlockingStringWriter;
    }

    public static char @Nullable [] getAllCharacters(@WillClose @Nullable Reader reader) {
        if (reader == null) {
            return null;
        }
        try (NonBlockingStringWriter nonBlockingStringWriter = StreamHelper.getCopy(reader);){
            if (nonBlockingStringWriter == null) {
                char[] cArray = null;
                return cArray;
            }
            char[] cArray = nonBlockingStringWriter.getAsCharArray();
            return cArray;
        }
    }

    public static @Nullable String getAllCharactersAsString(@WillClose @Nullable Reader reader) {
        if (reader == null) {
            return null;
        }
        try (NonBlockingStringWriter nonBlockingStringWriter = StreamHelper.getCopy(reader);){
            if (nonBlockingStringWriter == null) {
                String string = null;
                return string;
            }
            String string = nonBlockingStringWriter.getAsString();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @NonNull ESuccess writeStream(@WillClose @NonNull OutputStream outputStream, byte @NonNull [] byArray, @Nonnegative int n, @Nonnegative int n2) {
        try {
            ValueEnforcer.notNull(outputStream, "OutputStream");
            ValueEnforcer.isArrayOfsLen(byArray, n, n2);
            outputStream.write(byArray, n, n2);
            outputStream.flush();
            ESuccess eSuccess = ESuccess.SUCCESS;
            return eSuccess;
        }
        catch (IOException iOException) {
            LOGGER.error("Failed to write to output stream", (Throwable)StreamHelper.internalGetPropagatableException(iOException));
            ESuccess eSuccess = ESuccess.FAILURE;
            return eSuccess;
        }
        finally {
            StreamHelper.close(outputStream);
        }
    }

    public static @NonNull ESuccess writeStream(@WillClose @NonNull OutputStream outputStream, byte @NonNull [] byArray) {
        return StreamHelper.writeStream(outputStream, byArray, 0, byArray.length);
    }

    public static @NonNull ESuccess writeStream(@WillClose @NonNull OutputStream outputStream, @NonNull String string, @NonNull Charset charset) {
        ValueEnforcer.notNull(string, "Content");
        ValueEnforcer.notNull(charset, "Charset");
        return StreamHelper.writeStream(outputStream, string.getBytes(charset));
    }

    public static void skipFully(@NonNull InputStream inputStream, @Nonnegative long l) throws IOException {
        ValueEnforcer.notNull(inputStream, "InputStream");
        ValueEnforcer.isGE0(l, "BytesToSkip");
        long l2 = l;
        while (l2 > 0L) {
            long l3 = inputStream.skip(l2);
            if (l3 == 0L) {
                if (inputStream.read() == -1) {
                    throw new EOFException("Failed to skip a total of " + l + " bytes on input stream. Only skipped " + (l - l2) + " bytes so far!");
                }
                --l2;
                continue;
            }
            l2 -= l3;
        }
    }

    @Nonnegative
    public static int readFully(@NonNull InputStream inputStream, byte @NonNull [] byArray) throws IOException {
        return StreamHelper.readFully(inputStream, byArray, 0, byArray.length);
    }

    @Nonnegative
    public static int readFully(@WillNotClose @NonNull InputStream inputStream, byte @NonNull [] byArray, @Nonnegative int n, @Nonnegative int n2) throws IOException {
        int n3;
        int n4;
        ValueEnforcer.notNull(inputStream, "InputStream");
        ValueEnforcer.isArrayOfsLen(byArray, n, n2);
        for (n3 = 0; n3 < n2; n3 += n4) {
            n4 = inputStream.read(byArray, n + n3, n2 - n3);
            if (n4 >= 0) continue;
            throw new EOFException("Failed to read a total of " + n2 + " bytes from input stream. Only read " + n3 + " bytes so far.");
        }
        return n3;
    }

    private static void _readUntilEOF(@WillNotClose @NonNull InputStream inputStream, byte @NonNull [] byArray, @NonNull ObjIntConsumer<? super byte[]> objIntConsumer) throws IOException {
        int n;
        ValueEnforcer.notNull(inputStream, "InputStream");
        ValueEnforcer.notNull(byArray, "Buffer");
        ValueEnforcer.notNull(objIntConsumer, "Consumer");
        while ((n = inputStream.read(byArray, 0, byArray.length)) > -1) {
            objIntConsumer.accept((byte[])byArray, n);
        }
    }

    public static void readUntilEOF(@WillClose @NonNull InputStream inputStream, @NonNull ObjIntConsumer<? super byte[]> objIntConsumer) throws IOException {
        StreamHelper.readUntilEOF(inputStream, StreamHelper.createDefaultCopyBufferBytes(), objIntConsumer);
    }

    public static void readUntilEOF(@WillClose @NonNull InputStream inputStream, byte @NonNull [] byArray, @NonNull ObjIntConsumer<? super byte[]> objIntConsumer) throws IOException {
        try {
            ValueEnforcer.notNull(inputStream, "InputStream");
            ValueEnforcer.notNull(byArray, "Buffer");
            ValueEnforcer.notNull(objIntConsumer, "Consumer");
            StreamHelper._readUntilEOF(inputStream, byArray, objIntConsumer);
        }
        finally {
            StreamHelper.close(inputStream);
        }
    }

    private static void _readUntilEOF(@WillNotClose @NonNull Reader reader, char @NonNull [] cArray, @NonNull ObjIntConsumer<? super char[]> objIntConsumer) throws IOException {
        int n;
        ValueEnforcer.notNull(reader, "Reader");
        ValueEnforcer.notNull(cArray, "Buffer");
        ValueEnforcer.notNull(objIntConsumer, "Consumer");
        while ((n = reader.read(cArray, 0, cArray.length)) > -1) {
            objIntConsumer.accept((char[])cArray, n);
        }
    }

    public static void readUntilEOF(@WillClose @NonNull Reader reader, @NonNull ObjIntConsumer<? super char[]> objIntConsumer) throws IOException {
        StreamHelper.readUntilEOF(reader, new char[16384], objIntConsumer);
    }

    public static void readUntilEOF(@WillClose @NonNull Reader reader, char @NonNull [] cArray, @NonNull ObjIntConsumer<? super char[]> objIntConsumer) throws IOException {
        try {
            ValueEnforcer.notNull(reader, "Reader");
            ValueEnforcer.notNull(cArray, "Buffer");
            ValueEnforcer.notNull(objIntConsumer, "Consumer");
            StreamHelper._readUntilEOF(reader, cArray, objIntConsumer);
        }
        finally {
            StreamHelper.close(reader);
        }
    }

    public static @Nullable InputStream checkForInvalidFilterInputStream(@Nullable InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.markSupported();
            }
            catch (NullPointerException nullPointerException) {
                StreamHelper.close(inputStream);
                return null;
            }
        }
        return inputStream;
    }

    public static void writeSafeUTF(@NonNull DataOutput dataOutput, @Nullable String string) throws IOException {
        ValueEnforcer.notNull(dataOutput, "DataOutput");
        if (string == null) {
            dataOutput.writeByte(0);
        } else {
            dataOutput.writeByte(2);
            byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
            dataOutput.writeInt(byArray.length);
            dataOutput.write(byArray);
            dataOutput.writeInt(-131075);
        }
    }

    public static @Nullable String readSafeUTF(@NonNull DataInput dataInput) throws IOException {
        String string;
        ValueEnforcer.notNull(dataInput, "DataInput");
        byte by = dataInput.readByte();
        switch (by) {
            case 0: {
                string = null;
                break;
            }
            case 1: {
                int n = dataInput.readInt();
                byte[] byArray = new byte[n];
                dataInput.readFully(byArray);
                string = new String(byArray, StandardCharsets.UTF_8);
                break;
            }
            case 2: {
                int n = dataInput.readInt();
                byte[] byArray = new byte[n];
                dataInput.readFully(byArray);
                string = new String(byArray, StandardCharsets.UTF_8);
                int n2 = dataInput.readInt();
                if (n2 == -131075) break;
                throw new IOException("Missing end of String marker");
            }
            default: {
                throw new IOException("Unsupported string layout version " + by);
            }
        }
        return string;
    }

    public static class CopyByteStreamBuilder
    implements IBuilder<ESuccess> {
        public static final boolean DEFAULT_CLOSE_SOURCE = false;
        public static final boolean DEFAULT_CLOSE_DESTINATION = false;
        private InputStream m_aIS;
        private boolean m_bCloseIS = false;
        private OutputStream m_aOS;
        private boolean m_bCloseOS = false;
        private byte[] m_aBuffer;
        private long m_nLimit = -1L;
        private IExceptionCallback<IOException> m_aExceptionCallback;
        private MutableLong m_aCopyByteCount;
        private LongConsumer m_aProgressCallback;

        public @NonNull CopyByteStreamBuilder from(@Nullable InputStream inputStream) {
            this.m_aIS = inputStream;
            return this;
        }

        public @NonNull CopyByteStreamBuilder closeFrom(boolean bl) {
            this.m_bCloseIS = bl;
            return this;
        }

        public @NonNull CopyByteStreamBuilder to(@Nullable OutputStream outputStream) {
            this.m_aOS = outputStream;
            return this;
        }

        public @NonNull CopyByteStreamBuilder closeTo(boolean bl) {
            this.m_bCloseOS = bl;
            return this;
        }

        public @NonNull CopyByteStreamBuilder buffer(byte @Nullable [] byArray) {
            this.m_aBuffer = byArray;
            return this;
        }

        public @NonNull CopyByteStreamBuilder limit(long l) {
            this.m_nLimit = l;
            return this;
        }

        public @NonNull CopyByteStreamBuilder limit(@Nullable Long l) {
            return l == null ? this.unlimited() : this.limit((long)l);
        }

        public @NonNull CopyByteStreamBuilder unlimited() {
            return this.limit(-1L);
        }

        public @NonNull CopyByteStreamBuilder exceptionCallback(@Nullable IExceptionCallback<IOException> iExceptionCallback) {
            this.m_aExceptionCallback = iExceptionCallback;
            return this;
        }

        public @NonNull CopyByteStreamBuilder copyByteCount(@Nullable MutableLong mutableLong) {
            this.m_aCopyByteCount = mutableLong;
            return this;
        }

        public @NonNull CopyByteStreamBuilder progressCallback(@Nullable LongConsumer longConsumer) {
            this.m_aProgressCallback = longConsumer;
            return this;
        }

        @Nonnegative
        private static long _copyInputStreamToOutputStream(@WillNotClose @NonNull InputStream inputStream, @WillNotClose @NonNull OutputStream outputStream, byte @NonNull [] byArray, @Nullable LongConsumer longConsumer) throws IOException {
            int n;
            int n2 = byArray.length;
            long l = 0L;
            while ((n = inputStream.read(byArray, 0, n2)) > -1) {
                if (n <= 0) continue;
                outputStream.write(byArray, 0, n);
                l += (long)n;
                if (longConsumer == null) continue;
                longConsumer.accept(l);
            }
            return l;
        }

        @Nonnegative
        private static long _copyInputStreamToOutputStreamWithLimit(@WillNotClose @NonNull InputStream inputStream, @WillNotClose @NonNull OutputStream outputStream, byte @NonNull [] byArray, @Nonnegative long l, @Nullable LongConsumer longConsumer) throws IOException {
            int n = byArray.length;
            long l2 = l;
            long l3 = 0L;
            while (true) {
                int n2;
                int n3;
                int n4 = n3 = l2 >= (long)n ? n : (int)l2;
                if (n3 == 0 || (n2 = inputStream.read(byArray, 0, n3)) == -1) break;
                if (n2 <= 0) continue;
                outputStream.write(byArray, 0, n2);
                l3 += (long)n2;
                l2 -= (long)n2;
                if (longConsumer == null) continue;
                longConsumer.accept(l3);
            }
            return l3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public @NonNull ESuccess build() {
            try {
                if (this.m_aIS == null) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("The source InputStream is not set - hence no copying is possible");
                    }
                    ESuccess eSuccess = ESuccess.FAILURE;
                    return eSuccess;
                }
                if (this.m_aOS == null) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("The target OutputStream is not set - hence no copying is possible");
                    }
                    ESuccess eSuccess = ESuccess.FAILURE;
                    return eSuccess;
                }
                byte[] byArray = this.m_aBuffer != null && this.m_aBuffer.length > 0 ? this.m_aBuffer : StreamHelper.createDefaultCopyBufferBytes();
                long l = this.m_nLimit < 0L ? CopyByteStreamBuilder._copyInputStreamToOutputStream(this.m_aIS, this.m_aOS, byArray, this.m_aProgressCallback) : CopyByteStreamBuilder._copyInputStreamToOutputStreamWithLimit(this.m_aIS, this.m_aOS, byArray, this.m_nLimit, this.m_aProgressCallback);
                if (this.m_aCopyByteCount != null) {
                    this.m_aCopyByteCount.set(l);
                }
                ESuccess eSuccess = ESuccess.SUCCESS;
                return eSuccess;
            }
            catch (IOException iOException) {
                if (this.m_aExceptionCallback != null) {
                    this.m_aExceptionCallback.onException(iOException);
                } else if (!StreamHelper.isKnownEOFException(iOException)) {
                    LOGGER.error("Failed to copy from InputStream to OutputStream", (Throwable)StreamHelper.internalGetPropagatableException(iOException));
                }
            }
            finally {
                if (this.m_bCloseIS) {
                    StreamHelper.close(this.m_aIS);
                }
                if (this.m_bCloseOS) {
                    StreamHelper.close(this.m_aOS);
                }
            }
            return ESuccess.FAILURE;
        }
    }

    public static class CopyCharStreamBuilder
    implements IBuilder<ESuccess> {
        public static final boolean DEFAULT_CLOSE_FROM = false;
        public static final boolean DEFAULT_CLOSE_TO = false;
        private Reader m_aReader;
        private boolean m_bCloseReader = false;
        private Writer m_aWriter;
        private boolean m_bCloseWriter = false;
        private char[] m_aBuffer;
        private long m_nLimit = -1L;
        private IExceptionCallback<IOException> m_aExceptionCallback;
        private MutableLong m_aCopyCharCount;
        private LongConsumer m_aProgressCallback;

        public @NonNull CopyCharStreamBuilder from(@Nullable Reader reader) {
            this.m_aReader = reader;
            return this;
        }

        public @NonNull CopyCharStreamBuilder closeFrom(boolean bl) {
            this.m_bCloseReader = bl;
            return this;
        }

        public @NonNull CopyCharStreamBuilder to(@Nullable Writer writer) {
            this.m_aWriter = writer;
            return this;
        }

        public @NonNull CopyCharStreamBuilder closeTo(boolean bl) {
            this.m_bCloseWriter = bl;
            return this;
        }

        public @NonNull CopyCharStreamBuilder buffer(char @Nullable [] cArray) {
            this.m_aBuffer = cArray;
            return this;
        }

        public @NonNull CopyCharStreamBuilder limit(long l) {
            this.m_nLimit = l;
            return this;
        }

        public @NonNull CopyCharStreamBuilder limit(@Nullable Long l) {
            return l == null ? this.unlimited() : this.limit((long)l);
        }

        public @NonNull CopyCharStreamBuilder unlimited() {
            return this.limit(-1L);
        }

        public @NonNull CopyCharStreamBuilder exceptionCallback(@Nullable IExceptionCallback<IOException> iExceptionCallback) {
            this.m_aExceptionCallback = iExceptionCallback;
            return this;
        }

        public @NonNull CopyCharStreamBuilder copyCharCount(@Nullable MutableLong mutableLong) {
            this.m_aCopyCharCount = mutableLong;
            return this;
        }

        public @NonNull CopyCharStreamBuilder progressCallback(@Nullable LongConsumer longConsumer) {
            this.m_aProgressCallback = longConsumer;
            return this;
        }

        @Nonnegative
        private static long _copyReaderToWriter(@WillNotClose @NonNull Reader reader, @WillNotClose @NonNull Writer writer, char @NonNull [] cArray, @Nullable LongConsumer longConsumer) throws IOException {
            int n;
            long l = 0L;
            while ((n = reader.read(cArray, 0, cArray.length)) > -1) {
                if (n <= 0) continue;
                writer.write(cArray, 0, n);
                l += (long)n;
                if (longConsumer == null) continue;
                longConsumer.accept(l);
            }
            return l;
        }

        @Nonnegative
        private static long _copyReaderToWriterWithLimit(@WillNotClose @NonNull Reader reader, @WillNotClose @NonNull Writer writer, char @NonNull [] cArray, @Nonnegative long l, @Nullable LongConsumer longConsumer) throws IOException {
            long l2 = l;
            long l3 = 0L;
            while (true) {
                int n;
                int n2;
                int n3 = n2 = l2 >= (long)cArray.length ? cArray.length : (int)l2;
                if (n2 == 0 || (n = reader.read(cArray, 0, n2)) == -1) break;
                if (n <= 0) continue;
                writer.write(cArray, 0, n);
                l3 += (long)n;
                l2 -= (long)n;
                if (longConsumer == null) continue;
                longConsumer.accept(l3);
            }
            return l3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public @NonNull ESuccess build() {
            try {
                if (this.m_aReader == null) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("The source Reader is not set - hence no copying is possible");
                    }
                    ESuccess eSuccess = ESuccess.FAILURE;
                    return eSuccess;
                }
                if (this.m_aWriter == null) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("The target Writer is not set - hence no copying is possible");
                    }
                    ESuccess eSuccess = ESuccess.FAILURE;
                    return eSuccess;
                }
                char[] cArray = this.m_aBuffer != null && this.m_aBuffer.length > 0 ? this.m_aBuffer : StreamHelper.createDefaultCopyBufferChars();
                long l = this.m_nLimit < 0L ? CopyCharStreamBuilder._copyReaderToWriter(this.m_aReader, this.m_aWriter, cArray, this.m_aProgressCallback) : CopyCharStreamBuilder._copyReaderToWriterWithLimit(this.m_aReader, this.m_aWriter, cArray, this.m_nLimit, this.m_aProgressCallback);
                if (this.m_aCopyCharCount != null) {
                    this.m_aCopyCharCount.set(l);
                }
                ESuccess eSuccess = ESuccess.SUCCESS;
                return eSuccess;
            }
            catch (IOException iOException) {
                if (this.m_aExceptionCallback != null) {
                    this.m_aExceptionCallback.onException(iOException);
                } else if (!StreamHelper.isKnownEOFException(iOException)) {
                    LOGGER.error("Failed to copy from Reader to Writer", (Throwable)StreamHelper.internalGetPropagatableException(iOException));
                }
            }
            finally {
                if (this.m_bCloseReader) {
                    StreamHelper.close(this.m_aReader);
                }
                if (this.m_bCloseWriter) {
                    StreamHelper.close(this.m_aWriter);
                }
            }
            return ESuccess.FAILURE;
        }
    }
}

