/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.codec.impl;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.WillNotClose;
import com.helger.base.codec.DecodeException;
import com.helger.base.codec.EncodeException;
import com.helger.base.codec.IByteArrayCodec;
import com.helger.base.io.nonblocking.NonBlockingByteArrayInputStream;
import com.helger.base.io.stream.NonClosingOutputStream;
import com.helger.base.io.stream.StreamHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class GZIPCodec
implements IByteArrayCodec {
    @Override
    public void decode(byte @Nullable [] byArray, @Nonnegative int n, @Nonnegative int n2, @WillNotClose @NonNull OutputStream outputStream) {
        if (byArray == null || n2 == 0) {
            return;
        }
        try (GZIPInputStream gZIPInputStream = new GZIPInputStream(new NonBlockingByteArrayInputStream(byArray, n, n2));){
            if (StreamHelper.copyInputStreamToOutputStream(gZIPInputStream, outputStream).isFailure()) {
                throw new DecodeException("Failed to GZIP decode!");
            }
        }
        catch (IOException iOException) {
            throw new DecodeException("Failed to GZIP encode", iOException);
        }
    }

    @Override
    public void encode(byte @Nullable [] byArray, @Nonnegative int n, @Nonnegative int n2, @WillNotClose @NonNull OutputStream outputStream) {
        if (byArray == null || n2 == 0) {
            return;
        }
        try (GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(new NonClosingOutputStream(outputStream));){
            if (StreamHelper.copyInputStreamToOutputStream(new NonBlockingByteArrayInputStream(byArray, n, n2), gZIPOutputStream).isFailure()) {
                throw new EncodeException("Failed to GZIP encode!");
            }
        }
        catch (IOException iOException) {
            throw new EncodeException("Failed to GZIP encode", iOException);
        }
    }
}

