/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import org.h2.Driver;
import org.h2.engine.Constants;
import org.h2.server.web.ConnectionInfo;
import org.h2.util.JdbcUtils;
import org.h2.util.New;
import org.h2.util.ScriptReader;
import org.h2.util.SortedProperties;
import org.h2.util.Tool;
import org.h2.util.Utils;

public class Shell
extends Tool
implements Runnable {
    private static final int HISTORY_COUNT = 20;
    private PrintStream err = System.err;
    private InputStream in = System.in;
    private BufferedReader reader;
    private Connection conn;
    private Statement stat;
    private boolean listMode;
    private int maxColumnSize = 100;
    private char boxVertical = (char)124;
    private ArrayList<String> history = New.arrayList();
    private boolean stopHide;
    private String serverPropertiesDir = "~";

    public static void main(String ... stringArray) throws SQLException {
        new Shell().runTool(stringArray);
    }

    public void setErr(PrintStream printStream) {
        this.err = printStream;
    }

    public void setIn(InputStream inputStream) {
        this.in = inputStream;
    }

    public void setInReader(BufferedReader bufferedReader) {
        this.reader = bufferedReader;
    }

    public void runTool(String ... stringArray) throws SQLException {
        String string;
        String string2 = null;
        String string3 = "";
        String string4 = "";
        String string5 = null;
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            string = stringArray[i];
            if (string.equals("-url")) {
                string2 = stringArray[++i];
                continue;
            }
            if (string.equals("-user")) {
                string3 = stringArray[++i];
                continue;
            }
            if (string.equals("-password")) {
                string4 = stringArray[++i];
                continue;
            }
            if (string.equals("-driver")) {
                String string6 = stringArray[++i];
                Utils.loadUserClass(string6);
                continue;
            }
            if (string.equals("-sql")) {
                string5 = stringArray[++i];
                continue;
            }
            if (string.equals("-properties")) {
                this.serverPropertiesDir = stringArray[++i];
                continue;
            }
            if (string.equals("-help") || string.equals("-?")) {
                this.showUsage();
                return;
            }
            this.throwUnsupportedOption(string);
        }
        if (string2 != null) {
            Driver.load();
            this.conn = DriverManager.getConnection(string2, string3, string4);
            this.stat = this.conn.createStatement();
        }
        if (string5 == null) {
            this.promptLoop();
        } else {
            ScriptReader scriptReader = new ScriptReader(new StringReader(string5));
            while ((string = scriptReader.readStatement()) != null) {
                this.execute(string);
            }
        }
    }

    private void showHelp() {
        this.println("Commands are case insensitive; SQL statements end with ';'");
        this.println("help or ?      Display this help");
        this.println("list           Toggle result list / stack trace mode");
        this.println("maxwidth       Set maximum column width (default is 100)");
        this.println("show           List all tables");
        this.println("describe       Describe a table");
        this.println("autocommit     Enable or disable autocommit");
        this.println("history        Show the last 20 statements");
        this.println("quit or exit   Close the connection and exit");
        this.println("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void promptLoop() {
        this.println("");
        this.println("Welcome to H2 Shell " + Constants.getFullVersion());
        this.println("Exit with Ctrl+C");
        if (this.conn != null) {
            this.showHelp();
        }
        String string = null;
        if (this.reader == null) {
            this.reader = new BufferedReader(new InputStreamReader(this.in));
        }
        block12: while (true) {
            try {
                while (true) {
                    int n;
                    int n2;
                    String string2;
                    if (this.conn == null) {
                        this.connect();
                        this.showHelp();
                    }
                    if (string == null) {
                        this.print("sql> ");
                    } else {
                        this.print("...> ");
                    }
                    String string3 = this.readLine();
                    if (string3 == null) break block12;
                    String string4 = string3.trim();
                    if (string4.length() == 0) continue;
                    boolean bl = string4.endsWith(";");
                    if (bl) {
                        string3 = string3.substring(0, string3.lastIndexOf(59));
                        string4 = string4.substring(0, string4.length() - 1);
                    }
                    if ("EXIT".equals(string2 = string4.toUpperCase()) || "QUIT".equals(string2)) break block12;
                    if ("HELP".equals(string2) || "?".equals(string2)) {
                        this.showHelp();
                        continue;
                    }
                    if ("LIST".equals(string2)) {
                        this.listMode = !this.listMode;
                        this.println("Result list mode is now " + (this.listMode ? "on" : "off"));
                        continue;
                    }
                    if ("HISTORY".equals(string2)) {
                        n2 = this.history.size();
                        for (n = 0; n < n2; ++n) {
                            String string5 = this.history.get(n);
                            string5 = string5.replace('\n', ' ').replace('\r', ' ');
                            this.println("#" + (1 + n) + ": " + string5);
                        }
                        if (this.history.size() > 0) {
                            this.println("To re-run a statement, type the number and press and enter");
                            continue;
                        }
                        this.println("No history");
                        continue;
                    }
                    if (string2.startsWith("DESCRIBE")) {
                        String string6 = string2.substring("DESCRIBE".length()).trim();
                        if (string6.length() == 0) {
                            this.println("Usage: describe [<schema name>.]<table name>");
                            continue;
                        }
                        String string7 = null;
                        int n3 = string6.indexOf(46);
                        if (n3 >= 0) {
                            string7 = string6.substring(0, n3);
                            string6 = string6.substring(n3 + 1);
                        }
                        PreparedStatement preparedStatement = null;
                        ResultSet resultSet = null;
                        try {
                            String string8 = "SELECT CAST(COLUMN_NAME AS VARCHAR(32)) AS \"Column Name\", CAST(TYPE_NAME AS VARCHAR(14)) AS \"Type\", NUMERIC_PRECISION AS \"Precision\", CAST(IS_NULLABLE AS VARCHAR(8)) AS \"Nullable\", CAST(COLUMN_DEFAULT AS VARCHAR(20)) AS \"Default\" FROM INFORMATION_SCHEMA.COLUMNS WHERE UPPER(TABLE_NAME)=?";
                            if (string7 != null) {
                                string8 = string8 + " AND UPPER(TABLE_SCHEMA)=?";
                            }
                            string8 = string8 + " ORDER BY ORDINAL_POSITION";
                            preparedStatement = this.conn.prepareStatement(string8);
                            preparedStatement.setString(1, string6.toUpperCase());
                            if (string7 != null) {
                                preparedStatement.setString(2, string7.toUpperCase());
                            }
                            resultSet = preparedStatement.executeQuery();
                            this.printResult(resultSet, false);
                        }
                        catch (Throwable throwable) {
                            JdbcUtils.closeSilently(resultSet);
                            JdbcUtils.closeSilently(preparedStatement);
                            throw throwable;
                        }
                        JdbcUtils.closeSilently(resultSet);
                        JdbcUtils.closeSilently(preparedStatement);
                        continue;
                    }
                    if (string2.startsWith("SHOW")) {
                        ResultSet resultSet = null;
                        try {
                            resultSet = this.stat.executeQuery("SELECT CAST(TABLE_SCHEMA AS VARCHAR(32)) AS \"Schema\", TABLE_NAME AS \"Table Name\" FROM INFORMATION_SCHEMA.TABLES ORDER BY TABLE_SCHEMA, TABLE_NAME");
                            this.printResult(resultSet, false);
                        }
                        catch (Throwable throwable) {
                            JdbcUtils.closeSilently(resultSet);
                            throw throwable;
                        }
                        JdbcUtils.closeSilently(resultSet);
                        continue;
                    }
                    if (string2.startsWith("AUTOCOMMIT")) {
                        if ("TRUE".equals(string2 = string2.substring("AUTOCOMMIT".length()).trim())) {
                            this.conn.setAutoCommit(true);
                        } else if ("FALSE".equals(string2)) {
                            this.conn.setAutoCommit(false);
                        } else {
                            this.println("Usage: autocommit [true|false]");
                        }
                        this.println("Autocommit is now " + this.conn.getAutoCommit());
                        continue;
                    }
                    if (string2.startsWith("MAXWIDTH")) {
                        string2 = string2.substring("MAXWIDTH".length()).trim();
                        try {
                            this.maxColumnSize = Integer.parseInt(string2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.println("Usage: maxwidth <integer value>");
                        }
                        this.println("Maximum column width is now " + this.maxColumnSize);
                        continue;
                    }
                    n = 1;
                    if (string == null) {
                        if (this.isNumber(string3)) {
                            n2 = Integer.parseInt(string3);
                            if (n2 == 0 || n2 > this.history.size()) {
                                this.println("Not found");
                            } else {
                                string = this.history.get(n2 - 1);
                                n = 0;
                                this.println(string);
                                bl = true;
                            }
                        } else {
                            string = string3;
                        }
                    } else {
                        string = string + "\n" + string3;
                    }
                    if (!bl) continue;
                    if (n != 0) {
                        this.history.add(0, string);
                        if (this.history.size() > 20) {
                            this.history.remove(20);
                        }
                    }
                    this.execute(string);
                    string = null;
                }
            }
            catch (SQLException sQLException) {
                this.println("SQL Exception: " + sQLException.getMessage());
                string = null;
                continue;
            }
            catch (IOException iOException) {
                this.println(iOException.getMessage());
            }
            catch (Exception exception) {
                this.println("Exception: " + exception.toString());
                exception.printStackTrace(this.err);
            }
            break;
        }
        if (this.conn != null) {
            try {
                this.conn.close();
                this.println("Connection closed");
            }
            catch (SQLException sQLException) {
                this.println("SQL Exception: " + sQLException.getMessage());
                sQLException.printStackTrace(this.err);
            }
        }
    }

    private boolean isNumber(String string) {
        if (string.length() == 0) {
            return false;
        }
        for (char c : string.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    private void connect() throws IOException, SQLException {
        Object object;
        String string = "jdbc:h2:~/test";
        String string2 = "sa";
        String string3 = null;
        try {
            String string4;
            object = "null".equals(this.serverPropertiesDir) ? new Properties() : SortedProperties.loadProperties(this.serverPropertiesDir + "/" + ".h2.server.properties");
            String string5 = null;
            boolean bl = false;
            int n = 0;
            while ((string4 = ((Properties)object).getProperty(String.valueOf(n))) != null) {
                bl = true;
                string5 = string4;
                ++n;
            }
            if (bl) {
                ConnectionInfo connectionInfo = new ConnectionInfo(string5);
                string = connectionInfo.url;
                string2 = connectionInfo.user;
                string3 = connectionInfo.driver;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.println("[Enter]   " + string);
        this.print("URL       ");
        string = this.readLine(string).trim();
        if (string3 == null) {
            string3 = JdbcUtils.getDriver(string);
        }
        if (string3 != null) {
            this.println("[Enter]   " + string3);
        }
        this.print("Driver    ");
        string3 = this.readLine(string3).trim();
        this.println("[Enter]   " + string2);
        this.print("User      ");
        string2 = this.readLine(string2);
        this.println("[Enter]   Hide");
        this.print("Password  ");
        object = this.readLine();
        if (((String)object).length() == 0) {
            object = this.readPassword();
        }
        this.conn = JdbcUtils.getConnection(string3, string, string2, (String)object);
        this.stat = this.conn.createStatement();
        this.println("Connected");
    }

    protected void print(String string) {
        this.out.print(string);
        this.out.flush();
    }

    private void println(String string) {
        this.out.println(string);
        this.out.flush();
    }

    private String readPassword() throws IOException {
        try {
            Object object = Utils.callStaticMethod("java.lang.System.console", new Object[0]);
            this.print("Password  ");
            char[] cArray = (char[])Utils.callMethod(object, "readPassword", new Object[0]);
            return cArray == null ? null : new String(cArray);
        }
        catch (Exception exception) {
            Thread thread = new Thread(this);
            this.stopHide = false;
            thread.start();
            this.print("Password  > ");
            String string = this.readLine();
            this.stopHide = true;
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.print("\b\b");
            return string;
        }
    }

    public void run() {
        while (!this.stopHide) {
            this.print("\b\b><");
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private String readLine(String string) throws IOException {
        String string2 = this.readLine();
        return string2.length() == 0 ? string : string2;
    }

    private String readLine() throws IOException {
        String string = this.reader.readLine();
        if (string == null) {
            throw new IOException("Aborted");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(String string) {
        long l = System.currentTimeMillis();
        try {
            ResultSet resultSet;
            block6: {
                resultSet = null;
                try {
                    if (this.stat.execute(string)) {
                        resultSet = this.stat.getResultSet();
                        int n = this.printResult(resultSet, this.listMode);
                        l = System.currentTimeMillis() - l;
                        this.println("(" + n + (n == 1 ? " row, " : " rows, ") + l + " ms)");
                        break block6;
                    }
                    int n = this.stat.getUpdateCount();
                    l = System.currentTimeMillis() - l;
                    this.println("(Update count: " + n + ", " + l + " ms)");
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeSilently(resultSet);
                    throw throwable;
                }
            }
            JdbcUtils.closeSilently(resultSet);
        }
        catch (SQLException sQLException) {
            this.println("Error: " + sQLException.toString());
            if (this.listMode) {
                sQLException.printStackTrace(this.err);
            }
            return;
        }
    }

    private int printResult(ResultSet resultSet, boolean bl) throws SQLException {
        int n;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n2 = 0;
        int n3 = resultSetMetaData.getColumnCount();
        String[] stringArray = new String[n3];
        int[] nArray = new int[n3];
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            String string = resultSetMetaData.getColumnLabel(i + 1);
            int n5 = string.length();
            if (!bl) {
                n5 = Math.max(n5, resultSetMetaData.getColumnDisplaySize(i + 1));
                n5 = Math.min(this.maxColumnSize, n5);
            }
            if (string.length() > n5) {
                string = string.substring(0, n5);
            }
            stringArray[i] = string;
            nArray[i] = n5;
            n2 = Math.max(n2, n5);
            n4 += n5;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (!bl) {
            for (int i = 0; i < n3; ++i) {
                if (i > 0) {
                    stringBuilder.append(this.boxVertical);
                }
                String string = stringArray[i];
                stringBuilder.append(string);
                if (i >= n3 - 1) continue;
                for (n = string.length(); n < nArray[i]; ++n) {
                    stringBuilder.append(' ');
                }
            }
            this.println(stringBuilder.toString());
        }
        boolean bl2 = false;
        int n6 = 0;
        while (resultSet.next()) {
            int n7;
            String string;
            ++n6;
            stringBuilder.setLength(0);
            if (bl) {
                if (n6 > 1) {
                    this.println("");
                }
                for (n = 0; n < n3; ++n) {
                    if (n > 0) {
                        stringBuilder.append('\n');
                    }
                    string = stringArray[n];
                    stringBuilder.append(string);
                    for (n7 = string.length(); n7 < n2; ++n7) {
                        stringBuilder.append(' ');
                    }
                    stringBuilder.append(": ").append(resultSet.getString(n + 1));
                }
            } else {
                for (n = 0; n < n3; ++n) {
                    if (n > 0) {
                        stringBuilder.append(this.boxVertical);
                    }
                    if ((string = resultSet.getString(n + 1)) == null) {
                        string = "null";
                    }
                    n7 = nArray[n];
                    if (n3 > 1 && !bl && string.length() > n7) {
                        string = string.substring(0, n7);
                        bl2 = true;
                    }
                    stringBuilder.append(string);
                    if (n >= n3 - 1) continue;
                    for (int i = string.length(); i < n7; ++i) {
                        stringBuilder.append(' ');
                    }
                }
            }
            this.println(stringBuilder.toString());
        }
        if (n6 == 0 && bl) {
            for (String string : stringArray) {
                stringBuilder.append(string).append('\n');
            }
            this.println(stringBuilder.toString());
        }
        if (bl2) {
            this.println("(data is partially truncated)");
        }
        return n6;
    }
}

