/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.zip.CRC32;
import org.h2.compress.CompressLZF;
import org.h2.constant.SysProperties;
import org.h2.engine.MetaRecord;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SimpleRow;
import org.h2.security.SHA256;
import org.h2.store.Data;
import org.h2.store.DataHandler;
import org.h2.store.DataReader;
import org.h2.store.FileLister;
import org.h2.store.FileStore;
import org.h2.store.FileStoreInputStream;
import org.h2.store.LobStorage;
import org.h2.store.PageFreeList;
import org.h2.store.PageLog;
import org.h2.store.PageStore;
import org.h2.util.IOUtils;
import org.h2.util.IntArray;
import org.h2.util.MathUtils;
import org.h2.util.New;
import org.h2.util.SmallLRUCache;
import org.h2.util.StatementBuilder;
import org.h2.util.TempFileDeleter;
import org.h2.util.Tool;
import org.h2.util.Utils;
import org.h2.value.Value;
import org.h2.value.ValueLob;
import org.h2.value.ValueLobDb;
import org.h2.value.ValueLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Recover
extends Tool
implements DataHandler {
    private String databaseName;
    private int block;
    private int storageId;
    private String storageName;
    private int recordLength;
    private int valueId;
    private boolean trace;
    private ArrayList<MetaRecord> schema;
    private HashSet<Integer> objectIdSet;
    private HashMap<Integer, String> tableMap;
    private HashMap<String, String> columnTypeMap;
    private boolean remove;
    private int pageSize;
    private FileStore store;
    private int[] parents;
    private Stats stat;

    public static void main(String ... stringArray) throws SQLException {
        new Recover().runTool(stringArray);
    }

    @Override
    public void runTool(String ... stringArray) throws SQLException {
        String string = ".";
        String string2 = null;
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            if ("-dir".equals(string3)) {
                string = stringArray[++i];
                continue;
            }
            if ("-db".equals(string3)) {
                string2 = stringArray[++i];
                continue;
            }
            if ("-removePassword".equals(string3)) {
                this.remove = true;
                continue;
            }
            if ("-trace".equals(string3)) {
                this.trace = true;
                continue;
            }
            if (string3.equals("-help") || string3.equals("-?")) {
                this.showUsage();
                return;
            }
            this.throwUnsupportedOption(string3);
        }
        this.process(string, string2);
    }

    public static Reader readClob(String string) throws IOException {
        return new BufferedReader(new InputStreamReader(Recover.readBlob(string), "UTF-8"));
    }

    public static InputStream readBlob(String string) throws IOException {
        return new BufferedInputStream(IOUtils.openFileInputStream(string));
    }

    public static Value.ValueBlob readBlobDb(Connection connection, long l, long l2) {
        DataHandler dataHandler = ((JdbcConnection)connection).getSession().getDataHandler();
        LobStorage lobStorage = dataHandler.getLobStorage();
        return ValueLobDb.create(15, lobStorage, null, -2, l, l2);
    }

    public static Value.ValueClob readClobDb(Connection connection, long l, long l2) {
        DataHandler dataHandler = ((JdbcConnection)connection).getSession().getDataHandler();
        LobStorage lobStorage = dataHandler.getLobStorage();
        return ValueLobDb.create(16, lobStorage, null, -2, l, l2);
    }

    private void trace(String string) {
        if (this.trace) {
            this.out.println(string);
        }
    }

    private void traceError(String string, Throwable throwable) {
        this.out.println(string + ": " + throwable.toString());
        if (this.trace) {
            throwable.printStackTrace(this.out);
        }
    }

    public static void execute(String string, String string2) throws SQLException {
        try {
            new Recover().process(string, string2);
        }
        catch (DbException dbException) {
            throw DbException.toSQLException(dbException);
        }
    }

    private void process(String string, String string2) {
        ArrayList<String> arrayList = FileLister.getDatabaseFiles(string, string2, true);
        if (arrayList.size() == 0) {
            this.printNoDatabaseFilesFound(string, string2);
        }
        for (String string3 : arrayList) {
            if (string3.endsWith(".h2.db")) {
                this.dumpPageStore(string3);
                continue;
            }
            if (!string3.endsWith(".lob.db")) continue;
            this.dumpLob(string3, true);
            this.dumpLob(string3, false);
        }
    }

    private PrintWriter getWriter(String string, String string2) {
        string = string.substring(0, string.length() - 3);
        String string3 = string + string2;
        this.trace("Created file: " + string3);
        return new PrintWriter(IOUtils.getWriter(IOUtils.openFileOutputStream(string3, false)));
    }

    private void writeDataError(PrintWriter printWriter, String string, byte[] byArray) {
        int n;
        int n2;
        printWriter.println("-- ERROR: " + string + " block: " + this.block + " storageId: " + this.storageId + " recordLength: " + this.recordLength + " valueId: " + this.valueId);
        StringBuilder stringBuilder = new StringBuilder();
        for (n2 = 0; n2 < byArray.length; ++n2) {
            n = byArray[n2] & 0xFF;
            if (n >= 32 && n < 128) {
                stringBuilder.append((char)n);
                continue;
            }
            stringBuilder.append('?');
        }
        printWriter.println("-- dump: " + stringBuilder.toString());
        stringBuilder = new StringBuilder();
        for (n2 = 0; n2 < byArray.length; ++n2) {
            n = byArray[n2] & 0xFF;
            stringBuilder.append(' ');
            if (n < 16) {
                stringBuilder.append('0');
            }
            stringBuilder.append(Integer.toHexString(n));
        }
        printWriter.println("-- dump: " + stringBuilder.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void dumpLob(String string, boolean bl) {
        OutputStream outputStream = null;
        FileStore fileStore = null;
        int n = 0;
        String string2 = string + (bl ? ".comp" : "") + ".txt";
        BufferedInputStream bufferedInputStream = null;
        try {
            int n2;
            outputStream = IOUtils.openFileOutputStream(string2, false);
            fileStore = FileStore.open(null, string, "r");
            fileStore.init();
            bufferedInputStream = new BufferedInputStream(new FileStoreInputStream(fileStore, this, bl, false));
            byte[] byArray = new byte[4096];
            while ((n2 = ((InputStream)bufferedInputStream).read(byArray)) >= 0) {
                outputStream.write(byArray, 0, n2);
                n += n2;
            }
            outputStream.close();
        }
        catch (Throwable throwable) {
            IOUtils.closeSilently(outputStream);
            IOUtils.closeSilently(bufferedInputStream);
            this.closeSilently(fileStore);
            catch (Throwable throwable2) {
                IOUtils.closeSilently(outputStream);
                IOUtils.closeSilently(bufferedInputStream);
                this.closeSilently(fileStore);
                throw throwable2;
            }
        }
        IOUtils.closeSilently(outputStream);
        IOUtils.closeSilently(bufferedInputStream);
        this.closeSilently(fileStore);
        if (n == 0) {
            try {
                IOUtils.delete(string2);
            }
            catch (Exception exception) {
                this.traceError(string2, exception);
            }
        }
    }

    private String getSQL(String string, Value value) {
        ValueLobDb valueLobDb;
        byte[] byArray;
        if (value instanceof ValueLob) {
            ValueLob valueLob = (ValueLob)value;
            byte[] byArray2 = valueLob.getSmall();
            if (byArray2 == null) {
                String string2 = valueLob.getFileName();
                if (valueLob.getType() == 15) {
                    return "READ_BLOB('" + string2 + ".txt')";
                }
                return "READ_CLOB('" + string2 + ".txt')";
            }
        } else if (value instanceof ValueLobDb && (byArray = (valueLobDb = (ValueLobDb)value).getSmall()) == null) {
            String string3;
            String string4;
            int n = valueLobDb.getType();
            long l = valueLobDb.getLobId();
            long l2 = valueLobDb.getPrecision();
            if (n == 15) {
                string4 = "BLOB";
                string3 = "READ_BLOB_DB";
            } else {
                string4 = "CLOB";
                string3 = "READ_CLOB_DB";
            }
            this.columnTypeMap.put(string, string4);
            return string3 + "(" + l + ", " + l2 + ")";
        }
        return value.getSQL();
    }

    private void setDatabaseName(String string) {
        this.databaseName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpPageStore(String string) {
        this.setDatabaseName(string.substring(0, string.length() - ".h2.db".length()));
        PrintWriter printWriter = null;
        this.stat = new Stats();
        try {
            int n;
            int n2;
            printWriter = this.getWriter(string, ".sql");
            printWriter.println("CREATE ALIAS IF NOT EXISTS READ_BLOB FOR \"" + this.getClass().getName() + ".readBlob\";");
            printWriter.println("CREATE ALIAS IF NOT EXISTS READ_CLOB FOR \"" + this.getClass().getName() + ".readClob\";");
            printWriter.println("CREATE ALIAS IF NOT EXISTS READ_BLOB_DB FOR \"" + this.getClass().getName() + ".readBlobDb\";");
            printWriter.println("CREATE ALIAS IF NOT EXISTS READ_CLOB_DB FOR \"" + this.getClass().getName() + ".readClobDb\";");
            this.resetSchema();
            this.store = FileStore.open(null, string, this.remove ? "rw" : "r");
            long l = this.store.length();
            try {
                this.store.init();
            }
            catch (Exception exception) {
                this.writeError(printWriter, exception);
            }
            Data data = Data.create((DataHandler)this, 128);
            this.store.seek(0L);
            this.store.readFully(data.getBytes(), 0, 128);
            data.setPos(48);
            this.pageSize = data.readInt();
            byte by = data.readByte();
            byte by2 = data.readByte();
            printWriter.println("-- pageSize: " + this.pageSize + " writeVersion: " + by + " readVersion: " + by2);
            if (this.pageSize < 64 || this.pageSize > 32768) {
                this.pageSize = SysProperties.PAGE_SIZE;
                printWriter.println("-- ERROR: page size; using " + this.pageSize);
            }
            int n3 = (int)(l / (long)this.pageSize);
            this.parents = new int[n3];
            data = Data.create((DataHandler)this, this.pageSize);
            for (n2 = 3; n2 < n3; ++n2) {
                data.reset();
                this.store.seek(n2 * this.pageSize);
                this.store.readFully(data.getBytes(), 0, 32);
                data.readByte();
                data.readShortInt();
                this.parents[n2] = data.readInt();
            }
            n2 = 0;
            int n4 = 0;
            int n5 = 0;
            data = Data.create((DataHandler)this, this.pageSize);
            for (int i = 1; i != 3; ++i) {
                data.reset();
                this.store.seek(i * this.pageSize);
                this.store.readFully(data.getBytes(), 0, this.pageSize);
                CRC32 cRC32 = new CRC32();
                cRC32.update(data.getBytes(), 4, this.pageSize - 4);
                n = (int)cRC32.getValue();
                int n6 = data.readInt();
                long l2 = data.readLong();
                int n7 = data.readInt();
                int n8 = data.readInt();
                int n9 = data.readInt();
                if (n == n6) {
                    n2 = n7;
                    n4 = n8;
                    n5 = n9;
                }
                printWriter.println("-- head " + i + ": writeCounter: " + l2 + " log key: " + n7 + " trunk: " + n8 + "/" + n9 + " crc expected " + n + " got " + n6 + " (" + (n == n6 ? "ok" : "different") + ")");
            }
            printWriter.println("-- firstTrunkPage: " + n4 + " firstDataPage: " + n5);
            PrintWriter printWriter2 = new PrintWriter(new OutputStream(){

                public void write(int n) {
                }
            });
            this.dumpPageStore(printWriter2, n3);
            this.stat = new Stats();
            this.schema.clear();
            this.objectIdSet = New.hashSet();
            this.dumpPageStore(printWriter, n3);
            this.writeSchema(printWriter);
            try {
                this.dumpPageLogStream(printWriter, n2, n4, n5);
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            printWriter.println("---- Statistics ----------");
            printWriter.println("-- page count: " + n3 + " free: " + this.stat.free);
            printWriter.println("-- page data head: " + this.stat.pageDataHead + " empty: " + this.stat.pageDataEmpty + " rows: " + this.stat.pageDataRows);
            for (int i = 0; i < this.stat.pageTypeCount.length; ++i) {
                n = this.stat.pageTypeCount[i];
                if (n <= 0) continue;
                printWriter.println("-- page count type: " + i + " " + 100 * n / n3 + "% count: " + n);
            }
            printWriter.close();
        }
        catch (Throwable throwable) {
            try {
                this.writeError(printWriter, throwable);
            }
            catch (Throwable throwable2) {
                IOUtils.closeSilently(printWriter);
                this.closeSilently(this.store);
                throw throwable2;
            }
            IOUtils.closeSilently(printWriter);
            this.closeSilently(this.store);
        }
        IOUtils.closeSilently(printWriter);
        this.closeSilently(this.store);
    }

    private void dumpPageStore(PrintWriter printWriter, int n) {
        Data data = Data.create((DataHandler)this, this.pageSize);
        block13: for (int i = 3; i < n; ++i) {
            data = Data.create((DataHandler)this, this.pageSize);
            this.store.seek(i * this.pageSize);
            this.store.readFully(data.getBytes(), 0, this.pageSize);
            int n2 = data.readByte();
            switch (n2) {
                case 0: {
                    int n3 = n2;
                    this.stat.pageTypeCount[n3] = this.stat.pageTypeCount[n3] + 1;
                    continue block13;
                }
                default: {
                    boolean bl = (n2 & 0x10) != 0;
                    n2 &= 0xFFFFFFEF;
                    if (!PageStore.checksumTest(data.getBytes(), i, this.pageSize)) {
                        printWriter.println("-- ERROR: page " + i + " checksum mismatch type: " + n2);
                    }
                    data.readShortInt();
                    switch (n2) {
                        case 1: {
                            int n4 = n2;
                            this.stat.pageTypeCount[n4] = this.stat.pageTypeCount[n4] + 1;
                            int n5 = data.readInt();
                            this.setStorage(data.readVarInt());
                            int n6 = data.readVarInt();
                            short s = data.readShortInt();
                            printWriter.println("-- page " + i + ": data leaf " + (bl ? "(last)" : "") + " parent: " + n5 + " table: " + this.storageId + " entries: " + s + " columns: " + n6);
                            this.dumpPageDataLeaf(printWriter, data, bl, i, n6, s);
                            continue block13;
                        }
                        case 2: {
                            int n7 = n2;
                            this.stat.pageTypeCount[n7] = this.stat.pageTypeCount[n7] + 1;
                            int n5 = data.readInt();
                            this.setStorage(data.readVarInt());
                            int n6 = data.readInt();
                            short s = data.readShortInt();
                            printWriter.println("-- page " + i + ": data node " + (bl ? "(last)" : "") + " parent: " + n5 + " entries: " + s + " rowCount: " + n6);
                            this.dumpPageDataNode(printWriter, data, i, s);
                            continue block13;
                        }
                        case 3: {
                            int n8 = n2;
                            this.stat.pageTypeCount[n8] = this.stat.pageTypeCount[n8] + 1;
                            printWriter.println("-- page " + i + ": data overflow " + (bl ? "(last)" : ""));
                            continue block13;
                        }
                        case 4: {
                            int n9 = n2;
                            this.stat.pageTypeCount[n9] = this.stat.pageTypeCount[n9] + 1;
                            int n5 = data.readInt();
                            this.setStorage(data.readVarInt());
                            int n6 = data.readShortInt();
                            printWriter.println("-- page " + i + ": b-tree leaf " + (bl ? "(last)" : "") + " parent: " + n5 + " index: " + this.storageId + " entries: " + n6);
                            if (!this.trace) continue block13;
                            this.dumpPageBtreeLeaf(printWriter, data, n6, !bl);
                            continue block13;
                        }
                        case 5: {
                            int n10 = n2;
                            this.stat.pageTypeCount[n10] = this.stat.pageTypeCount[n10] + 1;
                            int n5 = data.readInt();
                            this.setStorage(data.readVarInt());
                            printWriter.println("-- page " + i + ": b-tree node" + (bl ? "(last)" : "") + " parent: " + n5 + " index: " + this.storageId);
                            this.dumpPageBtreeNode(printWriter, data, i, !bl);
                            continue block13;
                        }
                        case 6: {
                            int n11 = n2;
                            this.stat.pageTypeCount[n11] = this.stat.pageTypeCount[n11] + 1;
                            printWriter.println("-- page " + i + ": free list " + (bl ? "(last)" : ""));
                            this.stat.free += this.dumpPageFreeList(printWriter, data, i, n);
                            continue block13;
                        }
                        case 7: {
                            int n12 = n2;
                            this.stat.pageTypeCount[n12] = this.stat.pageTypeCount[n12] + 1;
                            printWriter.println("-- page " + i + ": log trunk");
                            continue block13;
                        }
                        case 8: {
                            int n13 = n2;
                            this.stat.pageTypeCount[n13] = this.stat.pageTypeCount[n13] + 1;
                            printWriter.println("-- page " + i + ": log data");
                            continue block13;
                        }
                        default: {
                            printWriter.println("-- ERROR page " + i + " unknown type " + n2);
                        }
                    }
                }
            }
        }
    }

    private void dumpPageLogStream(PrintWriter printWriter, int n, int n2, int n3) throws IOException {
        byte by;
        Data data = Data.create((DataHandler)this, this.pageSize);
        DataReader dataReader = new DataReader(new PageInputStream(printWriter, this, this.store, n, n2, n3, this.pageSize));
        printWriter.println("---- Transaction log ----------");
        CompressLZF compressLZF = new CompressLZF();
        while ((by = dataReader.read()) >= 0) {
            int n4;
            if (by == 0) continue;
            if (by == 1) {
                Object object;
                n4 = dataReader.readVarInt();
                int n5 = dataReader.readVarInt();
                byte[] byArray = new byte[this.pageSize];
                if (n5 == 0) {
                    dataReader.readFully(byArray, 0, this.pageSize);
                } else if (n5 != 1) {
                    object = new byte[n5];
                    dataReader.readFully((byte[])object, 0, n5);
                    compressLZF.expand((byte[])object, 0, n5, byArray, 0, this.pageSize);
                }
                object = "";
                int n6 = byArray[0];
                boolean bl = (n6 & 0x10) != 0;
                switch (n6 &= 0xFFFFFFEF) {
                    case 0: {
                        object = "empty";
                        break;
                    }
                    case 1: {
                        object = "data leaf " + (bl ? "(last)" : "");
                        break;
                    }
                    case 2: {
                        object = "data node " + (bl ? "(last)" : "");
                        break;
                    }
                    case 3: {
                        object = "data overflow " + (bl ? "(last)" : "");
                        break;
                    }
                    case 4: {
                        object = "b-tree leaf " + (bl ? "(last)" : "");
                        break;
                    }
                    case 5: {
                        object = "b-tree node " + (bl ? "(last)" : "");
                        break;
                    }
                    case 6: {
                        object = "free list " + (bl ? "(last)" : "");
                        break;
                    }
                    case 7: {
                        object = "log trunk";
                        break;
                    }
                    case 8: {
                        object = "log data";
                        break;
                    }
                    default: {
                        object = "ERROR: unknown type " + n6;
                    }
                }
                printWriter.println("-- undo page " + n4 + " " + (String)object);
                continue;
            }
            if (by == 5) {
                n4 = dataReader.readVarInt();
                this.setStorage(dataReader.readVarInt());
                Row row = PageLog.readRow(dataReader, data);
                printWriter.println("-- session " + n4 + " table " + this.storageId + " add " + row.toString());
                continue;
            }
            if (by == 6) {
                n4 = dataReader.readVarInt();
                this.setStorage(dataReader.readVarInt());
                long l = dataReader.readVarLong();
                printWriter.println("-- session " + n4 + " table " + this.storageId + " remove " + l);
                continue;
            }
            if (by == 7) {
                n4 = dataReader.readVarInt();
                this.setStorage(dataReader.readVarInt());
                printWriter.println("-- session " + n4 + " table " + this.storageId + " truncate");
                continue;
            }
            if (by == 2) {
                n4 = dataReader.readVarInt();
                printWriter.println("-- commit " + n4);
                continue;
            }
            if (by == 4) {
                n4 = dataReader.readVarInt();
                printWriter.println("-- rollback " + n4);
                continue;
            }
            if (by == 3) {
                n4 = dataReader.readVarInt();
                String string = dataReader.readString();
                printWriter.println("-- prepare commit " + n4 + " " + string);
                continue;
            }
            if (by == 0) continue;
            if (by == 8) {
                printWriter.println("-- checkpoint");
                continue;
            }
            if (by == 9) {
                n4 = dataReader.readVarInt();
                StringBuilder stringBuilder = new StringBuilder("-- free");
                for (int i = 0; i < n4; ++i) {
                    stringBuilder.append(' ').append(dataReader.readVarInt());
                }
                printWriter.println(stringBuilder);
                continue;
            }
            printWriter.println("-- ERROR: unknown operation " + by);
            break;
        }
    }

    private String setStorage(int n) {
        this.storageId = n;
        this.storageName = "O_" + String.valueOf(n).replace('-', 'M');
        return this.storageName;
    }

    private void dumpPageBtreeNode(PrintWriter printWriter, Data data, int n, boolean bl) {
        int n2;
        int n3;
        int n4 = data.readInt();
        int n5 = data.readShortInt();
        int[] nArray = new int[n5 + 1];
        int[] nArray2 = new int[n5];
        nArray[n5] = data.readInt();
        this.checkParent(printWriter, n, nArray, n5);
        int n6 = Integer.MAX_VALUE;
        for (n3 = 0; n3 < n5; ++n3) {
            nArray[n3] = data.readInt();
            this.checkParent(printWriter, n, nArray, n3);
            n2 = data.readShortInt();
            n6 = Math.min(n2, n6);
            nArray2[n3] = n2;
        }
        n6 -= data.length();
        if (!this.trace) {
            return;
        }
        printWriter.println("--   empty: " + n6);
        for (n3 = 0; n3 < n5; ++n3) {
            Value value;
            n2 = nArray2[n3];
            data.setPos(n2);
            long l = data.readVarLong();
            if (bl) {
                value = ValueLong.get(l);
            } else {
                try {
                    value = data.readValue();
                }
                catch (Throwable throwable) {
                    this.writeDataError(printWriter, "exception " + throwable, data.getBytes());
                    continue;
                }
            }
            printWriter.println("-- [" + n3 + "] child: " + nArray[n3] + " key: " + l + " data: " + value);
        }
        printWriter.println("-- [" + n5 + "] child: " + nArray[n5] + " rowCount: " + n4);
    }

    private int dumpPageFreeList(PrintWriter printWriter, Data data, long l, long l2) {
        int n;
        int n2 = PageFreeList.getPagesAddressed(this.pageSize);
        BitSet bitSet = new BitSet();
        for (n = 0; n < n2; n += 8) {
            int n3 = data.readByte() & 0xFF;
            for (int i = 0; i < 8; ++i) {
                if ((n3 & 1 << i) == 0) continue;
                bitSet.set(n + i);
            }
        }
        n = 0;
        long l3 = 0L;
        for (long i = l; l3 < (long)n2 && i < l2; ++l3, ++i) {
            if (l3 == 0L || i % 100L == 0L) {
                if (l3 > 0L) {
                    printWriter.println();
                }
                printWriter.print("-- " + i + " ");
            } else if (i % 20L == 0L) {
                printWriter.print(" - ");
            } else if (i % 10L == 0L) {
                printWriter.print(' ');
            }
            printWriter.print(bitSet.get((int)l3) ? (char)'1' : '0');
            if (bitSet.get((int)l3)) continue;
            ++n;
        }
        printWriter.println();
        return n;
    }

    private void dumpPageBtreeLeaf(PrintWriter printWriter, Data data, int n, boolean bl) {
        int n2;
        int n3;
        int[] nArray = new int[n];
        int n4 = Integer.MAX_VALUE;
        for (n3 = 0; n3 < n; ++n3) {
            n2 = data.readShortInt();
            n4 = Math.min(n2, n4);
            nArray[n3] = n2;
        }
        printWriter.println("--   empty: " + (n4 -= data.length()));
        for (n3 = 0; n3 < n; ++n3) {
            Value value;
            n2 = nArray[n3];
            data.setPos(n2);
            long l = data.readVarLong();
            if (bl) {
                value = ValueLong.get(l);
            } else {
                try {
                    value = data.readValue();
                }
                catch (Throwable throwable) {
                    this.writeDataError(printWriter, "exception " + throwable, data.getBytes());
                    continue;
                }
            }
            printWriter.println("-- [" + n3 + "] key: " + l + " data: " + value);
        }
    }

    private void checkParent(PrintWriter printWriter, long l, int[] nArray, int n) {
        int n2 = nArray[n];
        if (n2 < 0 || n2 >= this.parents.length) {
            printWriter.println("-- ERROR [" + l + "] child[" + n + "]: " + n2 + " >= page count: " + this.parents.length);
        } else if ((long)this.parents[n2] != l) {
            printWriter.println("-- ERROR [" + l + "] child[" + n + "]: " + n2 + " parent: " + this.parents[n2]);
        }
    }

    private void dumpPageDataNode(PrintWriter printWriter, Data data, long l, int n) {
        int n2;
        int[] nArray = new int[n + 1];
        long[] lArray = new long[n];
        nArray[n] = data.readInt();
        this.checkParent(printWriter, l, nArray, n);
        for (n2 = 0; n2 < n; ++n2) {
            nArray[n2] = data.readInt();
            this.checkParent(printWriter, l, nArray, n2);
            lArray[n2] = data.readVarLong();
        }
        if (!this.trace) {
            return;
        }
        for (n2 = 0; n2 < n; ++n2) {
            printWriter.println("-- [" + n2 + "] child: " + nArray[n2] + " key: " + lArray[n2]);
        }
        printWriter.println("-- [" + n + "] child: " + nArray[n]);
    }

    private void dumpPageDataLeaf(PrintWriter printWriter, Data data, boolean bl, long l, int n, int n2) {
        int n3;
        int n4;
        int[] nArray;
        long[] lArray;
        block11: {
            lArray = new long[n2];
            nArray = new int[n2];
            long l2 = 0L;
            if (!bl) {
                l2 = data.readInt();
                printWriter.println("--   next: " + l2);
            }
            int n5 = this.pageSize;
            for (n4 = 0; n4 < n2; ++n4) {
                lArray[n4] = data.readVarLong();
                short s = data.readShortInt();
                n5 = Math.min(s, n5);
                nArray[n4] = s;
            }
            this.stat.pageDataRows += this.pageSize - n5;
            this.stat.pageDataHead += data.length();
            this.stat.pageDataEmpty += (long)(n5 -= data.length());
            if (this.trace) {
                printWriter.println("--   empty: " + n5);
            }
            if (!bl) {
                Data data2 = Data.create((DataHandler)this, this.pageSize);
                data.setPos(this.pageSize);
                long l3 = l;
                while (true) {
                    int n6;
                    this.checkParent(printWriter, l3, new int[]{(int)l2}, 0);
                    l3 = l2;
                    this.store.seek((long)this.pageSize * l2);
                    this.store.readFully(data2.getBytes(), 0, this.pageSize);
                    data2.reset();
                    n3 = data2.readByte();
                    data2.readShortInt();
                    data2.readInt();
                    if (n3 == 19) {
                        n6 = data2.readShortInt();
                        printWriter.println("-- chain: " + l2 + " type: " + n3 + " size: " + n6);
                        data.checkCapacity(n6);
                        data.write(data2.getBytes(), data2.length(), n6);
                        break block11;
                    }
                    if (n3 != 3) break;
                    l2 = data2.readInt();
                    if (l2 == 0L) {
                        this.writeDataError(printWriter, "next:0", data2.getBytes());
                        break block11;
                    }
                    n6 = this.pageSize - data2.length();
                    printWriter.println("-- chain: " + l2 + " type: " + n3 + " size: " + n6 + " next: " + l2);
                    data.checkCapacity(n6);
                    data.write(data2.getBytes(), data2.length(), n6);
                }
                this.writeDataError(printWriter, "type: " + n3, data2.getBytes());
            }
        }
        for (n4 = 0; n4 < n2; ++n4) {
            int n7;
            String string;
            long l4 = lArray[n4];
            n3 = nArray[n4];
            if (this.trace) {
                printWriter.println("-- [" + n4 + "] storage: " + this.storageId + " key: " + l4 + " off: " + n3);
            }
            data.setPos(n3);
            Value[] valueArray = this.createRecord(printWriter, data, n);
            if (valueArray == null) continue;
            this.createTemporaryTable(printWriter);
            this.writeRow(printWriter, data, valueArray);
            if (!this.remove || this.storageId != 0 || !(string = valueArray[3].getString()).startsWith("CREATE USER ") || (n7 = Utils.indexOf(data.getBytes(), "SALT ".getBytes(), n3)) < 0) continue;
            String string2 = string.substring("CREATE USER ".length(), string.indexOf("SALT ") - 1);
            if (string2.startsWith("\"")) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            SHA256 sHA256 = new SHA256();
            byte[] byArray = sHA256.getKeyPasswordHash(string2, "".toCharArray());
            byte[] byArray2 = MathUtils.secureRandomBytes(8);
            byte[] byArray3 = sHA256.getHashWithSalt(byArray, byArray2);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("SALT '").append(Utils.convertBytesToString(byArray2)).append("' HASH '").append(Utils.convertBytesToString(byArray3)).append('\'');
            byte[] byArray4 = stringBuilder.toString().getBytes();
            System.arraycopy(byArray4, 0, data.getBytes(), n7, byArray4.length);
            this.store.seek((long)this.pageSize * l);
            this.store.write(data.getBytes(), 0, this.pageSize);
            if (this.trace) {
                this.out.println("User: " + string2);
            }
            this.remove = false;
        }
    }

    private Value[] createRecord(PrintWriter printWriter, Data data, int n) {
        Value[] valueArray;
        this.recordLength = n;
        if (n <= 0) {
            this.writeDataError(printWriter, "columnCount<0", data.getBytes());
            return null;
        }
        try {
            valueArray = new Value[n];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.writeDataError(printWriter, "out of memory", data.getBytes());
            return null;
        }
        return valueArray;
    }

    private void writeRow(PrintWriter printWriter, Data data, Value[] valueArray) {
        Object object;
        Object object2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("INSERT INTO " + this.storageName + " VALUES(");
        this.valueId = 0;
        while (this.valueId < this.recordLength) {
            try {
                object2 = data.readValue();
                valueArray[this.valueId] = object2;
                if (this.valueId > 0) {
                    stringBuilder.append(", ");
                }
                object = this.storageName + "." + this.valueId;
                stringBuilder.append(this.getSQL((String)object, (Value)object2));
            }
            catch (Exception exception) {
                this.writeDataError(printWriter, "exception " + exception, data.getBytes());
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.writeDataError(printWriter, "out of memory", data.getBytes());
            }
            ++this.valueId;
        }
        stringBuilder.append(");");
        printWriter.println(stringBuilder.toString());
        if (this.storageId == 0) {
            try {
                object2 = new SimpleRow(valueArray);
                object = new MetaRecord((SearchRow)object2);
                this.schema.add((MetaRecord)object);
                if (((MetaRecord)object).getObjectType() == 0) {
                    String string = valueArray[3].getString();
                    String string2 = this.extractTableOrViewName(string);
                    this.tableMap.put(((MetaRecord)object).getId(), string2);
                }
            }
            catch (Throwable throwable) {
                this.writeError(printWriter, throwable);
            }
        }
    }

    private void resetSchema() {
        this.schema = New.arrayList();
        this.objectIdSet = New.hashSet();
        this.tableMap = New.hashMap();
        this.columnTypeMap = New.hashMap();
    }

    private void writeSchema(PrintWriter printWriter) {
        String string;
        Object object;
        printWriter.println("---- Schema ----------");
        Collections.sort(this.schema);
        for (MetaRecord object2 : this.schema) {
            String string2 = object2.getSQL();
            if (!string2.startsWith("CREATE ")) continue;
            printWriter.println(string2 + ";");
        }
        boolean bl = false;
        for (Map.Entry<Integer, String> entry : this.tableMap.entrySet()) {
            object = entry.getKey();
            string = entry.getValue();
            if (!this.objectIdSet.contains(object) || !string.startsWith("INFORMATION_SCHEMA.LOB")) continue;
            this.setStorage((Integer)object);
            printWriter.println("DELETE FROM " + string + ";");
            printWriter.println("INSERT INTO " + string + " SELECT * FROM " + this.storageName + ";");
            if (!string.startsWith("INFORMATION_SCHEMA.LOBS")) continue;
            printWriter.println("UPDATE " + string + " SET TABLE = " + -2 + ";");
            bl = true;
        }
        for (Map.Entry<Integer, String> entry : this.tableMap.entrySet()) {
            object = entry.getKey();
            string = entry.getValue();
            if (!this.objectIdSet.contains(object)) continue;
            this.setStorage((Integer)object);
            if (string.startsWith("INFORMATION_SCHEMA.LOB")) continue;
            printWriter.println("INSERT INTO " + string + " SELECT * FROM " + this.storageName + ";");
        }
        for (Integer n : this.objectIdSet) {
            this.setStorage(n);
            printWriter.println("DROP TABLE " + this.storageName + ";");
        }
        printWriter.println("DROP ALIAS READ_BLOB;");
        printWriter.println("DROP ALIAS READ_CLOB;");
        printWriter.println("DROP ALIAS READ_BLOB_DB;");
        printWriter.println("DROP ALIAS READ_CLOB_DB;");
        if (bl) {
            printWriter.println("DELETE FROM INFORMATION_SCHEMA.LOBS WHERE TABLE = -2;");
        }
        for (MetaRecord metaRecord : this.schema) {
            object = metaRecord.getSQL();
            if (((String)object).startsWith("CREATE ")) continue;
            printWriter.println((String)object + ";");
        }
    }

    private void createTemporaryTable(PrintWriter printWriter) {
        if (!this.objectIdSet.contains(this.storageId)) {
            this.objectIdSet.add(this.storageId);
            StatementBuilder statementBuilder = new StatementBuilder("CREATE TABLE ");
            statementBuilder.append(this.storageName).append('(');
            for (int i = 0; i < this.recordLength; ++i) {
                statementBuilder.appendExceptFirst(", ");
                statementBuilder.append('C').append(i).append(' ');
                String string = this.columnTypeMap.get(this.storageName + "." + i);
                if (string == null) {
                    statementBuilder.append("VARCHAR");
                    continue;
                }
                statementBuilder.append(string);
            }
            printWriter.println(statementBuilder.append(");").toString());
            printWriter.flush();
        }
    }

    private String extractTableOrViewName(String string) {
        int n = string.indexOf(" TABLE ");
        int n2 = string.indexOf(" VIEW ");
        if (n > 0 && n2 > 0) {
            if (n < n2) {
                n2 = -1;
            } else {
                n = -1;
            }
        }
        if (n2 > 0) {
            string = string.substring(n2 + " VIEW ".length());
        } else if (n > 0) {
            string = string.substring(n + " TABLE ".length());
        } else {
            return "UNKNOWN";
        }
        if (string.startsWith("IF NOT EXISTS ")) {
            string = string.substring("IF NOT EXISTS ".length());
        }
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                bl = !bl;
                continue;
            }
            if (bl || c > ' ' && c != '(') continue;
            string = string.substring(0, i);
            return string;
        }
        return "UNKNOWN";
    }

    private void closeSilently(FileStore fileStore) {
        if (fileStore != null) {
            fileStore.closeSilently();
        }
    }

    private void writeError(PrintWriter printWriter, Throwable throwable) {
        if (printWriter != null) {
            printWriter.println("// error: " + throwable);
        }
        this.traceError("Error", throwable);
    }

    @Override
    public String getDatabasePath() {
        return this.databaseName;
    }

    @Override
    public FileStore openFile(String string, String string2, boolean bl) {
        return FileStore.open(this, string, "rw");
    }

    @Override
    public void checkPowerOff() {
    }

    @Override
    public void checkWritingAllowed() {
    }

    @Override
    public void freeUpDiskSpace() {
    }

    @Override
    public int getMaxLengthInplaceLob() {
        throw DbException.throwInternalError();
    }

    @Override
    public String getLobCompressionAlgorithm(int n) {
        return null;
    }

    @Override
    public Object getLobSyncObject() {
        return this;
    }

    @Override
    public SmallLRUCache<String, String[]> getLobFileListCache() {
        return null;
    }

    @Override
    public TempFileDeleter getTempFileDeleter() {
        return TempFileDeleter.getInstance();
    }

    @Override
    public LobStorage getLobStorage() {
        return null;
    }

    @Override
    public Connection getLobConnection() {
        return null;
    }

    static class PageInputStream
    extends InputStream {
        private final PrintWriter writer;
        private final FileStore store;
        private final Data page;
        private final int pageSize;
        private int trunkPage;
        private int dataPage;
        private IntArray dataPages = new IntArray();
        private boolean endOfFile;
        private int remaining;
        private int logKey;

        public PageInputStream(PrintWriter printWriter, DataHandler dataHandler, FileStore fileStore, int n, int n2, int n3, int n4) {
            this.writer = printWriter;
            this.store = fileStore;
            this.pageSize = n4;
            this.logKey = n - 1;
            this.trunkPage = n2;
            this.dataPage = n3;
            this.page = Data.create(dataHandler, n4);
        }

        public int read() {
            byte[] byArray = new byte[]{0};
            int n = this.read(byArray);
            return n < 0 ? -1 : byArray[0] & 0xFF;
        }

        public int read(byte[] byArray) {
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n, int n2) {
            int n3;
            if (n2 == 0) {
                return 0;
            }
            int n4 = 0;
            while (n2 > 0 && (n3 = this.readBlock(byArray, n, n2)) >= 0) {
                n4 += n3;
                n += n3;
                n2 -= n3;
            }
            return n4 == 0 ? -1 : n4;
        }

        private int readBlock(byte[] byArray, int n, int n2) {
            this.fillBuffer();
            if (this.endOfFile) {
                return -1;
            }
            int n3 = Math.min(this.remaining, n2);
            this.page.read(byArray, n, n3);
            this.remaining -= n3;
            return n3;
        }

        private void fillBuffer() {
            int n;
            int n2;
            int n3;
            int n4;
            if (this.remaining > 0 || this.endOfFile) {
                return;
            }
            while (this.dataPages.size() == 0) {
                if (this.trunkPage == 0) {
                    this.endOfFile = true;
                    return;
                }
                this.store.seek((long)this.trunkPage * (long)this.pageSize);
                this.store.readFully(this.page.getBytes(), 0, this.pageSize);
                this.page.reset();
                if (!PageStore.checksumTest(this.page.getBytes(), this.trunkPage, this.pageSize)) {
                    this.writer.println("-- ERROR: checksum mismatch page: " + this.trunkPage);
                    this.endOfFile = true;
                    return;
                }
                n4 = this.page.readByte();
                this.page.readShortInt();
                if (n4 != 7) {
                    this.writer.println("-- eof  page: " + this.trunkPage + " type: " + n4 + " expected type: " + 7);
                    this.endOfFile = true;
                    return;
                }
                this.page.readInt();
                n3 = this.page.readInt();
                ++this.logKey;
                if (n3 != this.logKey) {
                    this.writer.println("-- eof  page: " + this.trunkPage + " type: " + n4 + " expected key: " + this.logKey + " got: " + n3);
                }
                this.trunkPage = this.page.readInt();
                n2 = this.page.readShortInt();
                for (n = 0; n < n2; ++n) {
                    int n5 = this.page.readInt();
                    if (this.dataPage != 0) {
                        if (n5 != this.dataPage) continue;
                        this.dataPage = 0;
                    }
                    this.dataPages.add(n5);
                }
            }
            if (this.dataPages.size() > 0) {
                this.page.reset();
                n4 = this.dataPages.get(0);
                this.dataPages.remove(0);
                this.store.seek((long)n4 * (long)this.pageSize);
                this.store.readFully(this.page.getBytes(), 0, this.pageSize);
                this.page.reset();
                n3 = this.page.readByte();
                if (n3 != 0 && !PageStore.checksumTest(this.page.getBytes(), n4, this.pageSize)) {
                    this.writer.println("-- ERROR: checksum mismatch page: " + n4);
                    this.endOfFile = true;
                    return;
                }
                this.page.readShortInt();
                n2 = this.page.readInt();
                n = this.page.readInt();
                if (n3 != 8) {
                    this.writer.println("-- eof  page: " + n4 + " type: " + n3 + " parent: " + n2 + " expected type: " + 8);
                    this.endOfFile = true;
                    return;
                }
                if (n != this.logKey) {
                    this.writer.println("-- eof  page: " + n4 + " type: " + n3 + " parent: " + n2 + " expected key: " + this.logKey + " got: " + n);
                    this.endOfFile = true;
                    return;
                }
                this.remaining = this.pageSize - this.page.length();
            }
        }
    }

    class Stats {
        long pageDataEmpty;
        int pageDataRows;
        int pageDataHead;
        int[] pageTypeCount = new int[10];
        int free;

        Stats() {
        }
    }
}

