/*
 * Decompiled with CFR 0.152.
 */
package org.h2.java;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import org.h2.java.ArrayAccessExpr;
import org.h2.java.ArrayInitExpr;
import org.h2.java.AssignExpr;
import org.h2.java.BreakStatement;
import org.h2.java.CallExpr;
import org.h2.java.CastExpr;
import org.h2.java.ClassObj;
import org.h2.java.ConditionalExpr;
import org.h2.java.ContinueStatement;
import org.h2.java.DoWhileStatement;
import org.h2.java.EmptyStatement;
import org.h2.java.Expr;
import org.h2.java.ExprStatement;
import org.h2.java.FieldObj;
import org.h2.java.ForStatement;
import org.h2.java.IfStatement;
import org.h2.java.LiteralExpr;
import org.h2.java.MethodObj;
import org.h2.java.NewExpr;
import org.h2.java.OpExpr;
import org.h2.java.ParseState;
import org.h2.java.ReturnStatement;
import org.h2.java.Statement;
import org.h2.java.StatementBlock;
import org.h2.java.StatementNative;
import org.h2.java.StringExpr;
import org.h2.java.SwitchStatement;
import org.h2.java.Type;
import org.h2.java.VarDecStatement;
import org.h2.java.VariableExpr;
import org.h2.java.WhileStatement;

public class JavaParser {
    private static final int TOKEN_LITERAL_CHAR = 0;
    private static final int TOKEN_LITERAL_STRING = 1;
    private static final int TOKEN_LITERAL_NUMBER = 2;
    private static final int TOKEN_RESERVED = 3;
    private static final int TOKEN_IDENTIFIER = 4;
    private static final int TOKEN_OTHER = 5;
    private static final HashSet<String> RESERVED = new HashSet();
    private static final HashMap<String, String> JAVA_IMPORT_MAP = new HashMap();
    private final ArrayList<ClassObj> allClasses = new ArrayList();
    private final HashMap<String, ClassObj> builtInTypes = new HashMap();
    private String source;
    private ParseState current = new ParseState();
    private String packageName;
    private ClassObj classObj;
    private int nextClassId;
    private MethodObj method;
    private FieldObj thisPointer;
    private HashMap<String, String> importMap = new HashMap();
    private HashMap<String, ClassObj> classes = new HashMap();
    private LinkedHashMap<String, FieldObj> localVars = new LinkedHashMap();
    private HashMap<String, MethodObj> allMethodsMap = new HashMap();
    private ArrayList<Statement> nativeHeaders = new ArrayList();

    public JavaParser() {
        this.addBuiltInTypes();
    }

    private void addBuiltInTypes() {
        String[] stringArray;
        String[] stringArray2;
        for (String string : stringArray2 = new String[]{"abstract", "continue", "for", "new", "switch", "assert", "default", "if", "package", "synchronized", "boolean", "do", "goto", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while", "true", "false", "null"}) {
            RESERVED.add(string);
        }
        int n = 0;
        this.addBuiltInType(n++, true, 0, "void");
        this.addBuiltInType(n++, true, 1, "boolean");
        this.addBuiltInType(n++, true, 2, "byte");
        this.addBuiltInType(n++, true, 3, "short");
        this.addBuiltInType(n++, true, 4, "char");
        this.addBuiltInType(n++, true, 5, "int");
        this.addBuiltInType(n++, true, 6, "long");
        this.addBuiltInType(n++, true, 7, "float");
        this.addBuiltInType(n++, true, 8, "double");
        for (String string : stringArray = new String[]{"Boolean", "Byte", "Character", "Class", "ClassLoader", "Double", "Float", "Integer", "Long", "Math", "Number", "Object", "Runtime", "Short", "String", "StringBuffer", "StringBuilder", "System", "Thread", "ThreadGroup", "ThreadLocal", "Throwable", "Void"}) {
            JAVA_IMPORT_MAP.put(string, "java.lang." + string);
            this.addBuiltInType(n++, false, 0, "java.lang." + string);
        }
        this.nextClassId = n;
    }

    ClassObj getWrapper(ClassObj classObj) {
        switch (classObj.id) {
            case 1: {
                return this.getClass("java.lang.Boolean");
            }
            case 2: {
                return this.getClass("java.lang.Byte");
            }
            case 3: {
                return this.getClass("java.lang.Short");
            }
            case 4: {
                return this.getClass("java.lang.Character");
            }
            case 5: {
                return this.getClass("java.lang.Integer");
            }
            case 6: {
                return this.getClass("java.lang.Long");
            }
            case 7: {
                return this.getClass("java.lang.Float");
            }
            case 8: {
                return this.getClass("java.lang.Double");
            }
        }
        throw new RuntimeException("not a primitive type: " + this.classObj);
    }

    private void addBuiltInType(int n, boolean bl, int n2, String string) {
        ClassObj classObj = new ClassObj();
        classObj.id = n;
        classObj.className = string;
        classObj.isPrimitive = bl;
        classObj.primitiveType = n2;
        this.builtInTypes.put(string, classObj);
        this.addClass(classObj);
    }

    private void addClass(ClassObj classObj) {
        int n = classObj.id;
        while (n >= this.allClasses.size()) {
            this.allClasses.add(null);
        }
        this.allClasses.set(n, classObj);
    }

    void parse(String string, String string2) {
        String string3 = string + "/" + string2.replace('.', '/') + ".java";
        this.current = new ParseState();
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(string3, "r");
            byte[] byArray = new byte[(int)randomAccessFile.length()];
            randomAccessFile.readFully(byArray);
            this.source = new String(byArray, "UTF-8");
            randomAccessFile.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.source = JavaParser.replaceUnicode(this.source);
        this.source = JavaParser.removeRemarks(this.source);
        try {
            this.readToken();
            this.parseCompilationUnit();
        }
        catch (Exception exception) {
            throw new RuntimeException(this.source.substring(0, this.current.index) + "[*]" + this.source.substring(this.current.index), exception);
        }
    }

    private String cleanPackageName(String string) {
        if (string.startsWith("org.h2.java.lang") || string.startsWith("org.h2.java.io")) {
            return string.substring("org.h2.".length());
        }
        return string;
    }

    private void parseCompilationUnit() {
        Object object;
        if (this.readIf("package")) {
            this.packageName = this.cleanPackageName(this.readQualifiedIdentifier());
            this.read(";");
        }
        while (this.readIf("import")) {
            object = this.cleanPackageName(this.readQualifiedIdentifier());
            String string = ((String)object).substring(((String)object).lastIndexOf(46) + 1);
            this.importMap.put(string, (String)object);
            this.read(";");
        }
        while ((object = this.readNativeStatementIf()) != null) {
            this.nativeHeaders.add((Statement)object);
        }
        do {
            boolean bl;
            boolean bl2 = this.readIf("public");
            if (this.readIf("class")) {
                bl = false;
            } else {
                this.read("interface");
                bl = true;
            }
            String string = this.readIdentifier();
            this.classObj = this.builtInTypes.get(this.packageName + "." + string);
            if (this.classObj == null) {
                this.classObj = new ClassObj();
                ++this.nextClassId;
                this.classObj.id = this.classObj.id;
            }
            this.classObj.isPublic = bl2;
            this.classObj.isInterface = bl;
            this.classObj.className = this.packageName == null ? "" : this.packageName + "." + string;
            this.importMap.put(string, this.classObj.className);
            this.addClass(this.classObj);
            this.classes.put(this.classObj.className, this.classObj);
            if (this.readIf("extends")) {
                this.classObj.superClassName = this.readQualifiedIdentifier();
            }
            if (this.readIf("implements")) {
                do {
                    this.classObj.interfaceNames.add(this.readQualifiedIdentifier());
                } while (this.readIf(","));
            }
            this.parseClassBody();
        } while (this.current.token != null);
    }

    private boolean isTypeOrIdentifier() {
        if (this.builtInTypes.containsKey(this.current.token)) {
            return true;
        }
        return this.current.type == 4;
    }

    private ClassObj getClass(String string) {
        ClassObj classObj = this.getClassIf(string);
        if (classObj == null) {
            throw new RuntimeException("Unknown type: " + string);
        }
        return classObj;
    }

    private ClassObj getClassIf(String string) {
        ClassObj classObj = this.builtInTypes.get(string);
        if (classObj != null) {
            return classObj;
        }
        classObj = this.classes.get(string);
        if (classObj != null) {
            return classObj;
        }
        String string2 = this.importMap.get(string);
        if (string2 == null && (string2 = JAVA_IMPORT_MAP.get(string)) == null) {
            return null;
        }
        classObj = this.classes.get(string2);
        if (classObj == null && (classObj = this.builtInTypes.get(string2)) == null) {
            throw new RuntimeException("Unknown class: " + string2);
        }
        return classObj;
    }

    private void parseClassBody() {
        this.read("{");
        this.localVars.clear();
        while (!this.readIf("}")) {
            String string;
            Statement statement;
            this.thisPointer = null;
            while ((statement = this.readNativeStatementIf()) != null) {
                this.classObj.nativeCode.add(statement);
            }
            this.thisPointer = null;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            while (true) {
                if (this.readIf("static")) {
                    bl = true;
                    continue;
                }
                if (this.readIf("final")) {
                    bl2 = true;
                    continue;
                }
                if (this.readIf("native")) {
                    bl5 = true;
                    continue;
                }
                if (this.readIf("private")) {
                    bl3 = true;
                    continue;
                }
                if (!this.readIf("public")) break;
                bl4 = true;
            }
            if (this.readIf("{")) {
                this.method = new MethodObj();
                this.method.name = bl ? "cl_init_obj" : "init_obj";
                this.method.isStatic = bl;
                this.localVars.clear();
                if (!bl) {
                    this.initThisPointer();
                }
                this.method.block = this.readStatement();
                this.classObj.addMethod(this.method);
                continue;
            }
            String string2 = this.readTypeOrIdentifier();
            Type type = this.readType(string2);
            this.method = new MethodObj();
            this.method.returnType = type;
            this.method.isStatic = bl;
            this.method.isFinal = bl2;
            this.method.isPublic = bl4;
            this.method.isPrivate = bl3;
            this.method.isNative = bl5;
            this.localVars.clear();
            if (!bl) {
                this.initThisPointer();
            }
            if (this.readIf("(")) {
                if (type.classObj != this.classObj) {
                    throw this.getSyntaxException("Constructor of wrong type: " + type);
                }
                this.method.name = "init_obj";
                this.method.isConstructor = true;
                this.parseFormalParameters(this.method);
                if (!this.readIf(";")) {
                    this.method.block = this.readStatement();
                }
                this.classObj.addMethod(this.method);
                this.addMethod(this.method);
                continue;
            }
            this.method.name = string = this.readIdentifier();
            if (this.readIf("(")) {
                this.parseFormalParameters(this.method);
                if (!this.readIf(";")) {
                    this.method.block = this.readStatement();
                }
                this.classObj.addMethod(this.method);
                this.addMethod(this.method);
                continue;
            }
            FieldObj fieldObj = new FieldObj();
            fieldObj.type = type;
            fieldObj.name = string;
            fieldObj.isStatic = bl;
            fieldObj.isFinal = bl2;
            fieldObj.isPublic = bl4;
            fieldObj.isPrivate = bl3;
            fieldObj.declaredClass = this.classObj;
            if (bl) {
                this.classObj.addStaticField(fieldObj);
            } else {
                this.classObj.addInstanceField(fieldObj);
            }
            if (this.readIf("=")) {
                fieldObj.value = fieldObj.type.arrayLevel > 0 && this.readIf("{") ? this.readArrayInit(fieldObj.type) : this.readExpr();
            }
            this.read(";");
        }
    }

    private void addMethod(MethodObj methodObj) {
        if (methodObj.isStatic) {
            return;
        }
        MethodObj methodObj2 = this.allMethodsMap.get(methodObj.name);
        if (methodObj2 != null) {
            methodObj2.isVirtual = true;
            methodObj.isVirtual = true;
        } else {
            this.allMethodsMap.put(methodObj.name, methodObj);
        }
    }

    private Expr readArrayInit(Type type) {
        ArrayInitExpr arrayInitExpr;
        block1: {
            arrayInitExpr = new ArrayInitExpr();
            arrayInitExpr.type = new Type();
            arrayInitExpr.type.classObj = type.classObj;
            arrayInitExpr.type.arrayLevel = type.arrayLevel - 1;
            if (this.readIf("}")) break block1;
            do {
                arrayInitExpr.list.add(this.readExpr());
                if (this.readIf("}")) break;
                this.read(",");
            } while (!this.readIf("}"));
        }
        return arrayInitExpr;
    }

    private void initThisPointer() {
        this.thisPointer = new FieldObj();
        this.thisPointer.isLocal = true;
        this.thisPointer.name = "this";
        this.thisPointer.type = new Type();
        this.thisPointer.type.classObj = this.classObj;
    }

    private Type readType(String string) {
        Type type = new Type();
        type.classObj = this.getClass(string);
        while (this.readIf("[")) {
            this.read("]");
            ++type.arrayLevel;
        }
        if (this.readIf("...")) {
            ++type.arrayLevel;
            type.isVarArgs = true;
        }
        return type;
    }

    private void parseFormalParameters(MethodObj methodObj) {
        if (this.readIf(")")) {
            return;
        }
        while (true) {
            FieldObj fieldObj = new FieldObj();
            fieldObj.isLocal = true;
            String string = this.readTypeOrIdentifier();
            fieldObj.type = this.readType(string);
            if (fieldObj.type.isVarArgs) {
                methodObj.isVarArgs = true;
            }
            fieldObj.name = this.readIdentifier();
            methodObj.parameters.put(fieldObj.name, fieldObj);
            if (this.readIf(")")) break;
            this.read(",");
        }
    }

    private String readTypeOrIdentifier() {
        if (this.current.type == 3 && this.builtInTypes.containsKey(this.current.token)) {
            return this.read();
        }
        String string = this.readIdentifier();
        while (this.readIf(".")) {
            string = string + "." + this.readIdentifier();
        }
        return string;
    }

    private Statement readNativeStatementIf() {
        if (this.readIf("//")) {
            this.read();
            int n = this.current.index;
            while (this.source.charAt(this.current.index) != '\n') {
                ++this.current.index;
            }
            StatementNative statementNative = new StatementNative();
            statementNative.code = this.source.substring(n, this.current.index).trim();
            this.read();
            return statementNative;
        }
        if (this.readIf("/*")) {
            this.read();
            int n = this.current.index;
            while (this.source.charAt(this.current.index) != '*' || this.source.charAt(this.current.index + 1) != '/') {
                ++this.current.index;
            }
            StatementNative statementNative = new StatementNative();
            statementNative.code = this.source.substring(n, this.current.index).trim();
            this.current.index += 2;
            this.read();
            return statementNative;
        }
        return null;
    }

    private Statement readStatement() {
        Object object;
        Statement statement = this.readNativeStatementIf();
        if (statement != null) {
            return statement;
        }
        if (this.readIf(";")) {
            return new EmptyStatement();
        }
        if (this.readIf("{")) {
            StatementBlock statementBlock = new StatementBlock();
            while (!this.readIf("}")) {
                statementBlock.instructions.add(this.readStatement());
            }
            return statementBlock;
        }
        if (this.readIf("if")) {
            IfStatement ifStatement = new IfStatement();
            this.read("(");
            ifStatement.condition = this.readExpr();
            this.read(")");
            ifStatement.block = this.readStatement();
            if (this.readIf("else")) {
                ifStatement.elseBlock = this.readStatement();
            }
            return ifStatement;
        }
        if (this.readIf("while")) {
            WhileStatement whileStatement = new WhileStatement();
            this.read("(");
            whileStatement.condition = this.readExpr();
            this.read(")");
            whileStatement.block = this.readStatement();
            return whileStatement;
        }
        if (this.readIf("break")) {
            this.read(";");
            return new BreakStatement();
        }
        if (this.readIf("continue")) {
            this.read(";");
            return new ContinueStatement();
        }
        if (this.readIf("switch")) {
            SwitchStatement switchStatement = new SwitchStatement();
            this.read("(");
            switchStatement.expr = this.readExpr();
            this.read(")");
            this.read("{");
            while (true) {
                StatementBlock statementBlock;
                if (this.readIf("default")) {
                    this.read(":");
                    switchStatement.defaultBlock = statementBlock = new StatementBlock();
                    do {
                        statementBlock.instructions.add(this.readStatement());
                    } while (!this.current.token.equals("case") && !this.current.token.equals("default") && !this.current.token.equals("}"));
                    continue;
                }
                if (this.readIf("case")) {
                    switchStatement.cases.add(this.readExpr());
                    this.read(":");
                    statementBlock = new StatementBlock();
                    do {
                        statementBlock.instructions.add(this.readStatement());
                    } while (!this.current.token.equals("case") && !this.current.token.equals("default") && !this.current.token.equals("}"));
                    switchStatement.blocks.add(statementBlock);
                    continue;
                }
                if (this.readIf("}")) break;
            }
            return switchStatement;
        }
        if (this.readIf("for")) {
            ForStatement forStatement = new ForStatement();
            this.read("(");
            ParseState parseState = this.copyParseState();
            try {
                String string = this.readTypeOrIdentifier();
                Type type = this.readType(string);
                String string2 = this.readIdentifier();
                FieldObj fieldObj = new FieldObj();
                fieldObj.name = string2;
                fieldObj.type = type;
                fieldObj.isLocal = true;
                this.localVars.put(string2, fieldObj);
                this.read(":");
                forStatement.iterableType = type;
                forStatement.iterableVariable = string2;
                forStatement.iterable = this.readExpr();
            }
            catch (Exception exception) {
                this.current = parseState;
                forStatement.init = this.readStatement();
                forStatement.condition = this.readExpr();
                this.read(";");
                do {
                    forStatement.updates.add(this.readExpr());
                } while (this.readIf(","));
            }
            this.read(")");
            forStatement.block = this.readStatement();
            return forStatement;
        }
        if (this.readIf("do")) {
            DoWhileStatement doWhileStatement = new DoWhileStatement();
            doWhileStatement.block = this.readStatement();
            this.read("while");
            this.read("(");
            doWhileStatement.condition = this.readExpr();
            this.read(")");
            this.read(";");
            return doWhileStatement;
        }
        if (this.readIf("return")) {
            ReturnStatement returnStatement = new ReturnStatement();
            if (!this.readIf(";")) {
                returnStatement.expr = this.readExpr();
                this.read(";");
            }
            return returnStatement;
        }
        if (this.isTypeOrIdentifier()) {
            object = this.copyParseState();
            String string = this.readTypeOrIdentifier();
            ClassObj classObj = this.getClassIf(string);
            if (classObj != null) {
                VarDecStatement varDecStatement = new VarDecStatement();
                varDecStatement.type = this.readType(string);
                while (true) {
                    String string3 = this.readIdentifier();
                    Expr expr = null;
                    if (this.readIf("=")) {
                        expr = varDecStatement.type.arrayLevel > 0 && this.readIf("{") ? this.readArrayInit(varDecStatement.type) : this.readExpr();
                    }
                    FieldObj fieldObj = new FieldObj();
                    fieldObj.isLocal = true;
                    fieldObj.type = varDecStatement.type;
                    fieldObj.name = string3;
                    this.localVars.put(string3, fieldObj);
                    varDecStatement.variables.add(string3);
                    varDecStatement.values.add(expr);
                    if (this.readIf(";")) break;
                    this.read(",");
                }
                return varDecStatement;
            }
            this.current = object;
        }
        object = new ExprStatement();
        ((ExprStatement)object).expr = this.readExpr();
        this.read(";");
        return object;
    }

    private ParseState copyParseState() {
        ParseState parseState = new ParseState();
        parseState.index = this.current.index;
        parseState.line = this.current.line;
        parseState.token = this.current.token;
        parseState.type = this.current.type;
        return parseState;
    }

    private Expr readExpr() {
        Expr expr = this.readExpr1();
        String string = this.current.token;
        if (this.readIf("=") || this.readIf("+=") || this.readIf("-=") || this.readIf("*=") || this.readIf("/=") || this.readIf("&=") || this.readIf("|=") || this.readIf("^=") || this.readIf("%=") || this.readIf("<<=") || this.readIf(">>=") || this.readIf(">>>=")) {
            AssignExpr assignExpr = new AssignExpr();
            assignExpr.left = expr;
            assignExpr.op = string;
            assignExpr.right = this.readExpr1();
            expr = assignExpr;
        }
        return expr;
    }

    private Expr readExpr1() {
        Expr expr = this.readExpr2();
        if (this.readIf("?")) {
            ConditionalExpr conditionalExpr = new ConditionalExpr();
            conditionalExpr.condition = expr;
            conditionalExpr.ifTrue = this.readExpr();
            this.read(":");
            conditionalExpr.ifFalse = this.readExpr();
            return conditionalExpr;
        }
        return expr;
    }

    private Expr readExpr2() {
        Expr expr = this.readExpr3();
        while (true) {
            String string = this.current.token;
            if (!this.readIf("||") && !this.readIf("&&") && !this.readIf("|") && !this.readIf("^") && !this.readIf("&") && !this.readIf("==") && !this.readIf("!=") && !this.readIf("<") && !this.readIf(">") && !this.readIf("<=") && !this.readIf(">=") && !this.readIf("<<") && !this.readIf(">>") && !this.readIf(">>>") && !this.readIf("+") && !this.readIf("-") && !this.readIf("*") && !this.readIf("/") && !this.readIf("%")) break;
            OpExpr opExpr = new OpExpr(this);
            opExpr.left = expr;
            opExpr.op = string;
            opExpr.right = this.readExpr3();
            expr = opExpr;
        }
        return expr;
    }

    private Expr readExpr3() {
        if (this.readIf("(")) {
            Object object;
            if (this.isTypeOrIdentifier()) {
                object = this.copyParseState();
                String string = this.readTypeOrIdentifier();
                ClassObj classObj = this.getClassIf(string);
                if (classObj != null) {
                    this.read(")");
                    CastExpr castExpr = new CastExpr();
                    castExpr.type = new Type();
                    castExpr.type.classObj = classObj;
                    castExpr.expr = this.readExpr();
                    return castExpr;
                }
                this.current = object;
            }
            object = this.readExpr();
            this.read(")");
            return object;
        }
        String string = this.current.token;
        if (this.readIf("++") || this.readIf("--") || this.readIf("!") || this.readIf("~") || this.readIf("+") || this.readIf("-")) {
            OpExpr opExpr = new OpExpr(this);
            opExpr.op = string;
            opExpr.right = this.readExpr3();
            return opExpr;
        }
        Expr expr = this.readExpr4();
        String string2 = this.current.token;
        if (this.readIf("++") || this.readIf("--")) {
            OpExpr opExpr = new OpExpr(this);
            opExpr.left = expr;
            opExpr.op = string2;
            expr = opExpr;
        }
        return expr;
    }

    private Expr readExpr4() {
        Object object;
        if (this.readIf("false")) {
            LiteralExpr literalExpr = new LiteralExpr(this, "boolean");
            literalExpr.literal = "false";
            return literalExpr;
        }
        if (this.readIf("true")) {
            LiteralExpr literalExpr = new LiteralExpr(this, "boolean");
            literalExpr.literal = "true";
            return literalExpr;
        }
        if (this.readIf("null")) {
            LiteralExpr literalExpr = new LiteralExpr(this, "java.lang.Object");
            literalExpr.literal = "null";
            return literalExpr;
        }
        if (this.current.type == 2) {
            LiteralExpr literalExpr = new LiteralExpr(this, "int");
            literalExpr.literal = this.current.token.substring(1);
            this.readToken();
            return literalExpr;
        }
        Expr expr = this.readExpr5();
        while (this.readIf(".")) {
            Expr expr2;
            object = this.readIdentifier();
            if (this.readIf("(")) {
                expr2 = new CallExpr(this, expr, null, (String)object, false);
                if (!this.readIf(")")) {
                    do {
                        ((CallExpr)expr2).args.add(this.readExpr());
                    } while (this.readIf(","));
                    this.read(")");
                }
                expr = expr2;
                continue;
            }
            expr2 = new VariableExpr(this);
            expr2.base = expr;
            expr = expr2;
            expr2.name = object;
        }
        if (this.readIf("[")) {
            object = new ArrayAccessExpr();
            ((ArrayAccessExpr)object).base = expr;
            ((ArrayAccessExpr)object).index = this.readExpr();
            this.read("]");
            return object;
        }
        return expr;
    }

    private Expr readExpr5() {
        Object object;
        if (this.readIf("new")) {
            NewExpr newExpr = new NewExpr(this);
            String string = this.readTypeOrIdentifier();
            newExpr.classObj = this.getClass(string);
            if (this.readIf("(")) {
                if (!this.readIf(")")) {
                    do {
                        newExpr.args.add(this.readExpr());
                    } while (this.readIf(","));
                    this.read(")");
                }
            } else {
                while (this.readIf("[")) {
                    newExpr.arrayInitExpr.add(this.readExpr());
                    this.read("]");
                }
            }
            return newExpr;
        }
        if (this.current.type == 1) {
            StringExpr stringExpr = new StringExpr(this);
            stringExpr.text = this.current.token.substring(1);
            this.readToken();
            return stringExpr;
        }
        if (this.readIf("this")) {
            VariableExpr variableExpr = new VariableExpr(this);
            variableExpr.field = this.thisPointer;
            if (this.thisPointer == null) {
                throw this.getSyntaxException("this usage in static context");
            }
            return variableExpr;
        }
        String string = this.readIdentifier();
        if (this.readIf("(")) {
            VariableExpr variableExpr = new VariableExpr(this);
            variableExpr.field = this.thisPointer;
            CallExpr callExpr = new CallExpr(this, variableExpr, this.classObj.className, string, false);
            if (!this.readIf(")")) {
                do {
                    callExpr.args.add(this.readExpr());
                } while (this.readIf(","));
                this.read(")");
            }
            return callExpr;
        }
        VariableExpr variableExpr = new VariableExpr(this);
        FieldObj fieldObj = this.localVars.get(string);
        if (fieldObj == null) {
            fieldObj = this.method.parameters.get(string);
        }
        if (fieldObj == null) {
            fieldObj = this.classObj.staticFields.get(string);
        }
        if (fieldObj == null) {
            fieldObj = this.classObj.instanceFields.get(string);
        }
        if (fieldObj == null) {
            object = this.importMap.get(string);
            if (object == null) {
                object = JAVA_IMPORT_MAP.get(string);
            }
            if (object != null) {
                string = object;
                if (this.readIf(".")) {
                    FieldObj fieldObj2;
                    String string2 = this.readIdentifier();
                    if (this.readIf("(")) {
                        CallExpr callExpr = new CallExpr(this, null, (String)object, string2, true);
                        if (!this.readIf(")")) {
                            do {
                                callExpr.args.add(this.readExpr());
                            } while (this.readIf(","));
                            this.read(")");
                        }
                        return callExpr;
                    }
                    VariableExpr variableExpr2 = new VariableExpr(this);
                    variableExpr2.name = (String)object + "." + string2;
                    ClassObj classObj = this.classes.get(object);
                    variableExpr2.field = fieldObj2 = classObj.staticFields.get(string2);
                    return variableExpr2;
                }
            }
        }
        variableExpr.field = fieldObj;
        if (fieldObj != null && !fieldObj.isLocal && !fieldObj.isStatic) {
            object = new VariableExpr(this);
            ((VariableExpr)object).field = this.thisPointer;
            variableExpr.base = object;
            if (this.thisPointer == null) {
                throw this.getSyntaxException("this usage in static context");
            }
        }
        variableExpr.name = string;
        return variableExpr;
    }

    private void read(String string) {
        if (!this.readIf(string)) {
            throw this.getSyntaxException(string + " expected, got " + this.current.token);
        }
    }

    private String readQualifiedIdentifier() {
        String string;
        String string2 = this.readIdentifier();
        if (this.localVars.containsKey(string2)) {
            return string2;
        }
        if (this.classObj != null) {
            if (this.classObj.staticFields.containsKey(string2)) {
                return string2;
            }
            if (this.classObj.instanceFields.containsKey(string2)) {
                return string2;
            }
        }
        if ((string = this.importMap.get(string2)) != null) {
            return string;
        }
        while (this.readIf(".")) {
            string2 = string2 + "." + this.readIdentifier();
        }
        return string2;
    }

    private String readIdentifier() {
        if (this.current.type != 4) {
            throw this.getSyntaxException("identifier expected, got " + this.current.token);
        }
        String string = this.current.token;
        this.readToken();
        return string;
    }

    private boolean readIf(String string) {
        if (this.current.type != 4 && string.equals(this.current.token)) {
            this.readToken();
            return true;
        }
        return false;
    }

    private String read() {
        String string = this.current.token;
        this.readToken();
        return string;
    }

    private RuntimeException getSyntaxException(String string) {
        return new RuntimeException(string, new ParseException(this.source, this.current.index));
    }

    static String replaceUnicode(String string) {
        if (string.indexOf("\\u") < 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i = 0; i < string.length(); ++i) {
            if (string.substring(i).startsWith("\\\\")) {
                stringBuilder.append("\\\\");
                ++i;
                continue;
            }
            if (string.substring(i).startsWith("\\u")) {
                i += 2;
                while (string.charAt(i) == 'u') {
                    ++i;
                }
                String string2 = string.substring(i, i + 4);
                stringBuilder.append((char)Integer.parseInt(string2, 16));
                i += 4;
                continue;
            }
            stringBuilder.append(string.charAt(i));
        }
        return stringBuilder.toString();
    }

    static String removeRemarks(String string) {
        char[] cArray = string.toCharArray();
        block0: for (int i = 0; i >= 0 && i < string.length(); ++i) {
            int n;
            if (string.charAt(i) == '\'') {
                ++i;
                while (true) {
                    if (string.charAt(i) == '\\') {
                        ++i;
                    } else if (string.charAt(i) == '\'') continue block0;
                    ++i;
                }
            }
            if (string.charAt(i) == '\"') {
                ++i;
                while (true) {
                    if (string.charAt(i) == '\\') {
                        ++i;
                    } else if (string.charAt(i) == '\"') continue block0;
                    ++i;
                }
            }
            String string2 = string.substring(i);
            if (string2.startsWith("/*") && !string2.startsWith("/* c:")) {
                n = i;
                i = string.indexOf("*/", i + 2) + 2;
                while (n < i) {
                    if (cArray[n] > ' ') {
                        cArray[n] = 32;
                    }
                    ++n;
                }
                continue;
            }
            if (!string2.startsWith("//") || string2.startsWith("// c:")) continue;
            n = i;
            i = string.indexOf(10, i);
            while (n < i) {
                cArray[n++] = 32;
            }
        }
        return new String(cArray) + "  ";
    }

    private void readToken() {
        char c;
        while (true) {
            if (this.current.index >= this.source.length()) {
                this.current.token = null;
                return;
            }
            c = this.source.charAt(this.current.index);
            if (c == '\n') {
                ++this.current.line;
            } else if (c > ' ') break;
            ++this.current.index;
        }
        int n = this.current.index;
        if (Character.isJavaIdentifierStart((int)c)) {
            while (Character.isJavaIdentifierPart(this.source.charAt(this.current.index))) {
                ++this.current.index;
            }
            this.current.token = this.source.substring(n, this.current.index);
            this.current.type = RESERVED.contains(this.current.token) ? 3 : 4;
            return;
        }
        if (Character.isDigit((int)c) || c == '.' && Character.isDigit(this.source.charAt(this.current.index + 1))) {
            String string = this.source.substring(this.current.index);
            this.current.token = "0" + JavaParser.readNumber(string);
            this.current.index += this.current.token.length() - 1;
            this.current.type = 2;
            return;
        }
        ++this.current.index;
        switch (c) {
            case '\'': {
                while (true) {
                    if (this.source.charAt(this.current.index) == '\\') {
                        ++this.current.index;
                    } else if (this.source.charAt(this.current.index) == '\'') break;
                    ++this.current.index;
                }
                ++this.current.index;
                this.current.token = this.source.substring(n + 1, this.current.index);
                this.current.token = "'" + JavaParser.javaDecode(this.current.token, '\'');
                this.current.type = 0;
                return;
            }
            case '\"': {
                while (true) {
                    if (this.source.charAt(this.current.index) == '\\') {
                        ++this.current.index;
                    } else if (this.source.charAt(this.current.index) == '\"') break;
                    ++this.current.index;
                }
                ++this.current.index;
                this.current.token = this.source.substring(n + 1, this.current.index);
                this.current.token = "\"" + JavaParser.javaDecode(this.current.token, '\"');
                this.current.type = 1;
                return;
            }
            case '(': 
            case ')': 
            case ',': 
            case ':': 
            case ';': 
            case '?': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                break;
            }
            case '.': {
                if (this.source.charAt(this.current.index) != '.' || this.source.charAt(this.current.index + 1) != '.') break;
                this.current.index += 2;
                break;
            }
            case '+': {
                if (this.source.charAt(this.current.index) != '=' && this.source.charAt(this.current.index) != '+') break;
                ++this.current.index;
                break;
            }
            case '-': {
                if (this.source.charAt(this.current.index) != '=' && this.source.charAt(this.current.index) != '-') break;
                ++this.current.index;
                break;
            }
            case '>': {
                if (this.source.charAt(this.current.index) == '>') {
                    ++this.current.index;
                    if (this.source.charAt(this.current.index) == '>') {
                        ++this.current.index;
                    }
                }
                if (this.source.charAt(this.current.index) != '=') break;
                ++this.current.index;
                break;
            }
            case '<': {
                if (this.source.charAt(this.current.index) == '<') {
                    ++this.current.index;
                }
                if (this.source.charAt(this.current.index) != '=') break;
                ++this.current.index;
                break;
            }
            case '/': {
                if (this.source.charAt(this.current.index) != '*' && this.source.charAt(this.current.index) != '/') break;
                ++this.current.index;
                break;
            }
            case '!': 
            case '%': 
            case '*': 
            case '=': 
            case '^': 
            case '~': {
                if (this.source.charAt(this.current.index) != '=') break;
                ++this.current.index;
                break;
            }
            case '&': {
                if (this.source.charAt(this.current.index) == '&') {
                    ++this.current.index;
                    break;
                }
                if (this.source.charAt(this.current.index) != '=') break;
                ++this.current.index;
                break;
            }
            case '|': {
                if (this.source.charAt(this.current.index) == '|') {
                    ++this.current.index;
                    break;
                }
                if (this.source.charAt(this.current.index) != '=') break;
                ++this.current.index;
            }
        }
        this.current.type = 5;
        this.current.token = this.source.substring(n, this.current.index);
    }

    static String readNumber(String string) {
        int n = 0;
        if (string.startsWith("0x") || string.startsWith("0X")) {
            char c;
            n = 2;
            while ((c = string.charAt(n)) >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') {
                ++n;
            }
            if (string.charAt(n) == 'l' || string.charAt(n) == 'L') {
                ++n;
            }
        } else {
            char c;
            while ((c = string.charAt(n)) >= '0' && c <= '9' || c == '.') {
                ++n;
            }
            if (string.charAt(n) == 'e' || string.charAt(n) == 'E') {
                if (string.charAt(++n) == '-' || string.charAt(n) == '+') {
                    ++n;
                }
                while (Character.isDigit(string.charAt(n))) {
                    ++n;
                }
            }
            if (string.charAt(n) == 'f' || string.charAt(n) == 'F' || string.charAt(n) == 'd' || string.charAt(n) == 'D' || string.charAt(n) == 'L' || string.charAt(n) == 'l') {
                ++n;
            }
        }
        return string.substring(0, n);
    }

    private static RuntimeException getFormatException(String string, int n) {
        return new RuntimeException(new ParseException(string, n));
    }

    private static String javaDecode(String string, char c) {
        char c2;
        StringBuilder stringBuilder = new StringBuilder(string.length());
        block15: for (int i = 0; i < string.length() && (c2 = string.charAt(i)) != c; ++i) {
            if (c2 == '\\') {
                if (i >= string.length()) {
                    throw JavaParser.getFormatException(string, string.length() - 1);
                }
                c2 = string.charAt(++i);
                switch (c2) {
                    case 't': {
                        stringBuilder.append('\t');
                        continue block15;
                    }
                    case 'r': {
                        stringBuilder.append('\r');
                        continue block15;
                    }
                    case 'n': {
                        stringBuilder.append('\n');
                        continue block15;
                    }
                    case 'b': {
                        stringBuilder.append('\b');
                        continue block15;
                    }
                    case 'f': {
                        stringBuilder.append('\f');
                        continue block15;
                    }
                    case '\"': {
                        stringBuilder.append('\"');
                        continue block15;
                    }
                    case '\'': {
                        stringBuilder.append('\'');
                        continue block15;
                    }
                    case '\\': {
                        stringBuilder.append('\\');
                        continue block15;
                    }
                    case 'u': {
                        try {
                            c2 = (char)Integer.parseInt(string.substring(i + 1, i + 5), 16);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw JavaParser.getFormatException(string, i);
                        }
                        i += 4;
                        stringBuilder.append(c2);
                        continue block15;
                    }
                    default: {
                        if (c2 >= '0' && c2 <= '9') {
                            try {
                                c2 = (char)Integer.parseInt(string.substring(i, i + 3), 8);
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw JavaParser.getFormatException(string, i);
                            }
                            i += 2;
                            stringBuilder.append(c2);
                            continue block15;
                        }
                        throw JavaParser.getFormatException(string, i);
                    }
                }
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    void writeHeader(PrintWriter printWriter) {
        for (Statement object : this.nativeHeaders) {
            printWriter.println(object);
        }
        printWriter.println();
        for (ClassObj classObj : this.classes.values()) {
            printWriter.println("/* " + classObj.className + ".h */");
            for (FieldObj fieldObj : classObj.staticFields.values()) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("extern ");
                if (fieldObj.isFinal) {
                    stringBuilder.append("const ");
                }
                stringBuilder.append(JavaParser.toC(fieldObj.type.classObj.toString()));
                if (!fieldObj.type.classObj.isPrimitive) {
                    stringBuilder.append("*");
                }
                stringBuilder.append(" ").append(JavaParser.toC(classObj.className + "." + fieldObj.name));
                for (int i = 0; i < fieldObj.type.arrayLevel; ++i) {
                    stringBuilder.append("[]");
                }
                stringBuilder.append(";");
                printWriter.println(stringBuilder.toString());
            }
            printWriter.println("struct " + JavaParser.toC(classObj.className) + " {");
            for (FieldObj fieldObj : classObj.instanceFields.values()) {
                printWriter.print("    " + JavaParser.toC(fieldObj.type.toString()) + " " + fieldObj.name);
                if (fieldObj.value != null) {
                    printWriter.print(" = " + fieldObj.value);
                }
                printWriter.println(";");
            }
            if (classObj.instanceFields.size() == 0) {
                printWriter.println("int dummy;");
            }
            printWriter.println("};");
            printWriter.println("typedef struct " + JavaParser.toC(classObj.className) + " " + JavaParser.toC(classObj.className) + ";");
            for (ArrayList arrayList : classObj.methods.values()) {
                for (MethodObj methodObj : arrayList) {
                    printWriter.print(methodObj.returnType + " " + JavaParser.toC(classObj.className) + "_" + methodObj.name + "(");
                    int n = 0;
                    if (!methodObj.isStatic && !methodObj.isConstructor) {
                        printWriter.print(JavaParser.toC(classObj.className) + "* this");
                        ++n;
                    }
                    for (FieldObj fieldObj : methodObj.parameters.values()) {
                        if (n > 0) {
                            printWriter.print(", ");
                        }
                        printWriter.print(fieldObj.type + " " + fieldObj.name);
                        ++n;
                    }
                    printWriter.println(");");
                }
            }
            printWriter.println();
        }
        printWriter.println();
        printWriter.println("/* method pointers */");
        for (MethodObj methodObj : this.allMethodsMap.values()) {
            printWriter.print("extern " + methodObj.returnType + " (*virtual_" + methodObj.name + "[])(");
            int n = 0;
            if (!methodObj.isConstructor) {
                printWriter.print("void*");
                ++n;
            }
            for (FieldObj fieldObj : methodObj.parameters.values()) {
                if (n > 0) {
                    printWriter.print(", ");
                }
                printWriter.print(fieldObj.type);
                ++n;
            }
            printWriter.println(");");
            printWriter.println();
        }
    }

    void writeSource(PrintWriter printWriter) {
        printWriter.println("/* method pointers */");
        for (MethodObj object : this.allMethodsMap.values()) {
            printWriter.print(object.returnType + " (*virtual_" + object.name + "[])(");
            int n = 0;
            if (!object.isConstructor) {
                printWriter.print("void*");
                ++n;
            }
            for (FieldObj fieldObj : object.parameters.values()) {
                if (n > 0) {
                    printWriter.print(", ");
                }
                printWriter.print(fieldObj.type);
                ++n;
            }
            printWriter.println(") = {");
            for (ClassObj classObj : this.allClasses) {
                if (classObj != null && classObj.methods.containsKey(object.name)) {
                    printWriter.println(JavaParser.toC(classObj.className) + "_" + object.name + ", ");
                    continue;
                }
                printWriter.print("0, ");
            }
            printWriter.println("};");
        }
        printWriter.println();
        for (ClassObj classObj : this.classes.values()) {
            printWriter.println("/* " + classObj.className + ".c */");
            for (Statement statement : classObj.nativeCode) {
                printWriter.println(statement);
            }
            for (FieldObj fieldObj : classObj.staticFields.values()) {
                StringBuilder stringBuilder = new StringBuilder();
                if (fieldObj.isFinal) {
                    stringBuilder.append("const ");
                }
                stringBuilder.append(JavaParser.toC(fieldObj.type.classObj.toString()));
                if (!fieldObj.type.classObj.isPrimitive) {
                    stringBuilder.append("*");
                }
                stringBuilder.append(" ").append(JavaParser.toC(classObj.className + "." + fieldObj.name));
                for (int i = 0; i < fieldObj.type.arrayLevel; ++i) {
                    stringBuilder.append("[]");
                }
                if (fieldObj.value != null) {
                    stringBuilder.append(" = " + fieldObj.value);
                }
                stringBuilder.append(";");
                printWriter.println(stringBuilder.toString());
            }
            for (ArrayList arrayList : classObj.methods.values()) {
                for (MethodObj methodObj : arrayList) {
                    printWriter.print(methodObj.returnType + " " + JavaParser.toC(classObj.className) + "_" + methodObj.name + "(");
                    int n = 0;
                    if (!methodObj.isStatic && !methodObj.isConstructor) {
                        printWriter.print(JavaParser.toC(classObj.className) + "* this");
                        ++n;
                    }
                    for (FieldObj fieldObj : methodObj.parameters.values()) {
                        if (n > 0) {
                            printWriter.print(", ");
                        }
                        printWriter.print(fieldObj.type + " " + fieldObj.name);
                        ++n;
                    }
                    printWriter.println(") {");
                    if (methodObj.isConstructor) {
                        printWriter.println(JavaParser.indent(JavaParser.toC(classObj.className) + "* this = NEW_OBJ(" + classObj.id + ", " + JavaParser.toC(classObj.className) + ");"));
                    }
                    if (methodObj.block != null) {
                        printWriter.print(methodObj.block.toString());
                    }
                    if (methodObj.isConstructor) {
                        printWriter.println(JavaParser.indent("return this;"));
                    }
                    printWriter.println("}");
                    printWriter.println();
                }
            }
        }
    }

    private static String indent(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + n);
        int n2 = 0;
        while (n2 < string.length()) {
            int n3;
            for (n3 = 0; n3 < n; ++n3) {
                stringBuilder.append(' ');
            }
            n3 = string.indexOf(10, n2);
            n3 = n3 < 0 ? string.length() : n3 + 1;
            stringBuilder.append(string.substring(n2, n3));
            n2 = n3;
        }
        if (!string.endsWith("\n")) {
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    static String indent(String string) {
        return JavaParser.indent(string, 4);
    }

    static String toC(String string) {
        return string.replace('.', '_');
    }

    ClassObj getClassObj() {
        return this.classObj;
    }

    ClassObj getClassObj(String string) {
        ClassObj classObj = this.builtInTypes.get(string);
        if (classObj == null) {
            classObj = this.classes.get(string);
        }
        return classObj;
    }
}

